/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Grayscale16BitHeightMap
extends AbstractHeightMap {
    private BufferedImage image;

    public Grayscale16BitHeightMap() {
    }

    public Grayscale16BitHeightMap(BufferedImage image) {
        this.image = image;
    }

    public Grayscale16BitHeightMap(String filename) {
        this(new File(filename));
    }

    public Grayscale16BitHeightMap(File file) {
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException ex) {
            Logger.getLogger(Grayscale16BitHeightMap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean load() {
        return this.load(false, false);
    }

    public boolean load(boolean flipX, boolean flipY) {
        int imageHeight;
        int imageWidth = this.image.getWidth();
        if (imageWidth != (imageHeight = this.image.getHeight())) {
            throw new RuntimeException("imageWidth: " + imageWidth + " != imageHeight: " + imageHeight);
        }
        Object out = new short[imageWidth * imageHeight];
        Object values = out = (Object)this.image.getData().getDataElements(0, 0, imageWidth, imageHeight, out);
        this.heightData = new float[imageWidth * imageHeight];
        int i = 0;
        for (int y = 0; y < imageHeight; ++y) {
            int x = 0;
            while (x < imageWidth) {
                this.heightData[i] = this.heightScale * (float)(values[i] & 0xFFFF) / 65536.0f;
                ++x;
                ++i;
            }
        }
        return true;
    }
}

