/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.renderer.GLObject;
import com.jme3.renderer.Renderer;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.Uniform;
import com.jme3.util.IntMap;
import com.jme3.util.ListMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Shader
extends GLObject
implements Savable {
    private String language;
    private boolean usable = false;
    private ArrayList<ShaderSource> shaderList;
    private ListMap<String, Uniform> uniforms;
    private IntMap<Attribute> attribs;

    public Shader(String language) {
        super(GLObject.Type.Shader);
        this.language = language;
        this.shaderList = new ArrayList();
        this.uniforms = new ListMap();
        this.attribs = new IntMap();
    }

    public Shader() {
        super(GLObject.Type.Shader);
    }

    protected Shader(Shader s) {
        super(GLObject.Type.Shader, s.id);
        this.shaderList = new ArrayList();
        for (ShaderSource source : s.shaderList) {
            this.shaderList.add((ShaderSource)source.createDestructableClone());
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.language, "language", null);
        oc.writeSavableArrayList(this.shaderList, "shaderList", null);
        oc.writeIntSavableMap(this.attribs, "attribs", null);
        oc.writeStringSavableMap(this.uniforms, "uniforms", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.language = ic.readString("language", null);
        this.shaderList = ic.readSavableArrayList("shaderList", null);
        this.attribs = ic.readIntSavableMap("attribs", null);
        HashMap uniMap = (HashMap)ic.readStringSavableMap("uniforms", null);
        this.uniforms = new ListMap(uniMap);
    }

    public void addSource(ShaderType type, String name, String source, String defines) {
        ShaderSource shader = new ShaderSource(type);
        shader.setSource(source);
        shader.setName(name);
        if (defines != null) {
            shader.setDefines(defines);
        }
        this.shaderList.add(shader);
        this.setUpdateNeeded();
    }

    public void addSource(ShaderType type, String source, String defines) {
        this.addSource(type, null, source, defines);
    }

    public void addSource(ShaderType type, String source) {
        this.addSource(type, source, null);
    }

    private void addSource(ShaderSource source) {
        this.shaderList.add(source);
        this.setUpdateNeeded();
    }

    public Uniform getUniform(String name) {
        Uniform uniform = this.uniforms.get(name);
        if (uniform == null) {
            uniform = new Uniform();
            uniform.name = name;
            this.uniforms.put(name, uniform);
        }
        return uniform;
    }

    public void removeUniform(String name) {
        this.uniforms.remove(name);
    }

    public Attribute getAttribute(VertexBuffer.Type attribType) {
        int ordinal = attribType.ordinal();
        Attribute attrib = this.attribs.get(ordinal);
        if (attrib == null) {
            attrib = new Attribute();
            attrib.name = attribType.name();
            this.attribs.put(ordinal, attrib);
        }
        return attrib;
    }

    public ListMap<String, Uniform> getUniformMap() {
        return this.uniforms;
    }

    public Collection<ShaderSource> getSources() {
        return this.shaderList;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[language=" + this.language + ", numSources=" + this.shaderList.size() + ", numUniforms=" + this.uniforms.size() + ", shaderSources=" + this.getSources() + "]";
    }

    public void resetSources() {
        this.shaderList.clear();
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public void resetLocations() {
        for (Uniform uniform : this.uniforms.values()) {
            uniform.reset();
        }
        for (IntMap.Entry entry : this.attribs) {
            ((Attribute)entry.getValue()).location = -2;
        }
    }

    @Override
    public void setUpdateNeeded() {
        super.setUpdateNeeded();
        this.resetLocations();
    }

    @Override
    public void resetObject() {
        this.id = -1;
        this.usable = false;
        for (ShaderSource source : this.shaderList) {
            source.resetObject();
        }
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Renderer r) {
        r.deleteShader(this);
    }

    @Override
    public GLObject createDestructableClone() {
        return new Shader(this);
    }

    public static class ShaderSource
    extends GLObject
    implements Savable {
        ShaderType shaderType;
        boolean usable = false;
        String name = null;
        String source = null;
        String defines = null;

        public ShaderSource(ShaderType type) {
            super(GLObject.Type.ShaderSource);
            this.shaderType = type;
            if (type == null) {
                throw new NullPointerException("The shader type must be specified");
            }
        }

        protected ShaderSource(ShaderSource ss) {
            super(GLObject.Type.ShaderSource, ss.id);
            this.shaderType = ss.shaderType;
            this.usable = false;
            this.name = ss.name;
        }

        public ShaderSource() {
            super(GLObject.Type.ShaderSource);
        }

        public void write(JmeExporter ex) throws IOException {
            OutputCapsule oc = ex.getCapsule(this);
            oc.write(this.shaderType, "shaderType", null);
            oc.write(this.name, "name", null);
            oc.write(this.source, "source", null);
            oc.write(this.defines, "defines", null);
        }

        public void read(JmeImporter im) throws IOException {
            InputCapsule ic = im.getCapsule(this);
            this.shaderType = ic.readEnum("shaderType", ShaderType.class, null);
            this.name = ic.readString("name", null);
            this.source = ic.readString("source", null);
            this.defines = ic.readString("defines", null);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ShaderType getType() {
            return this.shaderType;
        }

        public void setSource(String source) {
            if (source == null) {
                throw new NullPointerException("Shader source cannot be null");
            }
            this.source = source;
            this.setUpdateNeeded();
        }

        public void setDefines(String defines) {
            if (defines == null) {
                throw new NullPointerException("Shader defines cannot be null");
            }
            this.defines = defines;
            this.setUpdateNeeded();
        }

        public String getSource() {
            return this.source;
        }

        public String getDefines() {
            return this.defines;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void setUsable(boolean usable) {
            this.usable = usable;
        }

        public String toString() {
            String nameTxt = "";
            if (this.name != null) {
                nameTxt = "name=" + this.name + ", ";
            }
            if (this.defines != null) {
                nameTxt = nameTxt + "defines, ";
            }
            return this.getClass().getSimpleName() + "[" + nameTxt + "type=" + this.shaderType.name() + "]";
        }

        public void resetObject() {
            this.id = -1;
            this.usable = false;
            this.setUpdateNeeded();
        }

        public void deleteObject(Renderer r) {
            r.deleteShaderSource(this);
        }

        public GLObject createDestructableClone() {
            return new ShaderSource(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShaderType {
        Fragment,
        Vertex,
        Geometry;

    }
}

