/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorClouds
extends TextureGenerator {
    public TextureGeneratorClouds(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, DataRepository dataRepository) {
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float dDelta = 1.0f / (float)depth;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        int noiseDepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        int noiseBasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float bright = ((Number)tex.getFieldValue("bright")).floatValue();
        boolean isHard = noiseType != 0;
        int sType = ((Number)tex.getFieldValue("stype")).intValue();
        int halfW = width;
        int halfH = height;
        int halfD = depth;
        width <<= 1;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = sType == 1 || colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = sType == 1 || colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer(width * (height <<= 1) * (depth <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k;
                    texres.tin = this.noiseGenerator.bliGTurbulence(noisesize, texvec[0], texvec[1], texvec[2], noiseDepth, isHard, noiseBasis);
                    if (colorBand != null) {
                        this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                        if (texres.nor != null) {
                            float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
                            texres.nor[0] = this.noiseGenerator.bliGTurbulence(noisesize, texvec[0] + nabla, texvec[1], texvec[2], noiseDepth, isHard, noiseBasis);
                            texres.nor[1] = this.noiseGenerator.bliGTurbulence(noisesize, texvec[0], texvec[1] + nabla, texvec[2], noiseDepth, isHard, noiseBasis);
                            texres.nor[2] = this.noiseGenerator.bliGTurbulence(noisesize, texvec[0], texvec[1], texvec[2] + nabla, noiseDepth, isHard, noiseBasis);
                            this.noiseGenerator.texNormalDerivate(colorBand, texres, dataRepository);
                        }
                        this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                        data.put((byte)(texres.tr * 255.0f));
                        data.put((byte)(texres.tg * 255.0f));
                        data.put((byte)(texres.tb * 255.0f));
                        continue;
                    }
                    if (sType == 1) {
                        texres.tr = texres.tin;
                        texres.tg = this.noiseGenerator.bliGTurbulence(noisesize, texvec[1], texvec[0], texvec[2], noiseDepth, isHard, noiseBasis);
                        texres.tb = this.noiseGenerator.bliGTurbulence(noisesize, texvec[1], texvec[2], texvec[0], noiseDepth, isHard, noiseBasis);
                        this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                        data.put((byte)(texres.tr * 255.0f));
                        data.put((byte)(texres.tg * 255.0f));
                        data.put((byte)(texres.tb * 255.0f));
                        continue;
                    }
                    this.noiseGenerator.brightnesAndContrast(texres, contrast, bright);
                    data.put((byte)(texres.tin * 255.0f));
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(data);
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }
}

