/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public final class UserData
implements Savable {
    public static final String JME_PHYSICSIGNORE = "JmePhysicsIgnore";
    public static final String JME_SHAREDMESH = "JmeSharedMesh";
    protected byte type;
    protected Object value;

    public UserData() {
    }

    public UserData(byte type, Object value) {
        assert (type >= 0 && type <= 4);
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static byte getObjectType(Object type) {
        if (type instanceof Integer) {
            return 0;
        }
        if (type instanceof Float) {
            return 1;
        }
        if (type instanceof Boolean) {
            return 2;
        }
        if (type instanceof String) {
            return 3;
        }
        if (type instanceof Long) {
            return 4;
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getClass().getName());
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.type, "type", (byte)0);
        switch (this.type) {
            case 0: {
                int i = (Integer)this.value;
                oc.write(i, "intVal", 0);
                break;
            }
            case 1: {
                float f = ((Float)this.value).floatValue();
                oc.write(f, "floatVal", 0.0f);
                break;
            }
            case 2: {
                boolean b = (Boolean)this.value;
                oc.write(b, "boolVal", false);
                break;
            }
            case 3: {
                String s = (String)this.value;
                oc.write(s, "strVal", null);
                break;
            }
            case 4: {
                Long l = (Long)this.value;
                oc.write(l, "longVal", 0L);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.type = ic.readByte("type", (byte)0);
        switch (this.type) {
            case 0: {
                this.value = ic.readInt("intVal", 0);
                break;
            }
            case 1: {
                this.value = Float.valueOf(ic.readFloat("floatVal", 0.0f));
                break;
            }
            case 2: {
                this.value = ic.readBoolean("boolVal", false);
                break;
            }
            case 3: {
                this.value = ic.readString("strVal", null);
                break;
            }
            case 4: {
                this.value = ic.readLong("longVal", 0L);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

