/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RotationTrack
extends AbstractCinematicEvent {
    private static final Logger log = Logger.getLogger(RotationTrack.class.getName());
    private float[] startRotation;
    private float[] endRotation;
    private Spatial spatial;
    private String spatialName = "";
    private float value = 0.0f;

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        if (this.spatial == null) {
            this.spatial = cinematic.getScene().getChild(this.spatialName);
            if (this.spatial != null) {
                log.log(Level.WARNING, "spatial {0} not found in the scene", this.spatialName);
            }
        }
    }

    public RotationTrack() {
    }

    public RotationTrack(Spatial spatial, float[] endRotation) {
        this.endRotation = endRotation;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public RotationTrack(Spatial spatial, float[] endRotation, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.endRotation = endRotation;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public RotationTrack(Spatial spatial, float[] endRotation, LoopMode loopMode) {
        super(loopMode);
        this.endRotation = endRotation;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public RotationTrack(Spatial spatial, float[] endRotation, float initialDuration) {
        super(initialDuration);
        this.endRotation = endRotation;
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public void onPlay() {
        if (this.playState != PlayState.Paused) {
            this.startRotation = this.spatial.getWorldRotation().toAngles(null);
        }
        if (this.duration == 0.0f && this.spatial != null) {
            this.spatial.setLocalRotation(new Quaternion().fromAngles(this.endRotation));
            this.stop();
        }
    }

    public void onUpdate(float tpf) {
        if (this.spatial != null) {
            this.value += Math.min(tpf * this.speed / this.duration, 1.0f);
            float[] rot = new float[]{FastMath.interpolateLinear(this.value, this.startRotation[0], this.endRotation[0]), FastMath.interpolateLinear(this.value, this.startRotation[1], this.endRotation[1]), FastMath.interpolateLinear(this.value, this.startRotation[2], this.endRotation[2])};
            this.spatial.setLocalRotation(new Quaternion().fromAngles(rot));
        }
    }

    public void onStop() {
        this.value = 0.0f;
    }

    public void onPause() {
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.spatialName, "spatialName", "");
        oc.write(this.endRotation, "endRotation", (float[])null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.spatialName = ic.readString("spatialName", "");
        this.endRotation = ic.readFloatArray("endRotation", null);
    }
}

