/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import java.util.logging.Logger;

public final class ClassHelper {
    private static Logger log = Logger.getLogger(ClassHelper.class.getName());

    private ClassHelper() {
    }

    public static Class<?> loadClass(String className) {
        try {
            Class<?> cls = ClassHelper.class.getClassLoader().loadClass(className);
            return cls;
        }
        catch (Exception e) {
            log.warning("class [" + className + "] could not be found (" + e.getMessage() + ")");
            return null;
        }
    }

    public static <T> T getInstance(String className, Class<T> type) {
        try {
            Class<?> cls = ClassHelper.class.getClassLoader().loadClass(className);
            if (type.isAssignableFrom(cls)) {
                return type.cast(cls.newInstance());
            }
            log.warning("given class [" + className + "] does not implement [" + type.getName() + "]");
        }
        catch (Exception e) {
            log.warning("class [" + className + "] could not be instantiated (" + e.toString() + ")");
        }
        return null;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.warning("class [" + clazz.getName() + "] could not be instantiated");
            return null;
        }
    }
}

