/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.batch.BatchRenderDevice;
import de.lessvoid.nifty.batch.BatchRenderImage;
import de.lessvoid.nifty.render.NiftyImageManager;
import de.lessvoid.nifty.render.NiftyImageManagerExt;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NiftyImageManagerExtBatch<T extends ReferencedCountedImageBatch>
implements NiftyImageManagerExt<T> {
    private static Logger log = Logger.getLogger(NiftyImageManagerExtBatch.class.getName());
    private Map<String, Set<T>> screenRef = new HashMap<String, Set<T>>();
    private Screen currentScreen;

    @Override
    public void registerImage(Screen screen, T image) {
        if (screen != null) {
            Set<T> screenList = this.screenRef.get(screen.getScreenId());
            if (screenList == null) {
                screenList = new HashSet<T>();
                this.screenRef.put(screen.getScreenId(), screenList);
            }
            if (screenList.add(image) && log.isLoggable(Level.FINER)) {
                log.finer("[" + screen.getScreenId() + "] now with [" + screenList.size() + "] entries (" + ((ReferencedCountedImageBatch)image).getName() + ")");
            }
            if (this.currentScreen != null && this.currentScreen.getScreenId().equals(screen.getScreenId()) && !((ReferencedCountedImageBatch)image).isUploaded()) {
                ((ReferencedCountedImageBatch)image).upload();
            }
        }
    }

    @Override
    public void unregisterImage(T reference) {
        ((ReferencedCountedImageBatch)reference).unload();
        Set<T> screenList = this.screenRef.get(((ReferencedCountedImageBatch)reference).getScreen().getScreenId());
        if (screenList != null) {
            screenList.remove(reference);
        }
    }

    @Override
    public void uploadScreenImages(Screen screen) {
        this.currentScreen = screen;
        Set<T> imageList = this.screenRef.get(screen.getScreenId());
        if (imageList == null) {
            return;
        }
        for (ReferencedCountedImageBatch image : imageList) {
            image.upload();
        }
    }

    @Override
    public void unloadScreenImages(Screen screen, RenderDevice renderDevice, Collection<T> imageSet) {
        ((BatchRenderDevice)renderDevice).resetTextureAtlas();
        for (ReferencedCountedImageBatch i : imageSet) {
            i.markAsUnloaded();
        }
        this.currentScreen = null;
    }

    @Override
    public void screenAdded(Screen screen) {
    }

    @Override
    public void screenRemoved(Screen screen) {
        this.screenRef.remove(screen.getScreenId());
    }

    @Override
    public void addScreenInfo(StringBuffer result) {
        if (this.screenRef.entrySet().isEmpty()) {
            return;
        }
        result.append("\n");
        for (Map.Entry<String, Set<T>> entry : this.screenRef.entrySet()) {
            result.append("\n[" + entry.getKey() + "]\n");
            for (ReferencedCountedImageBatch image : entry.getValue()) {
                result.append(image.toString());
            }
        }
    }

    @Override
    public T createReferencedCountedImage(RenderDevice renderDevice, Screen screen, String filename, boolean filterLinear, RenderImage renderImage, String key) {
        return (T)new ReferencedCountedImageBatch(renderDevice, screen, filename, filterLinear, renderImage, key);
    }

    public static class ReferencedCountedImageBatch
    implements NiftyImageManager.ReferencedCountedImage {
        private final RenderDevice renderDevice;
        private final Screen screen;
        private final String filename;
        private final boolean filterLinear;
        private final String key;
        private RenderImage renderImage;
        private int references;

        public ReferencedCountedImageBatch(RenderDevice renderDevice, Screen screen, String filename, boolean filterLinear, RenderImage renderImage, String key) {
            this.renderDevice = renderDevice;
            this.screen = screen;
            this.filename = filename;
            this.filterLinear = filterLinear;
            this.key = key;
            this.renderImage = renderImage;
            this.references = 1;
        }

        public void upload() {
            BatchRenderImage batchRenderImage = (BatchRenderImage)this.renderImage;
            batchRenderImage.upload();
        }

        public void unload() {
            BatchRenderImage batchRenderImage = (BatchRenderImage)this.renderImage;
            batchRenderImage.unload();
        }

        public void markAsUnloaded() {
            BatchRenderImage batchRenderImage = (BatchRenderImage)this.renderImage;
            batchRenderImage.markAsUnloaded();
        }

        @Override
        public RenderImage reload() {
            this.renderImage.dispose();
            this.renderImage = this.renderDevice.createImage(this.filename, this.filterLinear);
            return this.renderImage;
        }

        @Override
        public RenderImage addReference() {
            ++this.references;
            return this.renderImage;
        }

        @Override
        public boolean removeReference() {
            --this.references;
            if (this.references == 0) {
                this.renderImage.dispose();
                return true;
            }
            return false;
        }

        @Override
        public int getReferences() {
            return this.references;
        }

        @Override
        public RenderImage getRenderImage() {
            return this.renderImage;
        }

        @Override
        public String getName() {
            return this.key;
        }

        @Override
        public Screen getScreen() {
            return this.screen;
        }

        public boolean isUploaded() {
            if (this.renderImage instanceof BatchRenderImage) {
                return ((BatchRenderImage)this.renderImage).isUploaded();
            }
            return false;
        }

        public String toString() {
            return " - [" + this.getName() + "] reference count [" + this.getReferences() + "] uploaded [" + this.isUploaded() + "]\n";
        }
    }
}

