/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.batch;

import de.lessvoid.nifty.batch.TextureAtlasGeneratorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TextureAtlasGenerator {
    private final int width;
    private final int height;
    private Node root;
    private Map<String, Node> rectangleMap;

    public TextureAtlasGenerator(int width, int height) {
        this.width = width;
        this.height = height;
        this.root = new Node(0, 0, width, height);
        this.rectangleMap = new TreeMap<String, Node>();
    }

    public Result addImage(int imageWidth, int imageHeight, String name, int padding) throws TextureAtlasGeneratorException {
        Node node = this.root.insert(imageWidth, imageHeight, padding);
        if (node == null) {
            throw new TextureAtlasGeneratorException(imageWidth, imageHeight, name);
        }
        this.rectangleMap.put(name, node);
        return new Result(node.rect.x, node.rect.y, imageWidth, imageHeight);
    }

    public Result removeImage(String name) {
        Node node = this.rectangleMap.remove(name);
        if (node == null) {
            return null;
        }
        node.occupied = false;
        node.child[0] = null;
        node.child[1] = null;
        return new Result(node.rect.x, node.rect.y, node.rect.width, node.rect.height);
    }

    public List<Result> rebuild(int width, int height, int padding) throws TextureAtlasGeneratorException {
        ArrayList<Result> results = new ArrayList<Result>();
        this.root = new Node(0, 0, width, height);
        for (Map.Entry<String, Node> entry : this.rectangleMap.entrySet()) {
            Rectangle rect = entry.getValue().rect;
            results.add(this.addImage(rect.width, rect.height, entry.getKey(), padding));
        }
        return results;
    }

    public void reset() {
        this.root = new Node(0, 0, this.width, this.height);
        this.rectangleMap = new TreeMap<String, Node>();
    }

    private static class Node {
        public Rectangle rect;
        public Node[] child;
        public boolean occupied;

        public Node(int x, int y, int width, int height) {
            this.rect = new Rectangle(x, y, width, height);
            this.child = new Node[2];
            this.child[0] = null;
            this.child[1] = null;
            this.occupied = false;
        }

        public boolean isLeaf() {
            return this.child[0] == null && this.child[1] == null;
        }

        public Node insert(int imageWidth, int imageHeight, int padding) {
            int dh;
            if (!this.isLeaf()) {
                Node newNode = this.child[0].insert(imageWidth, imageHeight, padding);
                if (newNode != null) {
                    return newNode;
                }
                return this.child[1].insert(imageWidth, imageHeight, padding);
            }
            if (this.occupied) {
                return null;
            }
            if (imageWidth > this.rect.width || imageHeight > this.rect.height) {
                return null;
            }
            if (imageWidth == this.rect.width && imageHeight == this.rect.height) {
                this.occupied = true;
                return this;
            }
            int dw = this.rect.width - imageWidth;
            if (dw > (dh = this.rect.height - imageHeight)) {
                this.child[0] = new Node(this.rect.x, this.rect.y, imageWidth, this.rect.height);
                this.child[1] = new Node(padding + this.rect.x + imageWidth, this.rect.y, this.rect.width - imageWidth - padding, this.rect.height);
            } else {
                this.child[0] = new Node(this.rect.x, this.rect.y, this.rect.width, imageHeight);
                this.child[1] = new Node(this.rect.x, padding + this.rect.y + imageHeight, this.rect.width, this.rect.height - imageHeight - padding);
            }
            return this.child[0].insert(imageWidth, imageHeight, padding);
        }
    }

    private static class Rectangle {
        private int x;
        private int y;
        private int width;
        private int height;

        public Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    public static class Result {
        private int x;
        private int y;
        private int originalImageWidth;
        private int originalImageHeight;

        public Result(int x, int y, int originalImageWidth, int originalImageHeight) {
            this.x = x;
            this.y = y;
            this.originalImageWidth = originalImageWidth;
            this.originalImageHeight = originalImageHeight;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getOriginalImageWidth() {
            return this.originalImageWidth;
        }

        public int getOriginalImageHeight() {
            return this.originalImageHeight;
        }
    }
}

