/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.ListFragment;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import com.actionbarsherlock.app.SherlockListFragment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author kobayasi
 */
public class ZipListFragment extends SherlockListFragment {

    private static final Logger logger = Logger.getLogger(ZipListFragment.class.getName());
    File contentDir;
    File dir;
    String ext;
    ArrayList<String> list = new ArrayList<String>();
    ArrayList<File> fileList = new ArrayList<File>();

    public ZipListFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zip_list, container, false);
        this.dir = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
        this.ext = ".zip";
        refresh(dir);
        contentDir = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms/local");
        return view;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ArrayAdapter aa = new ArrayAdapter(getActivity(), android.R.layout.simple_list_item_1, list);
        setListAdapter(aa);
        getListView().setItemsCanFocus(true);
        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        final File file = fileList.get(position);
        AlertDialog.Builder ab = new AlertDialog.Builder(getActivity());
        ab.setTitle(getString(R.string.install_zip_file_dialog_title));
        ab.setMessage(getString(R.string.install_zip_file_dialog_message, file.getName()));
        ab.setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface arg0, int arg1) {
                InstallZipAsyncTask task = new InstallZipAsyncTask(getActivity(), Uri.fromFile(file));
                task.execute("");
            }
        });
        ab.setNegativeButton(android.R.string.cancel, new DialogInterface.OnClickListener() {

            public void onClick(DialogInterface arg0, int arg1) {
            }
        });
        ab.show();

    }

    private void refresh(File file) {
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) {
                if (file2.getName().toLowerCase().endsWith(ext)) {
                    list.add(file2.getName());
                    fileList.add(file2);
                }
            }
        }
    }
}
