/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import com.actionbarsherlock.app.SherlockFragmentActivity;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;

/**
 *
 * @author kobayasi
 */
public class ZipInstaller extends SherlockFragmentActivity {

    private static final Logger logger = Logger.getLogger(ZipInstaller.class.getName());

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!AssetManagerUtil.checkSDCard(this, true)) {
            return;
        }
        setTheme(R.style.Theme_Sherlock);
        setContentView(R.layout.zip_installer);
        Intent intent = getIntent();
        if (intent.getData() != null) {
            logger.info("intent = " + intent.getData());
//            TextView text1 = (TextView)findViewById(R.id.text1);
//            text1.setText(intent.getData().toString());
//            dbHelper.addZipFile(intent.getData());

            final Uri uri = intent.getData();
            AlertDialog.Builder ab = new AlertDialog.Builder(this);
            ab.setTitle(getString(R.string.install_zip_file_dialog_title));
            ab.setMessage(getString(R.string.install_zip_file_dialog_message, uri.getLastPathSegment()));
            ab.setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {

                public void onClick(DialogInterface arg0, int arg1) {
                    InstallZipAsyncTask task = new InstallZipAsyncTask(ZipInstaller.this, uri);
                    task.execute("");
                }
            });
            ab.setNegativeButton(android.R.string.cancel, new DialogInterface.OnClickListener() {

                public void onClick(DialogInterface arg0, int arg1) {
                    finish();
                }
            });
            ab.show();


//            InstallZipAsyncTask task = new InstallZipAsyncTask(this, intent.getData());
//            task.execute("");
        }
        Button exitButton = (Button) findViewById(R.id.exitButton);
        exitButton.setOnClickListener(new OnClickListener() {

            public void onClick(View arg0) {
                finish();
            }
        });

    }
}
