/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.logging.Logger;
import static info.projectkyoto.mms.assetmanager.common.MMSConfigBaseColumns.*;

/**
 *
 * @author kobayasi
 */
public class MMSConfigProvider extends ContentProvider {
    private static final Logger logger = Logger.getLogger(MMSConfigProvider.class.getName());
    private ConfigDBHelper dbHelper;
    private static final UriMatcher uriMatcher;
    private static final int MMSCONFIG = 1;
    private static final int MMSCONFIG_ID = 2;
    private static final HashMap<String, String> mmsConfigProjectionMap;

    static {
        uriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
        uriMatcher.addURI(AUTHORITY, "configs", MMSCONFIG);
        uriMatcher.addURI(AUTHORITY, "configs/#", MMSCONFIG_ID);

        mmsConfigProjectionMap = new HashMap<String, String>();
        mmsConfigProjectionMap.put(_ID, _ID);
        mmsConfigProjectionMap.put(CONFIG_TYPE, CONFIG_TYPE);
        mmsConfigProjectionMap.put(CONFIG_NAME, CONFIG_NAME);
        mmsConfigProjectionMap.put(DESCRIPTION, DESCRIPTION);
        mmsConfigProjectionMap.put(CONFIG_DATA, CONFIG_DATA);
    }

    @Override
    public boolean onCreate() {
        dbHelper = new ConfigDBHelper(getContext());
        return true;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        logger.info("query "+uri.toString()+ " "+selection);
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(TABLE_NAME);
        switch (uriMatcher.match(uri)) {
            case MMSCONFIG:
                qb.setProjectionMap(mmsConfigProjectionMap);
                break;
            case MMSCONFIG_ID:
                qb.setProjectionMap(mmsConfigProjectionMap);
                qb.appendWhere(_ID + "=" + uri.getPathSegments().get(1));
                break;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder);
        cursor.setNotificationUri(getContext().getContentResolver(), uri);
        return cursor;
    }

    @Override
    public String getType(Uri uri) {
        logger.info("getType() ");
        switch (uriMatcher.match(uri)) {
            case MMSCONFIG:
                logger.info("getType() = "+ CONTENT_TYPE);
                return CONTENT_TYPE;
            case MMSCONFIG_ID:
                logger.info("getType() = "+ CONTENT_ITEM_TYPE);
                return CONTENT_ITEM_TYPE;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        if (uriMatcher.match(uri) != MMSCONFIG) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        long rowId = db.insert(TABLE_NAME, null, values);
        if (rowId > 0) {
            Uri returnUri = ContentUris.withAppendedId(CONTENT_URI, rowId);
            getContext().getContentResolver().notifyChange(uri, null);
            return returnUri;
        }
        throw new SQLException("Failed to insert row into " + uri);
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        int count;
        switch (uriMatcher.match(uri)) {
            case MMSCONFIG:
                count = db.delete(TABLE_NAME, selection, selectionArgs);
                break;
            case MMSCONFIG_ID:
                String id = uri.getPathSegments().get(1);
                count = db.delete(TABLE_NAME, _ID + "=" + id
                        + (!TextUtils.isEmpty(selection) ? " AND ("
                        + selection + ")" : ""), selectionArgs);
                break;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }
        getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        int count;
        switch (uriMatcher.match(uri)) {
            case MMSCONFIG:
                count = db.update(TABLE_NAME, values, selection, selectionArgs);
                break;
            case MMSCONFIG_ID:
                String id = uri.getPathSegments().get(1);
                count = db.update(TABLE_NAME, values, _ID + "=" + id
                        + (!TextUtils.isEmpty(selection) ? " AND ("
                        + selection + ")" : ""), selectionArgs);
                break;
            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }
        logger.info("notifyChange "+uri);
        getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }
}
