package info.projectkyoto.mms.assetmanager;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.ListFragment;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.ListView;
import android.widget.Toast;
import android.widget.ToggleButton;
import com.actionbarsherlock.app.SherlockListFragment;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.apache.http.client.utils.URLEncodedUtils;
import info.projectkyoto.mms.assetmanager.R;

public class FileSelectFragment extends SherlockListFragment {

    private static final Logger logger = Logger.getLogger(FileSelectFragment.class.getName());
    File dir;
    String[] files;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.file_list, container, false);
        dir = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms/local");
        return view;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        refresh();
        registerForContextMenu(getListView());
    }

    public void refresh() {
        files = dir.list(new FilenameFilter() {

            public boolean accept(File dir, String name) {
                if (dir.isDirectory()) {
                    return true;
                }
                return false;
            }
        });
        if (files == null) {
            files = new String[0];
        }
        setListAdapter(new ArrayAdapter(getActivity(), android.R.layout.simple_list_item_1, files));
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        File file = new File(dir, files[position]);
        try {
            ContentListFragment clf = new ContentListFragment();
            Bundle args = new Bundle();
            args.putString("file", file.getCanonicalPath());
            boolean viewOnly = false;
            if ("application/x-mmd-pmd".equals(getActivity().getIntent().getType())) {
                args.putString("ext", ".pmd");
            } else if ("application/x-mmd-vmd".equals(getActivity().getIntent().getType())) {
                args.putString("ext", ".vmd");
            } else {
                args.putString("ext", "");
                viewOnly = true;
            }
            args.putBoolean("viewOnly", viewOnly);
            clf.setArguments(args);
            FragmentTransaction ft = getFragmentManager().beginTransaction();
            ft.replace(R.id.fragment1, clf);
            ft.addToBackStack(null);
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.commit();

//            String entryName = "MikuMikuDanceE_v739dot/readme.txt";
//            Uri uri = Uri.parse("content://info.projectkyoto.zipcontentprovider" 
//                    + "/"+URLEncoder.encode(file.getCanonicalPath(), "UTF-8") + "/" 
//                    + entryName);
//            InputStream is = getActivity().getContentResolver().openInputStream(uri);
//            is.close();
        } catch (ZipException ex) {
            Logger.getLogger(FileSelectFragment.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FileSelectFragment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
//        super.onCreateOptionsMenu(menu, inflater);
//        menu.add("add")
//                .setIcon(android.R.drawable.ic_menu_add)
//                .setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM);
//        menu.add("install")
//                .setIcon(android.R.drawable.ic_menu_add)
//                .setTitle("Install")
//                .setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM);
        inflater.inflate(R.menu.filelistmenu, menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (!AssetManagerUtil.checkSDCard(getActivity(), false)) {
            return true;
        }
        switch (item.getItemId()) {
            case R.id.install_zip:
                ZipListFragment zlf = new ZipListFragment();
                ;
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.replace(R.id.fragment1, zlf);
                ft.addToBackStack(null);
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.commit();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        menu.add(0, R.string.delete_asset, 0, R.string.delete_asset);
    }

    @Override
    public boolean onContextItemSelected(android.view.MenuItem item) {
        AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
        int pos = info.position;
        switch (item.getItemId()) {
            case R.string.delete_asset:
                final File file = new File(dir, files[pos]);
                AlertDialog.Builder ab = new AlertDialog.Builder(getActivity());
                ab.setTitle(getString(R.string.delete_content_dialog_title));
                ab.setMessage(getString(R.string.delete_content_dialog_message, file.getAbsolutePath()));
                ab.setPositiveButton(getString(android.R.string.ok), new DialogInterface.OnClickListener() {

                    public void onClick(DialogInterface arg0, int arg1) {
                        DeleteDirectoryAsyncTask task = new DeleteDirectoryAsyncTask(getActivity(), file, FileSelectFragment.this);
                        task.execute("");
                    }
                });
                ab.setNegativeButton(getString(android.R.string.cancel), new DialogInterface.OnClickListener() {

                    public void onClick(DialogInterface arg0, int arg1) {
                    }
                });
                ab.show();
                return true;
        }
        return super.onContextItemSelected(item);
    }
}
