
package org.rz.midiplayer.plugin.renderer;

import java.awt.Component;
import org.rz.midiplayer.plugin.Plugin;

/**
 * 画面描画を行うためのプラグインを作成する場合の基底インタフェース。
 * @author rz
 */
public interface RendererPlugin extends Plugin
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * 実際に画面に描画可能に可能になる時に呼び出される。
     * 主に、アニメーションループのためのスレッドなどの実行開始を行う。
     */
    void startRendering();

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * 画面への描画が行えなくなる時に呼び出される。
     * 主に、アニメーションループのためのスレッドなどの停止処理を行う。
     */
    void stopRendering();

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * プレーヤーウインドウに配置する awt / Swing コンポーネントを取得する。
     */
    Component getComponent();

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * このプラグインがウインドウりサイズに対応しているかどうかを判定する。
     * 固定サイズの描画を行う場合などは false を返す。この場合、ユーザーはウインドウサイズを変更できないようになる。
     * 逆にウインドウサイズの変更に併せてスケーリング等を行う場合は true を返す。
     */
    boolean isEnabledResizeWindow();
}
