/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer.pianoroll3d;

import com.sun.opengl.util.GLUT;
import java.awt.Color;
import javax.media.opengl.GL;

public class NoteObject {
    static final float SPEED = 1.0f;
    protected float x;
    protected float y;
    protected float z;
    protected float z2;
    volatile boolean visible;
    volatile boolean noteOn;
    volatile int channel;
    volatile int noteNo;
    private volatile Color activeColor = Color.RED;
    private volatile Color deactiveColor = this.activeColor.darker();
    private float[][] defaultVertices = new float[][]{{1.0f, 1.0f, 1.0f}, {-1.0f, 1.0f, 1.0f}, {-1.0f, -1.0f, 1.0f}, {1.0f, -1.0f, 1.0f}, {1.0f, 1.0f, -1.0f}, {-1.0f, 1.0f, -1.0f}, {-1.0f, -1.0f, -1.0f}, {1.0f, -1.0f, -1.0f}};
    static final int VBO_VERTEX_NUM = 72;
    static final int VBO_NORMAL_NUM = 18;
    private final float[][] normals = new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}, {1.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 0.0f}};
    private float[][] vertices = new float[][]{{1.0f, 1.0f, 1.0f}, {-1.0f, 1.0f, 1.0f}, {-1.0f, -1.0f, 1.0f}, {1.0f, -1.0f, 1.0f}, {1.0f, 1.0f, -1.0f}, {-1.0f, 1.0f, -1.0f}, {-1.0f, -1.0f, -1.0f}, {1.0f, -1.0f, -1.0f}};
    float[] color = new float[]{1.0f, 0.0f, 0.0f, 1.0f};

    public NoteObject() {
        this.reset();
    }

    public void reset() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.visible = false;
        this.noteOn = false;
        this.channel = 0;
        this.noteNo = 0;
        for (int i = 0; i < 8; ++i) {
            this.vertices[i][0] = this.defaultVertices[i][0];
            this.vertices[i][1] = this.defaultVertices[i][1];
            this.vertices[i][2] = this.defaultVertices[i][2];
        }
    }

    public void noteOn(float sx, float sy, int vel) {
        this.x = sx;
        this.y = sy;
        this.z = 0.0f;
        this.z2 = 0.0f;
        this.visible = true;
        this.noteOn = true;
        this.vertices[4][2] = 1.0f;
        this.vertices[5][2] = 1.0f;
        this.vertices[6][2] = 1.0f;
        this.vertices[7][2] = 1.0f;
        if (vel <= 0) {
            vel = 1;
        }
        this.setColorValue(this.activeColor);
    }

    public void noteOff() {
        this.noteOn = false;
        this.setColorValue(this.deactiveColor);
    }

    public void update() {
        if (this.visible) {
            float delta;
            this.z = delta = 1.0f;
            if (this.noteOn) {
                float[] fArray = this.vertices[0];
                fArray[2] = fArray[2] + this.z;
                float[] fArray2 = this.vertices[1];
                fArray2[2] = fArray2[2] + this.z;
                float[] fArray3 = this.vertices[2];
                fArray3[2] = fArray3[2] + this.z;
                float[] fArray4 = this.vertices[3];
                fArray4[2] = fArray4[2] + this.z;
            } else {
                this.z2 += delta;
                float[] fArray = this.vertices[0];
                fArray[2] = fArray[2] + this.z;
                float[] fArray5 = this.vertices[1];
                fArray5[2] = fArray5[2] + this.z;
                float[] fArray6 = this.vertices[2];
                fArray6[2] = fArray6[2] + this.z;
                float[] fArray7 = this.vertices[3];
                fArray7[2] = fArray7[2] + this.z;
                float[] fArray8 = this.vertices[4];
                fArray8[2] = fArray8[2] + this.z;
                float[] fArray9 = this.vertices[5];
                fArray9[2] = fArray9[2] + this.z;
                float[] fArray10 = this.vertices[6];
                fArray10[2] = fArray10[2] + this.z;
                float[] fArray11 = this.vertices[7];
                fArray11[2] = fArray11[2] + this.z;
                if (this.z2 > 800.0f) {
                    this.reset();
                }
            }
        }
    }

    public synchronized void render(GL gl, GLUT glut) {
        if (!this.visible) {
            return;
        }
        gl.glPushMatrix();
        gl.glTranslatef(this.x, this.y, -250.0f);
        gl.glMaterialfv(1028, 4609, this.color, 0);
        gl.glBegin(7);
        gl.glNormal3fv(this.normals[0], 0);
        gl.glVertex3fv(this.vertices[0], 0);
        gl.glVertex3fv(this.vertices[1], 0);
        gl.glVertex3fv(this.vertices[2], 0);
        gl.glVertex3fv(this.vertices[3], 0);
        gl.glNormal3fv(this.normals[1], 0);
        gl.glVertex3fv(this.vertices[7], 0);
        gl.glVertex3fv(this.vertices[6], 0);
        gl.glVertex3fv(this.vertices[5], 0);
        gl.glVertex3fv(this.vertices[4], 0);
        gl.glNormal3fv(this.normals[2], 0);
        gl.glVertex3fv(this.vertices[0], 0);
        gl.glVertex3fv(this.vertices[3], 0);
        gl.glVertex3fv(this.vertices[7], 0);
        gl.glVertex3fv(this.vertices[4], 0);
        gl.glNormal3fv(this.normals[3], 0);
        gl.glVertex3fv(this.vertices[5], 0);
        gl.glVertex3fv(this.vertices[6], 0);
        gl.glVertex3fv(this.vertices[2], 0);
        gl.glVertex3fv(this.vertices[1], 0);
        gl.glNormal3fv(this.normals[4], 0);
        gl.glVertex3fv(this.vertices[4], 0);
        gl.glVertex3fv(this.vertices[5], 0);
        gl.glVertex3fv(this.vertices[1], 0);
        gl.glVertex3fv(this.vertices[0], 0);
        gl.glNormal3fv(this.normals[5], 0);
        gl.glVertex3fv(this.vertices[6], 0);
        gl.glVertex3fv(this.vertices[7], 0);
        gl.glVertex3fv(this.vertices[3], 0);
        gl.glVertex3fv(this.vertices[2], 0);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public synchronized void setColor(Color c) {
        this.activeColor = c;
        this.deactiveColor = c.darker();
    }

    private void setColorValue(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        this.color[0] = (float)r / 255.0f;
        this.color[1] = (float)g / 255.0f;
        this.color[2] = (float)b / 255.0f;
    }
}

