/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer;

import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.DefaultSimpleHandler;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;
import org.rz.midiplayerplugin.renderer.MidiChannel;
import org.rz.midiplayerplugin.renderer.NoteEventListener;

class MidiEventHandler
extends DefaultSimpleHandler {
    private final MidiChannel[] midiChannels;
    private final NoteEventListener noteEventListener;

    public MidiEventHandler(Context ctx, MidiChannel[] midiChannels_, NoteEventListener noteEventListener_) {
        super(ctx);
        this.midiChannels = midiChannels_;
        this.noteEventListener = noteEventListener_;
        Instrument[] defaultInst = this.getDefaultInstrumentList();
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i].instrument = defaultInst[i];
        }
    }

    public void changedCcValue(int ch, int ccNo, int value) {
        this.midiChannels[ch].cc[ccNo] = value;
    }

    public void changedPitchbend(int ch, int value) {
        this.midiChannels[ch].pitchBend = value;
    }

    public void noteOn(int ch, int note, int vel) {
        this.midiChannels[ch].level = Math.min(this.midiChannels[ch].level + vel, 127);
        this.noteEventListener.noteOn(ch, note, vel);
    }

    public void noteOff(int ch, int note) {
        this.noteEventListener.noteOff(ch, note);
    }

    public void programChange(int ch, Instrument inst) {
        this.midiChannels[ch].instrument = inst;
    }
}

