/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.midi.MidiEventListener;
import org.rz.midiplayer.plugin.renderer.SimpleRenderer;
import org.rz.midiplayer.util.PathUtil;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayerplugin.renderer.MidiChannel;
import org.rz.midiplayerplugin.renderer.MidiEventHandler;
import org.rz.midiplayerplugin.renderer.NoteEventListener;
import org.rz.midiplayerplugin.renderer.NoteObject;
import org.rz.midiplayerplugin.renderer.NoteObjectPool;
import org.rz.midiplayerplugin.renderer.TrackRenderer;
import org.rz.midiplayerplugin.renderer.config.Color;
import org.rz.midiplayerplugin.renderer.config.Config;

public class DefaultRenderer
extends SimpleRenderer
implements NoteEventListener {
    private Context context;
    private final MidiChannel[] midiChannels = new MidiChannel[16];
    private final TrackRenderer[] trackRenderers = new TrackRenderer[16];
    private final Dimension screenSize = new Dimension(512, 384);
    private MidiEventHandler midiEventHandler;
    private final NoteObjectPool noteObjects = new NoteObjectPool(2048);
    private final ArrayList<NoteObject> noteList = new ArrayList(2048);
    private BufferedImage trackImageBase;
    private BufferedImage fontImage;
    private final StringBuilder textWork = new StringBuilder(32);
    public static final java.awt.Color[] DEFAULT_COLORS = new java.awt.Color[]{new java.awt.Color(8388564), new java.awt.Color(11591910), new java.awt.Color(16767673), new java.awt.Color(16752762), new java.awt.Color(10025880), new java.awt.Color(0xFFFF00), new java.awt.Color(16766720), new java.awt.Color(0xEE82EE), new java.awt.Color(15684210), new java.awt.Color(13789470), new java.awt.Color(64154), new java.awt.Color(0x7FFF00), new java.awt.Color(16113331), new java.awt.Color(16758465), new java.awt.Color(16716947), new java.awt.Color(49151), new java.awt.Color(12092939), new java.awt.Color(16737095)};
    private final java.awt.Color[] pianoRollColors = new java.awt.Color[16];
    private static final java.awt.Color TIME_GAUGE_FRAME_COLOR = new java.awt.Color(3317247);
    private static final java.awt.Color TIME_GAUGE_COLOR = new java.awt.Color(19880);

    public void onInit(Context ctx, String pluginDir) {
        int i;
        this.context = ctx;
        for (i = 0; i < 16; ++i) {
            this.midiChannels[i] = new MidiChannel();
        }
        this.midiEventHandler = new MidiEventHandler(ctx, this.midiChannels, this);
        ctx.addMidiEventListener((MidiEventListener)this.midiEventHandler);
        try {
            for (i = 0; i < 16; ++i) {
                this.pianoRollColors[i] = DEFAULT_COLORS[i];
            }
            JAXBUtil jaxbConfig = new JAXBUtil(Config.class);
            Config config = (Config)jaxbConfig.loadFromFile(PathUtil.package2ClasspathString(this.getClass()) + "/config.xsd", PathUtil.buildPath((String)pluginDir, (String)"config.xml")).getValue();
            for (Color c : config.getPianoroll().getColor()) {
                try {
                    java.awt.Color col;
                    short ch = c.getMidich();
                    this.pianoRollColors[ch] = col = java.awt.Color.decode(c.getColor());
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Failed to loading a config file", e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to loading a config file", e);
        }
    }

    private void loadResources() throws IOException {
        URL track = this.getClass().getResource("track.gif");
        URL font = this.getClass().getResource("font.gif");
        this.trackImageBase = ImageIO.read(track);
        this.fontImage = ImageIO.read(font);
        for (int i = 0; i < 16; ++i) {
            this.trackRenderers[i] = new TrackRenderer(this.context, i, this.midiChannels[i], this.canvas, this.trackImageBase, this.fontImage, this.pianoRollColors[i]);
        }
    }

    private void disposeResources() {
    }

    public synchronized void startRendering() {
        try {
            this.loadResources();
            super.startRendering();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "cannot start rendering...", e);
        }
    }

    public void onMidiPlayingBefore(File midiFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMidiStoped() {
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            for (NoteObject o : this.noteList) {
                o.noteOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteOn(int ch, int noteNo, int vel) {
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            NoteObject n = this.noteObjects.create();
            n.noteOn(197, 382 - 3 * noteNo);
            n.noteNo = noteNo;
            n.channel = ch;
            n.setColor(this.pianoRollColors[ch]);
            this.noteList.add(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteOff(int ch, int noteNo) {
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            int s = this.noteList.size();
            for (int i = 0; i < s; ++i) {
                NoteObject n = this.noteList.get(i);
                if (n.channel != ch || n.noteNo != noteNo) continue;
                n.noteOff();
            }
        }
    }

    public void onDispose(Context ctx) {
        ctx.removeMidiEventListener((MidiEventListener)this.midiEventHandler);
        this.disposeResources();
        super.onDispose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        DefaultRenderer defaultRenderer = this;
        synchronized (defaultRenderer) {
            int i = 0;
            while (i < this.noteList.size()) {
                NoteObject n = this.noteList.get(i);
                if (n.rect.isEmpty()) {
                    this.noteList.remove(i);
                    continue;
                }
                n.update();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g.setColor(java.awt.Color.black);
        g.fillRect(0, 0, this.screenSize.width, this.screenSize.height);
        this.drawTracks(g);
        this.drawInfo(g);
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            boolean i = false;
            g.translate(290, 0);
            g.setClip(0, 0, 222, 384);
            for (NoteObject n : this.noteList) {
                n.render(g);
            }
            g.translate(-290, 0);
        }
    }

    private void drawTracks(Graphics2D g) {
        for (int i = 0; i < 16; ++i) {
            this.trackRenderers[i].render(g, 0, 23 * i);
        }
    }

    private void drawInfo(Graphics2D g) {
        int bpm;
        boolean x = true;
        int y = 372;
        int now = this.context.getCurrentTimeInSecond();
        int end = this.context.getPlayTimeInSecond();
        StringBuilder sb = this.textWork;
        if (now > 59999) {
            now = 59999;
        }
        if (end > 59999) {
            end = 59999;
        }
        sb.delete(0, sb.length());
        sb.append("Time:");
        int min = now / 60;
        int sec = now % 60;
        int min100 = min / 100 % 10;
        int min10 = min / 10 % 10;
        int min1 = min % 10;
        if (min100 > 0) {
            sb.append(min100);
        }
        if (min10 > 0) {
            sb.append(min10);
        }
        sb.append(min1);
        sb.append(':');
        sb.append(sec / 10 % 10);
        sb.append(sec % 10);
        sb.append("/");
        min = end / 60;
        sec = end % 60;
        min100 = min / 100 % 10;
        min10 = min / 10 % 10;
        min1 = min % 10;
        if (min100 > 0) {
            sb.append(min100);
        }
        if (min10 > 0) {
            sb.append(min10);
        }
        sb.append(min1);
        sb.append(':');
        sb.append(sec / 10 % 10);
        sb.append(sec % 10);
        DefaultRenderer.drawText(g, (Image)this.fontImage, sb.toString(), 1, 372);
        g.setColor(TIME_GAUGE_FRAME_COLOR);
        g.drawRect(111, 372, 101, 7);
        if (end > 0) {
            g.setColor(TIME_GAUGE_COLOR);
            g.fillRect(112, 373, now * 100 / end, 6);
        }
        if ((bpm = this.context.getBPM()) > 999) {
            bpm = 999;
        }
        sb.delete(0, sb.length());
        sb.append("BPM:\u0000=").append(bpm);
        DefaultRenderer.drawText(g, (Image)this.fontImage, sb.toString(), 231, 372);
    }

    public Component getComponent() {
        Component c = super.getComponent();
        c.setPreferredSize(this.screenSize);
        return c;
    }

    public boolean isEnabledResizeWindow() {
        return false;
    }

    static void drawText(Graphics2D g, Image font, String txt, int x, int y) {
        DefaultRenderer.drawText(g, font, txt.toCharArray(), x, y);
    }

    static void drawText(Graphics2D g, Image font, char[] txt, int x, int y) {
        for (char ascii : txt) {
            if (ascii <= '\u007f') {
                int sx = 6 * ascii;
                g.drawImage(font, x, y, x + 6, y + 10, sx, 0, sx + 6, 10, null);
            }
            x += 6;
        }
    }
}

