/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx10input;

import javax.swing.JPanel;
import jp.synthtarou.midimixer.MXMidiLogger;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.mx12masterkeys.MX12Process;
import jp.synthtarou.midimixer.mx20patchbay.MX20Process;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX10Process extends MXReceiver {
    MX10Data _data;
    MX10View _view;
    
    MX20Process _patchBay;
    MX12Process _masterKey;
    MXMidiLogger _logger;

    public MX10Process() {
        _data = new MX10Data();
        _patchBay = new MX20Process(true);
        _view = new MX10View(this);
        _logger = new MXMidiLogger("In");
        _view.setLogger(_logger);
    }
    
    public void readSettings() {
        _patchBay.readSettings();
    }
    
    public void setMasterKeyProcess(MX12Process master) {
        _masterKey = master;
    }

    public void setUseMesssageFilter(boolean log) {
        setUsingThis(log);
    }
    
    public boolean isUseMessageFilter() {
        return usingThis();
    }
    
    public void setUsePortFowarding(boolean pf) {
        _patchBay.setUsingThis(pf);
    }
    
    public boolean isUsePortFowarding() {
        if (_patchBay == null) {
            return true;
        }
        return _patchBay.usingThis();
    }
    
    public void setUseLogging(boolean pf) {
        _logger.setUsingThis(pf);
    }
    
    public boolean isUseLogging() {
        if (_logger == null) {
            return true;
        }
        return _logger.usingThis();
    }
    
    @Override
    public void processMXMessage(MXMessage message) {
        if (usingThis()) {
            if (_data.isMessageToSkip(message)) {
                return;
            }
        }

        _logger.setNextReceiver(getNextReceiver());
        _patchBay.setNextReceiver(_logger);
        _patchBay.processMXMessage(message);
    }
    
    public void processMasterkeyMessage(MXMessage message) {
        _logger.setNextReceiver(getNextReceiver());
        _logger.processMXMessage(message);
        //sendToNext(message);
    }

    @Override
    public String getReceiverName() {
        return "Input Receiver";
    }

    @Override
    public JPanel getReceiverView() {
        return _view;
    }
}
