/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import jp.synthtarou.midimixer.libs.MXDebugConsole;

/**
 *
 * @author YOSHIDA Shintarou
 */

public class MXNoteOffWatcher {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXNoteOffWatcher.class);

    public static interface Handler {
        public void onNoteOffEvent(MXMessage target);
    }
    
    private static class Element {
        MXMessage caughtNoteOn;
        MXMessage sendingNoteOff;
        Handler listener;
    }

    private LinkedList<Element> _list = new LinkedList<Element>();

    public MXNoteOffWatcher() {
    }
    
    public String toString() {
        return "(MXNoteOff + " + _list.size();
    }
    
    public synchronized boolean addListener(MXMessage noteOn, MXMessage noteOff, Handler listener) {
        return addListener(noteOn, noteOff, listener, null);
    }

    public synchronized boolean addListener(MXMessage noteOn, MXMessage noteOff, Handler listener, String dolog) {
        if (noteOn.getCommand() != MXMidi.COMMAND_NOTEON) {
            _debug.println("Its not note on " + noteOn);
            return false;
        }
        Element e = new Element();
        e.caughtNoteOn = noteOn;
        if (noteOff.getCommand() == MXMidi.COMMAND_NOTEON) {
            noteOff = MXMessageFactory.fromClone(noteOff);
            noteOff.setStatus(MXMidi.COMMAND_NOTEOFF + noteOff.getChannel());
            noteOff.setValue(0);
        }
        e.sendingNoteOff = noteOff;
        e.listener = listener;
        /*
        if (dolog != null) {
            if (dolog.equals("@1")) {
                System.out.println("Add Listener " + dolog + " " + noteOn + " -> " + noteOff);
            }
        }
        */
        _list.add(e);
        return true;
    }
    
    public synchronized void allNoteOff() {
        ArrayList<Element> list = new ArrayList<>(_list);
        _list.clear();
        
        for (Element e : list) {
            e.listener.onNoteOffEvent(e.sendingNoteOff);
        }
    }
    
    public synchronized boolean notifyNoteOffEvent(int port, int ch, int note) {
        return notifyNoteOffEvent(port, ch, note, null);
    }

    public synchronized boolean notifyNoteOffEvent(int port, int ch, int note, String dolog) {
        boolean proc = false;
        boolean saveProc = false;
        
        do {
            if (proc) {
            }
            proc = false;
            Iterator<Element> it = _list.iterator();
            while (it.hasNext()) {
                Element e = it.next();
                if (e.caughtNoteOn.getPort() == port
                 && e.caughtNoteOn.getChannel() == ch
                 && e.caughtNoteOn.getNoteNumberFromBytes() == note) {
                    e.listener.onNoteOffEvent(e.sendingNoteOff);
                    it.remove();
                    proc = true;
                }
            }
            if (proc) {
                saveProc = true;
            }
        }while(proc);
        /*
        if (dolog != null) {
            if (dolog.equals("@1")) {
                System.out.println(" notifyNoteOff(" + dolog + ") " + saveProc +" [" + MXMidiUI.nameOfPort(port) + (ch+1) +"]" + " note " + note);
            }
        }*/

        return saveProc;
    }
}
