/*
 * Copyright (C) 2022 YOSHIDA Shintarou
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.synthtarou.midimixer.libs.console;

import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXConsolePanel extends javax.swing.JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXConsolePanel.class);
    private MXConsoleModel model;
    private boolean startLogging = false;
    
    public MXConsolePanel(String title) {
        initComponents();
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        
        if (title != null) {             
            if (title.length() != 0) {
                setBorder(javax.swing.BorderFactory.createTitledBorder(title));
            }
        }
        model = new MXConsoleModel(4096);
        model.bind(jListLogging);         
    }
    
    public void logging(MXMessage msg) {
        if (startLogging) {
            String text = msg.toString();
            model.addConsoleMessage(text);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jListLogging = new javax.swing.JList<>();
        jCheckBoxLogging = new javax.swing.JCheckBox();
        jButtonClear = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setViewportView(jListLogging);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

        jCheckBoxLogging.setText("Logging");
        jCheckBoxLogging.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxLoggingActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jCheckBoxLogging, gridBagConstraints);

        jButtonClear.setText("Clear");
        jButtonClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        add(jButtonClear, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonClearActionPerformed
        model.clearText();
        jListLogging.updateUI();
    }//GEN-LAST:event_jButtonClearActionPerformed

    private void jCheckBoxLoggingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxLoggingActionPerformed
        if (jCheckBoxLogging.isSelected()) {
            MXConsolePanel.this.startLogging = true;
        }else {
            MXConsolePanel.this.startLogging = false;
        }
    }//GEN-LAST:event_jCheckBoxLoggingActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClear;
    private javax.swing.JCheckBox jCheckBoxLogging;
    private javax.swing.JList<String> jListLogging;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
}
