/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs;

import java.util.ArrayList;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class NoneCriticalTimer {
    static class Item {
        long tick;
        Runnable action;
    }
    
    ArrayList<Item> _pending;
    
    public static NoneCriticalTimer _timer;
    
    static {
        _timer = new NoneCriticalTimer();
        Thread t = new Thread(new Runnable() {
            public void run() {
                _timer.loop();
            }
        });
        t.start();
    }
    
    protected NoneCriticalTimer() {
        _pending = new ArrayList<Item>();
    }
    
    public static void push(long howLongWait, Runnable action) {
        Item i = new Item();
        i.tick = System.currentTimeMillis() + howLongWait;
        i.action = action;
        synchronized(_timer._pending) {
            _timer._pending.add(i);
            _timer._pending.notify();
        }
    }
    
    public void loop() {
        while(true) {
            Item pop = null;
            long current = System.currentTimeMillis();
            long nextTick = 60 * 1000 + current;
            synchronized(_pending) {
                for (Item i : _pending) {
                    if (i.tick <= current) {
                        pop = i;
                        _pending.remove(i);
                        break;
                    }
                }
                for (Item i : _pending) {
                    if (i.tick <= nextTick) {
                        nextTick = i.tick;
                    }
                }
                if (pop == null) {
                    try {
                        _pending.wait(nextTick - current);
                    }catch(InterruptedException e) {
                    }
                }
            }
            if (pop != null) {
                try {
                    pop.action.run();
                }catch(Throwable e) {
                    e.printStackTrace();
                }            
            }
        }
    }
}            