/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs;

import jp.synthtarou.midimixer.mx30controller.MX32PageData;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXTemplates {
    public static final MXTemplates _instance = new MXTemplates();
    
    public synchronized static MXTemplates getInstance() {
        return _instance;
    }
    
    public void loadMixerTemplateGMTone(MX32PageData mixer) {
        /*
        MXControllerStatus cvalue = null;
        MXMessage tempMessage = null;

        ArrayList<MXControllerStatus> listSLiderData = new ArrayList<MXControllerStatus>();
        ArrayList<MXControllerStatus> listCircleData = new ArrayList<MXControllerStatus>();
        ArrayList<MXPadStatus> listPadData = new ArrayList<MXPadStatus>();
        
        mixer._mixerName = "Template[ GM TONE ]";

        int X = 0;
        for (int ch = 0; ch < 2; ++ch) {
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned, MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_CCMODULATION, 0);
                        break;
                    case 1:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_PITCHWHEEL, ch, 0, 0);
                        break;
                    case 2: 
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_SOUND_ATTACKTIME, 0);
                        break;
                    case 3:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_SOUND_BLIGHTNESS, 0);
                        break;
                }

                cvalue = MXControllerStatus.fromMessage(tempMessage);
                cvalue._valueCurrent = cvalue._valueResetPosition;

                listSLiderData.add(cvalue);
            }
        }
        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, 0, MXMidiCode.DATA1_CCCHANNELVOLUME, 0);
        cvalue = MXControllerStatus.fromMessage(tempMessage);
        cvalue._valueCurrent = cvalue._valueResetPosition;

        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, 0, MXMidiCode.DATA1_CCCHANNELVOLUME, 0);
        cvalue = MXControllerStatus.fromMessage(tempMessage);
        cvalue._valueCurrent = cvalue._valueResetPosition;

        listSLiderData.add(cvalue);

        X = 0;
        for (int ch = 0; ch < 2; ++ch) {
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_EFFECT1_REVERVE, 0);
                        break;
                    case 1:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_EFFECT3_CHORUS, 0);
                        break;
                    case 2:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_EFFECT5_PHASER, 0);
                        break;
                    case 3:
                        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_SOUND_VIBRATE_DEPTH, 0);
                        break;
                }

                cvalue = MXControllerStatus.fromMessage(tempMessage);
                cvalue._valueCurrent = cvalue._valueResetPosition;
                listCircleData.add(cvalue);
            }
        }
        tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, 0, MXMidiCode.DATA1_CCEXPRESSION, 0);
        cvalue = MXControllerStatus.fromMessage(tempMessage);
        cvalue._valueCurrent = cvalue._valueResetPosition;
        listCircleData.add(cvalue);

        MXPadStatus r1 = MXPadStatus.createForNoteON(mixer._assigned, 0, 12 * 4 + 3);
        MXPadStatus r2 = MXPadStatus.createForNoteON(mixer._assigned, 0, 12 * 4 + 0);
        MXPadStatus r3 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 0);
        MXPadStatus r4 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 1);
        MXPadStatus r5 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 2);
        MXPadStatus r6 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 3);
        MXPadStatus r7 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 4);
        MXPadStatus r8 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 5);
        MXPadStatus r9 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 6);

        listPadData = new ArrayList<MXPadStatus>();
        listPadData.add(r1);
        listPadData.add(r2);
        listPadData.add(r3);
        listPadData.add(r4);
        listPadData.add(r5);
        listPadData.add(r6);
        listPadData.add(r7);
        listPadData.add(r8);
        listPadData.add(r9);
        
        mixer.setMixerElement(listSLiderData, listCircleData, listPadData)
        */;
    }
    
    public void loadMixerTemplateVolumes(MX32PageData mixer) {
        /*
        MXControllerStatus cvalue = null;
        MXMessage tempMessage = null;

        mixer._mixerName = "Template[ VOLUMES ]";

        ArrayList<MXControllerStatus> listSliderData = new ArrayList<MXControllerStatus>();
        ArrayList<MXControllerStatus> listCircleData = new ArrayList<MXControllerStatus>();
        ArrayList<MXPadStatus> listRhythmData = new ArrayList<MXPadStatus>();

        for (int ch = 0; ch < MXConfig.SLIDER_COUNT; ++ch) {
            tempMessage =MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_CCCHANNELVOLUME, 0);
            cvalue = MXControllerStatus.fromMessage(tempMessage);
            cvalue._valueCurrent = cvalue._valueResetPosition;

            listSliderData.add(cvalue);
        }
        for (int ch = 0; ch < MXConfig.SLIDER_COUNT; ++ch) {
            tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, ch, MXMidiCode.DATA1_CCPANPOT, 64);
            cvalue = MXControllerStatus.fromMessage(tempMessage);
            cvalue._valueCurrent = cvalue._valueResetPosition;
            listCircleData.add(cvalue);
        }

        MXPadStatus r1 = MXPadStatus.createForControlChange(mixer._assigned, 0, MXMidiCode.DATA1_CCDUMPERPEDAL);
        MXPadStatus r2 = MXPadStatus.createForNoteON(mixer._assigned, 0, 12 * 5 + 0);
        MXPadStatus r3 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 0);
        MXPadStatus r4 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 1);
        MXPadStatus r5 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 2);
        MXPadStatus r6 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 3);
        MXPadStatus r7 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 4);
        MXPadStatus r8 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 5);
        MXPadStatus r9 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 5 + 6);

        listRhythmData = new ArrayList<MXPadStatus>();
        listRhythmData.add(r1);
        listRhythmData.add(r2);
        listRhythmData.add(r3);
        listRhythmData.add(r4);
        listRhythmData.add(r5);
        listRhythmData.add(r6);
        listRhythmData.add(r7);
        listRhythmData.add(r8);
        listRhythmData.add(r9);
        
        mixer.setMixerElement(listSliderData, listCircleData, listRhythmData);
        */
    }

/*
    public void loadMixerTemplateSmallDAW(MXMixerWindowData mixer) {
        MXControllerStatus cvalue = null;
        MXMessage tempMessage = null;

        ArrayList<MXControllerStatus> listSliderData = new ArrayList<MXControllerStatus>();
        ArrayList<MXControllerStatus> listCircleData = new ArrayList<MXControllerStatus>();
        ArrayList<MXPadStatus> listRhythmData = new ArrayList<MXPadStatus>();
        
        int[] knobValue = { 7, 74, 71, 76, 77, 93, 73, 75 };
        int[] sliderValue = { 114, 18, 19, 16, 17, 91, 79, 72 };

        for (int ch = 0; ch < 8; ++ch) {
            tempMessage =MXMessage.createChannelMessage(MXMidiCode.COMMAND_CONTROLCHANGE, 0, sliderValue[ch], 0);
            cvalue = MXControllerStatus.fromMessage(tempMessage);
            cvalue._valueCurrent = cvalue._valueResetPosition = 0;
            listSliderData.add(cvalue);
        }


        for (int ch = 0; ch < 8; ++ch) {
            tempMessage = MXMessage.createChannelMessage(MXMidiCode.COMMAND_CONTROLCHANGE, 0, knobValue[ch], 0);
            cvalue = MXControllerStatus.fromMessage(tempMessage);
            cvalue._valueCurrent = cvalue._valueResetPosition = 0;
            listCircleData.add(cvalue);
        }

        MXPadStatus r1 = MXPadStatus.createForControlChange(0, MXMidiCode.DATA1_CCDUMPERPEDAL);
        MXPadStatus r2 = MXPadStatus.createForNoteON(0, 12 * 0 + 0);
        MXPadStatus r3 = MXPadStatus.createForNoteON(9, 12 * 0 + 1);
        MXPadStatus r4 = MXPadStatus.createForNoteON(9, 12 * 0 + 2);
        MXPadStatus r5 = MXPadStatus.createForNoteON(9, 12 * 0 + 3);
        MXPadStatus r6 = MXPadStatus.createForNoteON(9, 12 * 0 + 4);
        MXPadStatus r7 = MXPadStatus.createForNoteON(9, 12 * 0 + 5);
        MXPadStatus r8 = MXPadStatus.createForNoteON(9, 12 * 0 + 6);
        MXPadStatus r9 = MXPadStatus.createForNoteON(9, 12 * 0 + 7);
 
        listRhythmData = new ArrayList<MXPadStatus>();
        listRhythmData.add(r1);
        listRhythmData.add(r2);
        listRhythmData.add(r3);
        listRhythmData.add(r4);
        listRhythmData.add(r5);
        listRhythmData.add(r6);
        listRhythmData.add(r7);
        listRhythmData.add(r8);
        listRhythmData.add(r9);
        
        mixer.setMixerElement(listSliderData, listCircleData, listRhythmData);
    }*/

    public void loadMixerTemplateDAW(MX32PageData mixer) {
        /*
        MXControllerStatus cvalue = null;
        MXMessage tempMessage = null;

        mixer._mixerName = "Template[ DAW ]";

        ArrayList<MXControllerStatus> listSliderData = new ArrayList<MXControllerStatus>();
        ArrayList<MXControllerStatus> listCircleData = new ArrayList<MXControllerStatus>();
        ArrayList<MXPadStatus> listRhythmData = new ArrayList<MXPadStatus>();
        
        int[] knobValue = { 21, 22, 23, 24, 25, 26, 27, 28, MXMidiCode.DATA1_CCEXPRESSION };
        int[] sliderValue = { 41, 42, 43, 44, 45, 46, 47, 48, MXMidiCode.DATA1_CCCHANNELVOLUME };

        for (int ch = 0; ch < sliderValue.length; ++ch) {
            tempMessage =MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, 0, sliderValue[ch], 0);
            cvalue = MXControllerStatus.fromMessage(tempMessage);
            cvalue._valueCurrent = cvalue._valueResetPosition = 0;
            listSliderData.add(cvalue);
        }

        for (int ch = 0; ch < knobValue.length ; ++ch) {
            tempMessage = MXMessage.createChannelMessage(mixer._assigned,MXMidiCode.COMMAND_CONTROLCHANGE, 0, knobValue[ch], 0);
            cvalue = MXControllerStatus.fromMessage(tempMessage);
            cvalue._valueCurrent = cvalue._valueResetPosition = 0;
            listCircleData.add(cvalue);
        }

        MXPadStatus r1 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 36);
        MXPadStatus r2 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 37);
        MXPadStatus r3 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 38);
        MXPadStatus r4 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 39);
        MXPadStatus r5 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 40);
        MXPadStatus r6 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 41);
        MXPadStatus r7 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 42);
        MXPadStatus r8 = MXPadStatus.createForNoteON(mixer._assigned, 9, 12 * 0 + 43);
        MXPadStatus r9 = MXPadStatus.createForControlChange(mixer._assigned, 0, MXMidiCode.DATA1_CCDUMPERPEDAL);
 
        listRhythmData = new ArrayList<MXPadStatus>();
        listRhythmData.add(r1);
        listRhythmData.add(r2);
        listRhythmData.add(r3);
        listRhythmData.add(r4);
        listRhythmData.add(r5);
        listRhythmData.add(r6);
        listRhythmData.add(r7);
        listRhythmData.add(r8);
        listRhythmData.add(r9);
        
        mixer.setMixerElement(listSliderData, listCircleData, listRhythmData);

*/
    }

    public void factoryResetSoundModule() {
        /*
MX40Data module = MXConfig.getSoundModule();
        
        MX40Group group = new MX40Group(module);
        
        group._catchProgram = true;
        group._requiredProgram = 4;
        
        MX40Layer layer1 = new MX40Layer(group);
        layer1.useFixedChannel = true;
        layer1.fixedChannel = 1+10;
        layer1.needSendProgramFixed = true;
        layer1.fixedProgram = 4; //FMピアノ
        layer1.needSendBankAsIs = true;
        layer1.fixedBankMSB = 32;
        layer1.onlyNoteFrom = 12 * 5;
        layer1.onlyNoteTo = 127;

        MX40Layer layer2 = new MX40Layer(group);
        layer2.useFixedChannel = true;
        layer2.fixedChannel = 2+10;
        layer2.needSendProgramFixed = true;
        layer2.fixedProgram = 48; //ストリングアンサンブル
        layer2.needSendBankAsIs = true;
        layer2.fixedBankMSB = 2;
        layer2.sendPlusTranspose = -12;
        layer2.onlyNoteFrom = 12 * 5;
        layer2.onlyNoteTo = 127;
        
        MX40Layer layer3 = new MX40Layer(group);
        layer3.useFixedChannel = true;
        layer3.fixedChannel = 3+10;
        layer3.needSendProgramFixed = true;
        layer3.fixedProgram = 35; //フレットレスベース
        layer3.needSendBankAsIs = true;
        layer3.fixedBankMSB = 32;
        layer3.onlyNoteFrom = 0;
        layer3.onlyNoteTo = 12 * 5 - 1;
        
        group.addLayer(layer1);
        group.addLayer(layer2);
        group.addLayer(layer3);
        module.addGroup(group);


        MX40Group group2 = new MX40Group(module);
        
        group2._catchProgram = true;
        group2._requiredProgram = 1;
        group2._rotateLayer = true;
        
        MX40Layer piano1 = new MX40Layer(group2);
        piano1.useFixedChannel = true;
        piano1.fixedChannel = 1+10;
        piano1.needSendProgramFixed = true;
        piano1.fixedProgram = 8;
        piano1.needSendPanning = true;
        piano1.fixedPan = 0;

        MX40Layer piano2 = new MX40Layer(group2);
        piano2.useFixedChannel = true;
        piano2.fixedChannel = 2+10;
        piano2.needSendProgramFixed = true;
        piano2.fixedProgram = 8;
        piano2.needSendPanning = true;
        piano2.fixedPan = 64;

        MX40Layer piano3 = new MX40Layer(group2);
        piano3.useFixedChannel = true;
        piano3.fixedChannel = 3+10;
        piano3.needSendProgramFixed = true;
        piano3.fixedProgram = 8;
        piano3.needSendPanning = true;
        piano3.fixedPan = 127;

        group2.addLayer(piano1);
        group2.addLayer(piano2);
        group2.addLayer(piano3);
        module.addGroup(group2);
*/
    }
}
