/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx60output;

import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.synthtarou.midimixer.MXMidiLogger;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.swing.JTableWithColumnHeader;
import jp.synthtarou.midimixer.libs.swing.JTableWithFooter;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX60View extends javax.swing.JPanel {
    MX60Process _process;
    private static final MXDebugConsole _debug = new MXDebugConsole(MX60View.class);
    JTableWithColumnHeader _jTableSkip;
    boolean _useSkipCC = true;
    MXMidiLogger _logger;
    
    /**
     * Creates new form MX50
     */
    public MX60View(MX60Process process) {
        _process = process; 
        initComponents();
        
        jPanelOutputSelect.add(new MX60MidiOutListPanel());

        _jTableSkip = new JTableWithFooter(jPanel1);
        resetTableModel();
        _jTableSkip.addMouseListener(new java.awt.event.MouseAdapter() {
            @Override
            public void mousePressed(java.awt.event.MouseEvent evt) {
                if (_jTableSkip.isEnabled()) {
                    jTableSkip_MouseClicked(evt);
                }
            }
        });
        DefaultTableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        tableCellRenderer.setHorizontalAlignment(JLabel.CENTER);

        for (int i = 1; i < _jTableSkip.getColumnCount(); ++ i) {
            TableColumn col = _jTableSkip.getColumnModel().getColumn(i);
            col.setCellRenderer(tableCellRenderer);
        }
        jCheckBoxUseSkip.setSelected(_process.isUsingThisRecipe());
        _jTableSkip.setEnabled(_process.isUsingThisRecipe());
        jPanel2.add(_process.getPatchBay().getReceiverView());

        jCheckBoxUseLogging.setSelected(_process.isUseLogging());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane2 = new javax.swing.JSplitPane();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanelOutputSelect = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jCheckBoxUseSkip = new javax.swing.JCheckBox();
        jSplitPane3 = new javax.swing.JSplitPane();
        jPanel2 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList<>();
        jCheckBoxUseLogging = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        jButtonModePopup = new javax.swing.JButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jSplitPane2.setDividerLocation(250);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jSplitPane1.setDividerLocation(300);

        jPanelOutputSelect.setBorder(javax.swing.BorderFactory.createTitledBorder("1.Assign Output"));
        jPanelOutputSelect.setLayout(new javax.swing.BoxLayout(jPanelOutputSelect, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane1.setLeftComponent(jPanelOutputSelect);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("3.Skip Which"));
        jPanel3.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel1, gridBagConstraints);

        jCheckBoxUseSkip.setText("Use This Recipe");
        jCheckBoxUseSkip.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseSkipActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel3.add(jCheckBoxUseSkip, gridBagConstraints);

        jSplitPane1.setRightComponent(jPanel3);

        jSplitPane2.setTopComponent(jSplitPane1);

        jSplitPane3.setDividerLocation(350);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("2. Port Forwarding"));
        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.LINE_AXIS));
        jSplitPane3.setLeftComponent(jPanel2);

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("4. Logging"));
        jPanel4.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(jScrollPane1, gridBagConstraints);

        jCheckBoxUseLogging.setText("Use This Recipe");
        jCheckBoxUseLogging.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseLoggingActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel4.add(jCheckBoxUseLogging, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(jLabel1, gridBagConstraints);

        jButtonModePopup.setText("Style");
        jButtonModePopup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModePopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel4.add(jButtonModePopup, gridBagConstraints);

        jSplitPane3.setRightComponent(jPanel4);

        jSplitPane2.setBottomComponent(jSplitPane3);

        add(jSplitPane2);
    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxUseSkipActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseSkipActionPerformed
         _process.setUsingThisRecipe(jCheckBoxUseSkip.isSelected());
        _jTableSkip.setEnabled(jCheckBoxUseSkip.isSelected());
    }//GEN-LAST:event_jCheckBoxUseSkipActionPerformed

    private void jCheckBoxUseLoggingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseLoggingActionPerformed
        _process.setUseLogging(jCheckBoxUseLogging.isSelected());
    }//GEN-LAST:event_jCheckBoxUseLoggingActionPerformed

    private void jButtonModePopupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModePopupActionPerformed
        _logger.showModePopupMenu(jButtonModePopup);
    }//GEN-LAST:event_jButtonModePopupActionPerformed

    public synchronized TableModel createSkipTableModel() {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };

        model.addColumn("");
        
        for (int i = 0; i < MXStatic.TOTAL_PORT_COUNT; ++ i) {
            model.addColumn(MXUtilMidi.nameOfPort(i));
        }
        
        for (int row = 0; row < _process._data.TYPE_COUNT; ++ row) {
            Vector line = new Vector();
            line.add(_process._data.typeNames[row]);
            
            for (int delivery = 0; delivery < MXStatic.TOTAL_PORT_COUNT; ++ delivery) {
                int type = row + 1;
                if (_process._data.isSkip(delivery, type)) {
                    line.add("Skip");
                }else {
                    line.add("");
                }
            }
            model.addRow(line);
        }
        return model;

    }

    public void setLogger(MXMidiLogger logger) {    
        _logger = logger;
        logger.attach(jList1);
    }

    private void jTableSkip_MouseClicked(java.awt.event.MouseEvent evt) {                                     
        int row = _jTableSkip.rowAtPoint(evt.getPoint());
        int column = _jTableSkip.columnAtPoint(evt.getPoint());
        
        int type = row + 1;
        int port = column - 1;
        DefaultTableModel model = (DefaultTableModel)_jTableSkip.getModel();
        
        if (type >= 1 && type <= _process._data.TYPE_COUNT) {
            if (port >= 0 && port < MXStatic.TOTAL_PORT_COUNT) {
                if (_process._data.isSkip(port, type)) {
                    _process._data.setSkip(port, type, false);
                    model.setValueAt("", row, column);
                }else {
                    _process._data.setSkip(port, type, true);
                    model.setValueAt("Skip", row, column);
                }
            }
        }
    }                                    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonModePopup;
    private javax.swing.JCheckBox jCheckBoxUseLogging;
    private javax.swing.JCheckBox jCheckBoxUseSkip;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList<String> jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelOutputSelect;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JSplitPane jSplitPane3;
    // End of variables declaration//GEN-END:variables

    public void resetTableModel() {
        _jTableSkip.setModel(createSkipTableModel());
        _jTableSkip.getColumnModel().getColumn(0).setMinWidth(150);
    }
}
