/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx20patchbay;

import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.libs.MXDebugConsole;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX20Data {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX20Data.class);
    
    boolean[][] _transPort;
    int _portCount;

    public MX20Data() {
        _portCount = MXStatic.TOTAL_PORT_COUNT;
        _transPort = new boolean[_portCount][_portCount];
    }

    public int portCount() {
        return _portCount;
    }
    
    public boolean isEnabled(int fromPort, int toPort) {
        if (fromPort < 0 || toPort  < 0) {
            return false;
        }
        return _transPort[fromPort][toPort];
    }
    
    public void set(int fromPort, int toPort, boolean trans) {
        _transPort[fromPort][toPort] = trans;
    }

    public void clear() {
        _transPort = new boolean[_portCount][_portCount];
    }
    
}
