/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx00playlist;

import jp.synthtarou.midimixer.libs.swing.MXPianoComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.ShortMessage;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.swing.MXFileOpenChooser;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMidiPlayerDispatch;
import jp.synthtarou.midimixer.libs.midi.MXMidiPlayerDispatch.Callback;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX00View extends javax.swing.JPanel implements Callback {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX00View.class);

    static int DRUM_CH = 10 - 1;

    MX00PianoPanel[] _listKeyboard;
    MX00DrumPadPanel _drumPanel = null;
    MX00Process _process;
    MXMidiPlayerDispatch _player;

    FileWithId _selectedItem = null;
    
    public MX00View(MX00Process process) {
        _listKeyboard = new MX00PianoPanel[16];

        initComponents();
        
        jSlider1.setMinimum(0);
        jSlider1.setMaximum(10);
        jSlider1.setValue(0);
        _process = process;
        _player = MXMIDIIn.INTERNAL_SEQUENCER;
        _player.setCallback(this);
        jSplitPane1.setDividerLocation(350);
        jSplitPane2.setDividerLocation(300);
    }
    
    public void settingUpdated() {
        jListPlayList.setModel(_process._playListModel);
        jCheckBoxChain.setSelected(_process._playAsChained);
        jCheckBoxRepeat.setSelected(_process._playAsRepeated);
   }
    
    public void setSongName(String songName) {
        jTextFieldSongFile.setText(songName);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        jSplitPane2 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jScrollPanePlayList = new javax.swing.JScrollPane();
        jListPlayList = new javax.swing.JList<>();
        jPanel3 = new javax.swing.JPanel();
        jButtonUp = new javax.swing.JButton();
        jButtonAdd = new javax.swing.JButton();
        jButtonDown = new javax.swing.JButton();
        jButtonErase = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        jPanelSelInfo1 = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        jListFileInfo = new javax.swing.JList<>();
        jPanel2 = new javax.swing.JPanel();
        jButtonPlay = new javax.swing.JButton();
        jCheckBoxChain = new javax.swing.JCheckBox();
        jCheckBoxRepeat = new javax.swing.JCheckBox();
        jPanelRight = new javax.swing.JPanel();
        jSlider1 = new javax.swing.JSlider();
        jPanelPianoParent = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jPanelPiano = new javax.swing.JPanel();
        jTextFieldSongFile = new javax.swing.JTextField();
        ｊButtonPause = new javax.swing.JButton();

        setMinimumSize(new java.awt.Dimension(100, 30));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });
        setLayout(new java.awt.CardLayout());

        jSplitPane2.setDividerLocation(350);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("1.PlayList"));
        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.PAGE_AXIS));

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jListPlayList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListPlayListValueChanged(evt);
            }
        });
        jScrollPanePlayList.setViewportView(jListPlayList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(jScrollPanePlayList, gridBagConstraints);

        jPanel1.add(jPanel4);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jButtonUp.setText("Up");
        jButtonUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel3.add(jButtonUp, gridBagConstraints);

        jButtonAdd.setText("Add");
        jButtonAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel3.add(jButtonAdd, gridBagConstraints);

        jButtonDown.setText("Down");
        jButtonDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel3.add(jButtonDown, gridBagConstraints);

        jButtonErase.setText("Del");
        jButtonErase.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonEraseActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel3.add(jButtonErase, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jPanel5, gridBagConstraints);

        jPanel1.add(jPanel3);

        jSplitPane2.setLeftComponent(jPanel1);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jPanelSelInfo1.setBorder(javax.swing.BorderFactory.createTitledBorder("2.Information"));
        jPanelSelInfo1.setLayout(new javax.swing.BoxLayout(jPanelSelInfo1, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane4.setViewportView(jListFileInfo);

        jPanelSelInfo1.add(jScrollPane4);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        jPanel6.add(jPanelSelInfo1, gridBagConstraints);

        jButtonPlay.setText("Play");
        jButtonPlay.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPlayActionPerformed(evt);
            }
        });
        jPanel2.add(jButtonPlay);

        jCheckBoxChain.setText("Chained");
        jCheckBoxChain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxChainActionPerformed(evt);
            }
        });
        jPanel2.add(jCheckBoxChain);

        jCheckBoxRepeat.setText("Repeat");
        jCheckBoxRepeat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxRepeatActionPerformed(evt);
            }
        });
        jPanel2.add(jCheckBoxRepeat);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel6.add(jPanel2, gridBagConstraints);

        jSplitPane2.setRightComponent(jPanel6);

        jSplitPane1.setLeftComponent(jSplitPane2);

        jPanelRight.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelRight.add(jSlider1, gridBagConstraints);

        jPanelPianoParent.setBorder(javax.swing.BorderFactory.createTitledBorder("Piano"));
        jPanelPianoParent.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                jPanelPianoParentComponentResized(evt);
            }
            public void componentShown(java.awt.event.ComponentEvent evt) {
                jPanelPianoParentComponentShown(evt);
            }
        });
        jPanelPianoParent.setLayout(new javax.swing.BoxLayout(jPanelPianoParent, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane3.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jPanelPiano.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                jPanelPianoComponentResized(evt);
            }
        });
        jPanelPiano.setLayout(new java.awt.GridBagLayout());
        jScrollPane3.setViewportView(jPanelPiano);

        jPanelPianoParent.add(jScrollPane3);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelRight.add(jPanelPianoParent, gridBagConstraints);

        jTextFieldSongFile.setEditable(false);
        jTextFieldSongFile.setText("3.Playinng");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelRight.add(jTextFieldSongFile, gridBagConstraints);

        ｊButtonPause.setText("PAUSE");
        ｊButtonPause.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ｊButtonPauseActionPerformed(evt);
            }
        });
        jPanelRight.add(ｊButtonPause, new java.awt.GridBagConstraints());

        jSplitPane1.setRightComponent(jPanelRight);

        add(jSplitPane1, "card2");
        jSplitPane1.getAccessibleContext().setAccessibleDescription("");
    }// </editor-fold>//GEN-END:initComponents

    public void createPianoControls(int lowNote, int octaveRange, boolean[] aciveChannels, int[] listPrograms, int[] drumProgs) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            int againNote = lowNote;
            int againRange = octaveRange;
            SwingUtilities.invokeLater(new Runnable() { 
                public void run() { 
                    createPianoControls(againNote, againRange, aciveChannels, listPrograms, drumProgs);
                }
            });
            return;
        }

        invalidate();
        _listKeyboard = new MX00PianoPanel[16];
        _drumPanel = null;
       
        for (int i = jPanelPiano.getComponentCount(); i >=1 ; i --) {
            Component comp = jPanelPiano.getComponent(i - 1);
            jPanelPiano.remove(comp);
        }

        int height = 50;
        
        _drumPanel = new MX00DrumPadPanel();
        for (int note : drumProgs) {
            _drumPanel.addNote(note);
        }
        int rows = 0;
        for (int ch = 0; ch < 16; ++ ch) {
            if (aciveChannels[ch]) {
                MXPianoComponent keys = new MXPianoComponent();
                //maybe more better tune
                while (octaveRange <= 4) {
                    octaveRange += 2;
                    lowNote -= 12;
                }
                while (octaveRange < 5) {
                    octaveRange ++;
                }
                keys.setNoteRange(lowNote, octaveRange);

                if (ch == DRUM_CH) {
                    if (_drumPanel != null) {
                        GridBagConstraints cont = new GridBagConstraints();
                        cont.gridx = 0;
                        cont.gridy = rows;
                        cont.weightx = 1.0;
                        cont.weighty = 0;
                        cont.fill = GridBagConstraints.HORIZONTAL;

                        _drumPanel.setMinimumSize(new Dimension(300, height));

                        cont.fill = GridBagConstraints.HORIZONTAL;
                        jPanelPiano.add(_drumPanel, cont);
                        rows ++;
                    }
                }else {
                    MX00PianoPanel piano = new MX00PianoPanel(keys);
                    piano.setChannel(ch);
                    piano.updateProgramNumber(listPrograms[ch] < 0 ? 0 : listPrograms[ch]);
                    piano.setMinimumSize(new Dimension(300, height));
                    piano.setPreferredSize(new Dimension(300, height));
                    piano.setMaximumSize(new Dimension(2000, height));

                    GridBagConstraints cont = new GridBagConstraints();
                    cont.gridx = 0;
                    cont.gridy = rows;
                    cont.weightx = 1.0;
                    cont.weighty = 0;
                    cont.fill = GridBagConstraints.HORIZONTAL;
                    jPanelPiano.add(piano, cont);
                    _listKeyboard[ch] = piano;
                    rows ++;
                }
            }
        }

        GridBagConstraints cont2 = new GridBagConstraints();
        cont2.gridx = 0;
        cont2.gridy = rows;
        cont2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        cont2.fill = java.awt.GridBagConstraints.BOTH;
        cont2.weightx = 1.0;
        cont2.weighty = 3.0;
        jPanelPiano.add(new JPanel(), cont2);

        GridBagConstraints cont = new GridBagConstraints();
        cont.gridx = 0;
        cont.gridy = rows;
        cont.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        cont.fill = java.awt.GridBagConstraints.BOTH;
        cont.weightx = 1.0;
        cont.weighty = 1.0;

        cont.fill = GridBagConstraints.BOTH;
        jPanelPiano.add(new JPanel(), cont);
        rows ++;

        autoResizePiano();
    }
    
    public void autoResizePiano() {
        try {
            if (_drumPanel != null) {
                SwingUtilities.invokeLater(new Runnable(){
                    public void run() {
                        _drumPanel.setPreferredSize(new Dimension(jPanelRight.getWidth() - 70, 350));
                        _drumPanel.updateUI();
                        /*SwingUtilities.invokeLater(new Runnable(){
                            public void run() {*/
                                int maxHeight = 0;
                                for (JToggleButton c : _drumPanel.listDrums) {
                                    if (c != null) {
                                        Rectangle r = c.getBounds();
                                        int height = r.y + r.height;
                                        if (maxHeight < height) {
                                            maxHeight = height;
                                        }
                                    }
                                }
                                _drumPanel.setPreferredSize(new Dimension(jPanelRight.getWidth() - 70, maxHeight));
                                _drumPanel.setSize(new Dimension(jPanelRight.getWidth() - 70, maxHeight));
                        /*    }
                        });*/
                    }
                });
            }
            for (int ch = 0; ch < 16; ++ ch) {
                if (_listKeyboard[ch] != null) {
                    _listKeyboard[ch].autoAdjustHeight(jPanelRight.getWidth() - 70);
                    _listKeyboard[ch]._keys.invalidate();
                }
            }
            revalidate();
        }catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    private void jButtonAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddActionPerformed
        MXFileOpenChooser chooser = new MXFileOpenChooser();

        chooser.addExtension(".mid", "Standard MIDI File");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle("Add Standard MIDI File");

        if (chooser.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) {
            return;
        }

        File file = chooser.getSelectedFile();
        _process._playListModel.addElement(new FileWithId(file));
    }//GEN-LAST:event_jButtonAddActionPerformed

    private void jListPlayListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListPlayListValueChanged
        int x = jListPlayList.getSelectedIndex();
        if (x >= 0) {
            FileWithId f = (FileWithId)_process._playListModel.get(x);
            DefaultListModel model = new DefaultListModel();
            Date lastDate = new Date(f._file.lastModified());
            String textDate = DateFormat.getDateTimeInstance().format(lastDate);

            model.addElement("Path: " + f._file.getPath());
            model.addElement("Size: " + f._file.length());
            model.addElement("Date: " + textDate);

            _selectedItem = f;
            
            try {
                String[] str = _player.readFileInfo(f);
                model.addElement("MetaInfo: ");
                for (int i = 0; i < str.length; ++ i) {
                    model.addElement(str[i]);
                }
            }catch(Exception e) {
                e.printStackTrace();
            }            
            jListFileInfo.setModel(model);
        }
    }//GEN-LAST:event_jListPlayListValueChanged

    private void jButtonEraseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonEraseActionPerformed
        int x = jListPlayList.getSelectedIndex();
        if (x >= 0) {
            FileWithId file = (FileWithId)_process._playListModel.elementAt(x);
            if (_process._file != null && _process._file._id == file._id) {
                if (JOptionPane.showConfirmDialog(
                        this, 
                        file +" is current song.\nThis operation will cancel Chain / Repeat.", 
                        null,
                        JOptionPane.OK_CANCEL_OPTION) 
                    == JOptionPane.OK_OPTION) {
                    jCheckBoxChain.setSelected(false);
                    jCheckBoxRepeat.setSelected(false);
                    _process._playListModel.remove(x);
                }
            }else {            
                _process._playListModel.remove(x);
            }
        }        
    }//GEN-LAST:event_jButtonEraseActionPerformed

    private void jButtonUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUpActionPerformed
        int x = jListPlayList.getSelectedIndex();
        if (x >= 1) {
            FileWithId f = (FileWithId)_process._playListModel.elementAt(x);
            _process._playListModel.remove(x);
            _process._playListModel.add(x - 1, f);
            jListPlayList.setSelectedIndex(x - 1);
        }        
    }//GEN-LAST:event_jButtonUpActionPerformed

    private void jButtonDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDownActionPerformed
        int x = jListPlayList.getSelectedIndex();
        if (x >= 0 && x < _process._playListModel.size() - 1) {
            FileWithId f = (FileWithId)_process._playListModel.elementAt(x);
            _process._playListModel.remove(x);
            _process._playListModel.add(x+1, f);
            jListPlayList.setSelectedIndex(x+1);
        }        
    }//GEN-LAST:event_jButtonDownActionPerformed

    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
        autoResizePiano();
    }//GEN-LAST:event_formComponentResized

    private void jPanelPianoComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jPanelPianoComponentResized
    }//GEN-LAST:event_jPanelPianoComponentResized

    private void ｊButtonPauseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ｊButtonPauseActionPerformed
        if (_player.isSequencerPlaying()) {
            _player.stopSequencer();
        }else {
            if (_process._file != null) {
                _selectedItem = _process._file;
            }
            turnOnMusic(_selectedItem, jSlider1.getValue());
        }
    }//GEN-LAST:event_ｊButtonPauseActionPerformed

    private void jButtonPlayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPlayActionPerformed
        _player.stopSequencer();
        turnOnMusic(_selectedItem, 0);
    }//GEN-LAST:event_jButtonPlayActionPerformed

    private void jCheckBoxChainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxChainActionPerformed
        _process._playAsChained = jCheckBoxChain.isSelected();
    }//GEN-LAST:event_jCheckBoxChainActionPerformed

    private void jCheckBoxRepeatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxRepeatActionPerformed
        _process._playAsRepeated = jCheckBoxRepeat.isSelected();
    }//GEN-LAST:event_jCheckBoxRepeatActionPerformed

    private void jPanelPianoParentComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jPanelPianoParentComponentResized
    }//GEN-LAST:event_jPanelPianoParentComponentResized

    private void jPanelPianoParentComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jPanelPianoParentComponentShown
    }//GEN-LAST:event_jPanelPianoParentComponentShown

    public void scoreProgress(int pos, int max) {
        jSlider1.setMaximum(max);
        jSlider1.setValue(pos);
    }
    
    public void turnOnMusic(final FileWithId file, final int pos) {
        try {
            if (file == null) {
                JOptionPane.showMessageDialog(this, "Choice one from PlayList", "Error", JOptionPane.OK_OPTION);
                return;
            }
            if (_process._playListModel.indexOf(file) < 0) {
                JOptionPane.showMessageDialog(this, file + " is not in PlayList", "Error", JOptionPane.OK_OPTION);
                return;
            }
            try{
                _player.openFile(file);
                _process._file = file;
            }catch(Throwable e) {
                e.printStackTrace();
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                jListPlayList.setSelectedValue(file, true);
                jSlider1.setValue(pos); 
            }else {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        jListPlayList.setSelectedValue(file, true);
                        jSlider1.setValue(pos); 
                    }
                });
            }
            _player.setCurrentPos(pos);
            _player.startSequencer();
        } catch (InterruptedException ex) {
            Logger.getLogger(MX00View.class.getName()).log(Level.SEVERE, null, ex);
        } catch (InvocationTargetException ex) {
            Logger.getLogger(MX00View.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    public void scoreDone(FileWithId file) {
        FileWithId next = null;
        
        if (_process._playAsChained) {
            for (int i = 0; i < _process._playListModel.size() ;++ i) {
                FileWithId seek = (FileWithId)_process._playListModel.get(i);
                if (seek == file) {
                    i ++;
                    if (i < _process._playListModel.size()) {
                        next = (FileWithId)_process._playListModel.get(i);
                        break;
                    }else if (_process._playAsRepeated) {
                        i = 0;
                        if (i < _process._playListModel.size()) {
                            next = (FileWithId)_process._playListModel.get(0);
                            break;
                        }else {
                            next = null;
                            break;
                        }
                    }
                }
            }
        }else if (_process._playAsRepeated) {
            next = file;
        }else {
            next = null;
        }
        
        if (next != null) {
            _selectedItem = next;
            turnOnMusic(next, 0);
        }
    }
    
    public void uiUpdate(int port, MXMessage message) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    uiUpdate(port, message);
                }
            });
            return;
        }
        
        if (message.isMessageTypeChannel() == false) {
            return;
        }
        int channel = message.getChannel();
        int command = message.getCommand();
        int data1 = message.getData1FromBytes();
        int data2 = message.getData2FromBytes();

        if (command == ShortMessage.NOTE_ON && data2 == 0) {
            command = ShortMessage.NOTE_OFF;
        }

        if (command == ShortMessage.NOTE_ON) {
            if (channel != DRUM_CH) {
                MX00PianoPanel  piano =  _listKeyboard[channel];
                if (piano != null) {
                    piano.getKeys().noteOn(data1);
                }
            }else {
                MX00DrumPadPanel kit = _drumPanel;
                kit.noteOn(data1);
            }
        }
        else if (command == ShortMessage.NOTE_OFF) {
            if (channel != DRUM_CH) {
                MX00PianoPanel piano =  _listKeyboard[channel];
                if (piano != null) {
                    piano.getKeys().noteOff(data1);
                }
            }else {
                if (_drumPanel != null) {
                    MX00DrumPadPanel kit = _drumPanel;
                    kit.noteOff(data1);
                }
            }
        }
        else if (command == ShortMessage.CONTROL_CHANGE && data1 == 64) { // HOLD
            MX00PianoPanel  piano =  _listKeyboard[channel];
            if (piano != null) {
                piano.getKeys().sustain(data2);
            }
        } else if (command == ShortMessage.PROGRAM_CHANGE) {
            MX00PianoPanel  piano =  _listKeyboard[channel];
            if (piano != null) {
                piano.updateProgramNumber(data1);
            }
        }
    }

    private ComboBoxModel _comboModel;
    private ComboBoxModel _channelSelectModel;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAdd;
    private javax.swing.JButton jButtonDown;
    private javax.swing.JButton jButtonErase;
    private javax.swing.JButton jButtonPlay;
    private javax.swing.JButton jButtonUp;
    private javax.swing.JCheckBox jCheckBoxChain;
    private javax.swing.JCheckBox jCheckBoxRepeat;
    private javax.swing.JList<String> jListFileInfo;
    private javax.swing.JList<String> jListPlayList;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanelPiano;
    private javax.swing.JPanel jPanelPianoParent;
    private javax.swing.JPanel jPanelRight;
    private javax.swing.JPanel jPanelSelInfo1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPanePlayList;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JTextField jTextFieldSongFile;
    private javax.swing.JButton ｊButtonPause;
    // End of variables declaration//GEN-END:variables

    @Override
    public void scoreStart(FileWithId File) {
        MXMain.getMain().sequencerStart();
    }
}
