/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.libs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXLineWriter {
    OutputStream _fout;
    PrintWriter _writer;
    
    String _charset;
   
    public MXLineWriter(File file, String charset) throws IOException {
        _fout = new FileOutputStream(file);
        try {
            _writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(_fout, charset)));
        }catch(IOException ioe) {
            try {
                _fout.close();
            }catch(IOException e) {
            }
            _fout = null;
            throw ioe;
        }
        _writer.println("#charset=" + charset);
    }
    
    public void close() throws IOException {
        if (_writer != null) {
            _writer.flush();
            _writer.close();
            _writer = null;
        }
    }
    
    public void println(String text) {
        _writer.println(text);
    }

    public PrintWriter getWriter() {
        return _writer;
    }
    
}
