/*
 * Copyright (C) 2022 YOSHIDA Shintarou
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.console.MXConsoleMidiRenderer;
import jp.synthtarou.midimixer.libs.console.MXConsoleModel;
import jp.synthtarou.midimixer.libs.midi.MXMessage;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMidiLogger extends MXReceiver {
    MXConsoleModel _console;
    String _name;
    
    public MXMidiLogger(String name) {
        _name = name;
        _console = new MXConsoleModel(name, 500);
    }
    
    public void attach(JList list) {
        _console.installConsole(list);
        list.setModel(_console);                    
    }

    public class FireMenu implements ActionListener {
        int _mode;

        public FireMenu(int mode) {
            _mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            _console.getRenderer().setMode(_mode);
            _console.fireRepaint();
        }
    }
            
    public void showModePopupMenu(JComponent where) {
        JPopupMenu menu = new JPopupMenu();
        MXWrapList<Integer> menuModel = MXConsoleMidiRenderer.getModeDataModel();
        for (int i = 0; i < menuModel.getSize(); ++ i) {
            MXWrap<Integer> e = menuModel.get(i);
            JMenuItem item = new JMenuItem(e.name);
            item.addActionListener(new FireMenu(e.value));
            menu.add(item);
        }
        menu.show(where, 0, where.getHeight());
    }

    @Override
    public String getReceiverName() {
        return _name;
    }

    @Override
    public JComponent getReceiverView() {
        return null;
    }

    @Override
    public void processMXMessage(MXMessage message) {
        if (isUsingThisRecipe()) { 
            _console.addConsoleMessage(message);
        }

        if (getNextReceiver() != null) {
            sendToNext(message);
        }
    }
}
