/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx40layer;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMidiUI;
import jp.synthtarou.midimixer.libs.midi.programlist.database.ProgramPicker;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX40View extends javax.swing.JPanel {
    private static final MXDebugConsole _debug = new MXDebugConsole(MX40View.class);

    public MX40Process _process;
    
    MX40Group _editingGroup;
    MX40Layer _editingLayer;

    MXWrapList<Integer> _watchPort = MXMidiUI.createPort(false);
    MXWrapList<Integer> _watchChannel = MXMidiUI.createChannel(false);
    MXWrapList<Integer> _watchProgram = MXMidiUI.createProgram();

    MXWrapList<Integer> _modPort = MX40Layer.createSendOption(false);
    MXWrapList<Integer> _modChannel = MX40Layer.createSendOption(false);
    MXWrapList<Integer> _modBank = MX40Layer.createSendOption(true);
    MXWrapList<Integer> _modProgram = MX40Layer.createSendOption(true);

    MXWrapList<Integer> _changePort = MXMidiUI.createPort(false);
    MXWrapList<Integer> _changeChannel = MXMidiUI.createChannel(false);
    MXWrapList<Integer> _changeProgram = MXMidiUI.createProgram();
    MXWrapList<Integer> _changeVolume = MXMidiUI.createPercent();
    MXWrapList<Integer> _changeExpression = MXMidiUI.createPercent();

    MXWrapList<MX40Group> _groupList = null;
    MXWrapList<MX40Layer> _layerList = null;
    
    boolean underConstruction = true;

    public MX40View(MX40Process process) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        initComponents();
        _process = process;

        jTextFieldGroupName.setText("New Group");

        _editingGroup = null;
        jComboBoxWatchPort.setModel(_watchPort);
        jComboBoxWatchChannel.setModel(_watchChannel);
        jSpinnerWatchProgram.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        jSpinnerWatchBankMSB.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        jSpinnerWatchBankLSB.setModel(new SpinnerNumberModel(0, 0, 127, 1));

        jTextFieldLayerName.setText("New Layer");

        jComboBoxModPort.setModel(_modPort);
        jComboBoxSendPort.setModel(_changePort);
        jComboBoxModChannel.setModel(_modChannel);
        jComboBoxSendChannel.setModel(_changeChannel);
        jComboBoxModBank.setModel(_modBank);
        jComboBoxModProgram.setModel(_modProgram);
        
        jSpinnerSendProgram.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        jSpinnerSendBankMSB.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        jSpinnerSendBankLSB.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        
        jSpinnerSendAdjustPan.setModel(new SpinnerNumberModel(0, -64, 63, 1));
        jSpinnerSendAdjustExpression.setModel(new SpinnerNumberModel(0, -127, 128, 1));
        jSpinnerSendAdjustTranspose.setModel(new SpinnerNumberModel(0, -127, 128, 1));
        jSpinnerSendAdjustVelocity.setModel(new SpinnerNumberModel(0, -127, 128, 1));

        jCheckBoxUseLayer.setSelected(process.usingThis());

        _editingGroup = null;
        _editingLayer = null;

        listUpGroups();
        
        MX40Group gr;
        if (_groupList.size() > 0) {
            gr = _groupList.get(0).value;
        }else {
            gr = new MX40Group(_process);
        }
        startEditGroup(gr);
        
        MX40Layer ly;
        if (_layerList != null && _layerList.size() > 0) {
            ly = _layerList.get(0).value;
        }else {
            ly = new MX40Layer(_process, gr);
        }
        startEditLayer(ly, gr);

        jTable1.setModel(_process._inputInfo);
        jTable2.setModel(_process._outputInfo);
        
        MXUtil.autoResizeTableColumnWidth(jTable1);
        MXUtil.autoResizeTableColumnWidth(jTable2);

        underConstruction = false;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable3 = new javax.swing.JTable();
        jCheckBoxUseLayer = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        jPanelGroup = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldGroupName = new javax.swing.JTextField();
        jComboBoxWatchPort = new javax.swing.JComboBox<>();
        jComboBoxWatchChannel = new javax.swing.JComboBox<>();
        jCheckBoxPort = new javax.swing.JCheckBox();
        jCheckBoxChannel = new javax.swing.JCheckBox();
        jCheckBoxBank = new javax.swing.JCheckBox();
        jCheckBoxProgram = new javax.swing.JCheckBox();
        jCheckBoxRotateLayer = new javax.swing.JCheckBox();
        jButtonNewGroup = new javax.swing.JButton();
        jButtonApplyGroup = new javax.swing.JButton();
        jButtonRemoveGroup = new javax.swing.JButton();
        jButtonGroupProgram = new javax.swing.JButton();
        jButtonGroupUp = new javax.swing.JButton();
        jButtonGroupDown = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        jListGroupList = new javax.swing.JList<>();
        jSpinnerRotatePoly = new javax.swing.JSpinner();
        jSpinnerWatchProgram = new javax.swing.JSpinner();
        jSpinnerWatchBankMSB = new javax.swing.JSpinner();
        jSpinnerWatchBankLSB = new javax.swing.JSpinner();
        jPanelLayer = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        jTextFieldLayerName = new javax.swing.JTextField();
        jButtonNewLayer = new javax.swing.JButton();
        jButtonApplyLayer = new javax.swing.JButton();
        jButtonRemoveLayer = new javax.swing.JButton();
        jButtonLayerUp = new javax.swing.JButton();
        jButtonLayerDown = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jListLayerList = new javax.swing.JList<>();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jComboBoxModPort = new javax.swing.JComboBox<>();
        jComboBoxSendPort = new javax.swing.JComboBox<>();
        jComboBoxModChannel = new javax.swing.JComboBox<>();
        jComboBoxSendChannel = new javax.swing.JComboBox<>();
        jComboBoxModProgram = new javax.swing.JComboBox<>();
        jSpinnerSendProgram = new javax.swing.JSpinner();
        jComboBoxModBank = new javax.swing.JComboBox<>();
        jSpinnerSendBankMSB = new javax.swing.JSpinner();
        jSpinnerSendBankLSB = new javax.swing.JSpinner();
        jSpinnerSendAdjustPan = new javax.swing.JSpinner();
        jSpinnerSendAdjustExpression = new javax.swing.JSpinner();
        jComboBoxSendNoteLow = new javax.swing.JComboBox<>();
        jComboBoxSendNoteHigh = new javax.swing.JComboBox<>();
        jSpinnerSendAdjustTranspose = new javax.swing.JSpinner();
        jSpinnerSendAdjustVelocity = new javax.swing.JSpinner();
        jLabel14 = new javax.swing.JLabel();
        jLabel1TargetGroup = new javax.swing.JLabel();
        jButtonLayerProgram = new javax.swing.JButton();
        jPanel0 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane5 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane6 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();

        jTable3.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable3);

        setLayout(new java.awt.GridBagLayout());

        jCheckBoxUseLayer.setText("Use This Recipe");
        jCheckBoxUseLayer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUseLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(jCheckBoxUseLayer, gridBagConstraints);

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.LINE_AXIS));

        jSplitPane1.setDividerLocation(700);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanelGroup.setBorder(javax.swing.BorderFactory.createTitledBorder("Edit Group"));
        jPanelGroup.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Group Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelGroup.add(jLabel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jTextFieldGroupName, gridBagConstraints);

        jComboBoxWatchPort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxWatchPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jComboBoxWatchPort, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jComboBoxWatchChannel, gridBagConstraints);

        jCheckBoxPort.setText("Watch Port");
        jCheckBoxPort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelGroup.add(jCheckBoxPort, gridBagConstraints);

        jCheckBoxChannel.setText("Watch Channel");
        jCheckBoxChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelGroup.add(jCheckBoxChannel, gridBagConstraints);

        jCheckBoxBank.setText("Watch Bank (MSB/LSB)");
        jCheckBoxBank.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxBankActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelGroup.add(jCheckBoxBank, gridBagConstraints);

        jCheckBoxProgram.setText("Watch Program");
        jCheckBoxProgram.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelGroup.add(jCheckBoxProgram, gridBagConstraints);

        jCheckBoxRotateLayer.setText("Rotate Layer (Poly)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelGroup.add(jCheckBoxRotateLayer, gridBagConstraints);

        jButtonNewGroup.setText("Start New Group");
        jButtonNewGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelGroup.add(jButtonNewGroup, gridBagConstraints);

        jButtonApplyGroup.setText("Save Group");
        jButtonApplyGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonApplyGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jButtonApplyGroup, gridBagConstraints);

        jButtonRemoveGroup.setText("Remove");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelGroup.add(jButtonRemoveGroup, gridBagConstraints);

        jButtonGroupProgram.setText("Program Picker");
        jButtonGroupProgram.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGroupProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jButtonGroupProgram, gridBagConstraints);

        jButtonGroupUp.setText("Up");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelGroup.add(jButtonGroupUp, gridBagConstraints);

        jButtonGroupDown.setText("Down");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelGroup.add(jButtonGroupDown, gridBagConstraints);

        jScrollPane3.setViewportBorder(javax.swing.BorderFactory.createTitledBorder("Group List"));

        jListGroupList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListGroupListValueChanged(evt);
            }
        });
        jScrollPane3.setViewportView(jListGroupList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        jPanelGroup.add(jScrollPane3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jSpinnerRotatePoly, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jSpinnerWatchProgram, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jSpinnerWatchBankMSB, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelGroup.add(jSpinnerWatchBankLSB, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanelGroup, gridBagConstraints);

        jPanelLayer.setBorder(javax.swing.BorderFactory.createTitledBorder("Edit Layer"));
        jPanelLayer.setLayout(new java.awt.GridBagLayout());

        jLabel8.setText("Layer Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelLayer.add(jLabel8, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jTextFieldLayerName, gridBagConstraints);

        jButtonNewLayer.setText("Start New Layer");
        jButtonNewLayer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelLayer.add(jButtonNewLayer, gridBagConstraints);

        jButtonApplyLayer.setText("Save Layer");
        jButtonApplyLayer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonApplyLayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelLayer.add(jButtonApplyLayer, gridBagConstraints);

        jButtonRemoveLayer.setText("Remove");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelLayer.add(jButtonRemoveLayer, gridBagConstraints);

        jButtonLayerUp.setText("Up");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelLayer.add(jButtonLayerUp, gridBagConstraints);

        jButtonLayerDown.setText("Down");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelLayer.add(jButtonLayerDown, gridBagConstraints);

        jListLayerList.setBorder(javax.swing.BorderFactory.createTitledBorder("Layer List"));
        jListLayerList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListLayerListValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(jListLayerList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelLayer.add(jScrollPane2, gridBagConstraints);

        jLabel2.setText("Port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel2, gridBagConstraints);

        jLabel3.setText("Channel");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel3, gridBagConstraints);

        jLabel4.setText("Bank");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel4, gridBagConstraints);

        jLabel5.setText("Program");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel5, gridBagConstraints);

        jLabel7.setText("Pan");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel7, gridBagConstraints);

        jLabel9.setText("Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel9, gridBagConstraints);

        jLabel10.setText("LowNote");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel10, gridBagConstraints);

        jLabel11.setText("HiNote");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel11, gridBagConstraints);

        jLabel12.setText("Transpose");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel12, gridBagConstraints);

        jLabel13.setText("Velocity");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jLabel13, gridBagConstraints);

        jComboBoxModPort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxModPortActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jComboBoxModPort, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jComboBoxSendPort, gridBagConstraints);

        jComboBoxModChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxModChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jComboBoxModChannel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jComboBoxSendChannel, gridBagConstraints);

        jComboBoxModProgram.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxModProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jComboBoxModProgram, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jSpinnerSendProgram, gridBagConstraints);

        jComboBoxModBank.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxModBankActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelLayer.add(jComboBoxModBank, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelLayer.add(jSpinnerSendBankMSB, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelLayer.add(jSpinnerSendBankLSB, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jSpinnerSendAdjustPan, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelLayer.add(jSpinnerSendAdjustExpression, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jComboBoxSendNoteLow, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jComboBoxSendNoteHigh, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jSpinnerSendAdjustTranspose, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        jPanelLayer.add(jSpinnerSendAdjustVelocity, gridBagConstraints);

        jLabel14.setText("In Group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelLayer.add(jLabel14, gridBagConstraints);

        jLabel1TargetGroup.setText("-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelLayer.add(jLabel1TargetGroup, gridBagConstraints);

        jButtonLayerProgram.setText("Program Picker");
        jButtonLayerProgram.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLayerProgramActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanelLayer.add(jButtonLayerProgram, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jPanelLayer, gridBagConstraints);

        jSplitPane1.setLeftComponent(jPanel1);

        jPanel0.setLayout(new javax.swing.BoxLayout(jPanel0, javax.swing.BoxLayout.PAGE_AXIS));

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Input Info"));
        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane5.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane5.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane5.setViewportView(jTable1);

        jPanel4.add(jScrollPane5);

        jPanel0.add(jPanel4);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Output Info"));
        jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane6.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane6.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        jTable2.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane6.setViewportView(jTable2);

        jPanel3.add(jScrollPane6);

        jPanel0.add(jPanel3);

        jSplitPane1.setRightComponent(jPanel0);

        jPanel2.add(jSplitPane1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel2, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    public void enableUIs() {
        MX40Group group = new MX40Group(null);
        readGroupFromUI(group);
        jComboBoxWatchPort.setEnabled(group._isWatchPort);
        jComboBoxWatchChannel.setEnabled(group._isWatchChannel);
        jSpinnerWatchProgram.setEnabled(group._isWatchProgram);
        jSpinnerWatchBankMSB.setEnabled(group._isWatchBank);
        jSpinnerWatchBankLSB.setEnabled(group._isWatchBank);
        jButtonGroupProgram.setEnabled(group._isWatchBank || group._isWatchProgram);

        if (_editingGroup != null) {
            MX40Layer layer = new MX40Layer(null, group);
            readLayerFromUI(layer);
            jComboBoxSendPort.setEnabled(layer._modPort == MX40Layer.MOD_FIXED);
            jComboBoxSendChannel.setEnabled(layer._modChannel == MX40Layer.MOD_FIXED);
            jSpinnerSendBankMSB.setEnabled(layer._modBank == MX40Layer.MOD_FIXED);
            jSpinnerSendBankLSB.setEnabled(layer._modBank == MX40Layer.MOD_FIXED);
            jSpinnerSendProgram.setEnabled(layer._modProgram == MX40Layer.MOD_FIXED);
            jButtonLayerProgram.setEnabled(layer._modBank == MX40Layer.MOD_FIXED|| layer._modProgram == MX40Layer.MOD_FIXED);
            
            jButtonNewLayer.setEnabled(true);
            jButtonApplyLayer.setEnabled(true);
            jButtonApplyGroup.setEnabled(true);

            jComboBoxModProgram.setEnabled(true);
            jComboBoxModBank.setEnabled(true);
            jComboBoxModPort.setEnabled(true);
            jComboBoxModChannel.setEnabled(true);
        }else {
            jComboBoxSendPort.setEnabled(false);
            jComboBoxSendChannel.setEnabled(false);
            jSpinnerSendBankMSB.setEnabled(false);
            jSpinnerSendBankLSB.setEnabled(false);
            jSpinnerSendProgram.setEnabled(false);
            jButtonLayerProgram.setEnabled(false);

            jButtonNewLayer.setEnabled(false);
            jButtonApplyLayer.setEnabled(false);
            jButtonApplyGroup.setEnabled(false);

            jComboBoxModProgram.setEnabled(false);
            jComboBoxModBank.setEnabled(false);
            jComboBoxModPort.setEnabled(false);
            jComboBoxModChannel.setEnabled(false);
        }
    }

    private void jButtonNewGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewGroupActionPerformed
        MX40Group group = new MX40Group(_process);
        readGroupFromUI(group);
        for (int i = 0; i < _process._groupList.size(); ++ i) {
            String title = _process._groupList.get(i)._title;
            if (title.contains(group._title)) {
                JOptionPane.showMessageDialog(this, "Name [" + title + "] already used.", "Error" , JOptionPane.ERROR_MESSAGE);
                return;
            }
        }
        _process._groupList.add(group);
        listUpGroups();
        _editingGroup = null;
        _editingLayer = null;
        startEditGroup(group);
    }//GEN-LAST:event_jButtonNewGroupActionPerformed

    private void jCheckBoxUseLayerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUseLayerActionPerformed
        _process.setUsingThis(jCheckBoxUseLayer.isSelected());
        
        recursibleEnable(this, jCheckBoxUseLayer.isSelected());
        jCheckBoxUseLayer.setEnabled(true); // This controller must be enabled always
    }//GEN-LAST:event_jCheckBoxUseLayerActionPerformed

    private void jButtonApplyGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyGroupActionPerformed
        if (_editingGroup != null) {
            MX40Group group2 = new MX40Group(_process);
            readGroupFromUI(group2);
            
            if (group2._title.equals(_editingGroup._title) == false) {
                if (_groupList.indexOfName(group2._title) >= 0) {
                    JOptionPane.showMessageDialog(this, "name [" + group2._title + "] already used", "can't save", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            
            readGroupFromUI(_editingGroup);
            listUpGroups();
        }
    }//GEN-LAST:event_jButtonApplyGroupActionPerformed

    private void jListGroupListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListGroupListValueChanged
        int index = jListGroupList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        MXWrap<MX40Group> sel = (MXWrap)_groupList.get(index);
        MX40Group group = sel.value;
        if (group == null) {
            return;
        }
        if (_editingGroup != group) {
           startEditGroup(group);            
        }
    }//GEN-LAST:event_jListGroupListValueChanged

    private void jComboBoxWatchPortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxWatchPortActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBoxWatchPortActionPerformed

    private void jButtonNewLayerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewLayerActionPerformed
        MX40Group parent = _editingGroup;
        if (parent == null) {
            JOptionPane.showMessageDialog(this, "Choice Group 1st");
            return;
        }
        MX40Layer layer = new MX40Layer(_process, parent);
        readLayerFromUI(layer);
        for (int i = 0; i < parent._listLayer.size(); ++ i) {
            MX40Layer seek = parent._listLayer.get(i);
            String title = seek._title;
            if (title.equals(layer._title)) {
                JOptionPane.showMessageDialog(this, "Name [" + title + "] already used.", "Error" , JOptionPane.ERROR_MESSAGE);
                return;
            }
        }
        parent._listLayer.add(layer);
        listupLayers(parent);
        _editingLayer = null;
        startEditLayer(layer, parent);
        _process.resendProgramChange(null);
    }//GEN-LAST:event_jButtonNewLayerActionPerformed

    private void jButtonApplyLayerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyLayerActionPerformed
        if (_editingLayer != null) {
            MX40Layer layer2 = new MX40Layer(_process, _editingGroup);
            if (layer2._title.equals(_editingLayer._title) == false) {
                if (_layerList.indexOfName(layer2._title) >= 0) {
                    JOptionPane.showMessageDialog(this, "name [" + layer2._title + "] already used", "can't save", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            readLayerFromUI(_editingLayer);
            listupLayers(_editingGroup);
            _process.resendProgramChange(null);
        }
    }//GEN-LAST:event_jButtonApplyLayerActionPerformed

    private void jListLayerListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListLayerListValueChanged
        int index = jListLayerList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        MX40Layer sel = _editingGroup._listLayer.get(index);
        if (sel == null) {
            return;
        }
        if (sel != _editingLayer) {
            startEditLayer(sel, _editingGroup);
        }
    }//GEN-LAST:event_jListLayerListValueChanged

    private void jButtonGroupProgramActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGroupProgramActionPerformed
        MX40Group group = new MX40Group(null);
        readGroupFromUI(group);
        ProgramPicker picker = new ProgramPicker();
        picker.setDefault(group._watchingProgram, group._watchingBankMSB, group._watchingBankLSB);
        MXUtil.showAsDialog(this, picker, "Select Program");
        if (picker._returnProgram >= 0) {
            jSpinnerWatchProgram.setValue(picker._returnProgram);
            jSpinnerWatchBankMSB.setValue(picker._returnBankMSB);
            jSpinnerWatchBankLSB.setValue(picker._returnBankLSB);
            JOptionPane.showMessageDialog(this, "Push [Save Group] Please");
        }
    }//GEN-LAST:event_jButtonGroupProgramActionPerformed

    private void jButtonLayerProgramActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLayerProgramActionPerformed
        MX40Layer layer = new MX40Layer(null, null);
        readLayerFromUI(layer);
        ProgramPicker picker = new ProgramPicker();
        picker.setDefault(layer._fixedProgram, layer._fixedBankMSB, layer._fixedBankLSB);
        MXUtil.showAsDialog(this, picker, "Select Program");
        if (picker._returnProgram >= 0) {
            jSpinnerSendProgram.setValue(picker._returnProgram);
            jSpinnerSendBankMSB.setValue(picker._returnBankMSB);
            jSpinnerSendBankLSB.setValue(picker._returnBankLSB);
            JOptionPane.showMessageDialog(this, "Push [Save Layer] Please");
        }
    }//GEN-LAST:event_jButtonLayerProgramActionPerformed

    private void jCheckBoxPortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPortActionPerformed
        enableUIs();
    }//GEN-LAST:event_jCheckBoxPortActionPerformed

    private void jCheckBoxChannelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxChannelActionPerformed
        enableUIs();
    }//GEN-LAST:event_jCheckBoxChannelActionPerformed

    private void jCheckBoxBankActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxBankActionPerformed
        enableUIs();
    }//GEN-LAST:event_jCheckBoxBankActionPerformed

    private void jCheckBoxProgramActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxProgramActionPerformed
        enableUIs();
    }//GEN-LAST:event_jCheckBoxProgramActionPerformed

    private void jComboBoxModPortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxModPortActionPerformed
        enableUIs();
    }//GEN-LAST:event_jComboBoxModPortActionPerformed

    private void jComboBoxModChannelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxModChannelActionPerformed
        enableUIs();
    }//GEN-LAST:event_jComboBoxModChannelActionPerformed

    private void jComboBoxModBankActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxModBankActionPerformed
        enableUIs();
    }//GEN-LAST:event_jComboBoxModBankActionPerformed

    private void jComboBoxModProgramActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxModProgramActionPerformed
        enableUIs();
    }//GEN-LAST:event_jComboBoxModProgramActionPerformed

    public void recursibleEnable(Component c, boolean enable) { 
        if (c instanceof Container) {
            Container parent = (Container)c;
            int count = parent.getComponentCount();
            for (int x = 0; x < count; ++ x) {
                recursibleEnable(parent.getComponent(x), enable);
            }
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setEnabled(enable);
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonApplyGroup;
    private javax.swing.JButton jButtonApplyLayer;
    private javax.swing.JButton jButtonGroupDown;
    private javax.swing.JButton jButtonGroupProgram;
    private javax.swing.JButton jButtonGroupUp;
    private javax.swing.JButton jButtonLayerDown;
    private javax.swing.JButton jButtonLayerProgram;
    private javax.swing.JButton jButtonLayerUp;
    private javax.swing.JButton jButtonNewGroup;
    private javax.swing.JButton jButtonNewLayer;
    private javax.swing.JButton jButtonRemoveGroup;
    private javax.swing.JButton jButtonRemoveLayer;
    private javax.swing.JCheckBox jCheckBoxBank;
    private javax.swing.JCheckBox jCheckBoxChannel;
    private javax.swing.JCheckBox jCheckBoxPort;
    private javax.swing.JCheckBox jCheckBoxProgram;
    private javax.swing.JCheckBox jCheckBoxRotateLayer;
    private javax.swing.JCheckBox jCheckBoxUseLayer;
    private javax.swing.JComboBox<String> jComboBoxModBank;
    private javax.swing.JComboBox<String> jComboBoxModChannel;
    private javax.swing.JComboBox<String> jComboBoxModPort;
    private javax.swing.JComboBox<String> jComboBoxModProgram;
    private javax.swing.JComboBox<String> jComboBoxSendChannel;
    private javax.swing.JComboBox<String> jComboBoxSendNoteHigh;
    private javax.swing.JComboBox<String> jComboBoxSendNoteLow;
    private javax.swing.JComboBox<String> jComboBoxSendPort;
    private javax.swing.JComboBox<String> jComboBoxWatchChannel;
    private javax.swing.JComboBox<String> jComboBoxWatchPort;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel1TargetGroup;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JList<String> jListGroupList;
    private javax.swing.JList<String> jListLayerList;
    private javax.swing.JPanel jPanel0;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelGroup;
    private javax.swing.JPanel jPanelLayer;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JScrollPane jScrollPane6;
    private javax.swing.JSpinner jSpinnerRotatePoly;
    private javax.swing.JSpinner jSpinnerSendAdjustExpression;
    private javax.swing.JSpinner jSpinnerSendAdjustPan;
    private javax.swing.JSpinner jSpinnerSendAdjustTranspose;
    private javax.swing.JSpinner jSpinnerSendAdjustVelocity;
    private javax.swing.JSpinner jSpinnerSendBankLSB;
    private javax.swing.JSpinner jSpinnerSendBankMSB;
    private javax.swing.JSpinner jSpinnerSendProgram;
    private javax.swing.JSpinner jSpinnerWatchBankLSB;
    private javax.swing.JSpinner jSpinnerWatchBankMSB;
    private javax.swing.JSpinner jSpinnerWatchProgram;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    private javax.swing.JTable jTable3;
    private javax.swing.JTextField jTextFieldGroupName;
    private javax.swing.JTextField jTextFieldLayerName;
    // End of variables declaration//GEN-END:variables

    public void listUpGroups() {
        MXWrapList<MX40Group> listModel = new MXWrapList();
        for (int i = 0; i < _process._groupList.size(); ++ i) {
            MX40Group g = _process._groupList.get(i);
            listModel.addNameAndValue(g._title, g);
        }
        _groupList = listModel;
        jListGroupList.setModel(_groupList);
        repaint();
        listupLayers(_editingGroup);
    }
    
    public boolean startEditGroup(MX40Group group) {
        MX40Group promptGroup = new MX40Group(_process);
        readGroupFromUI(promptGroup);
        if (underConstruction) {
            //ignore np
        }else if (_editingGroup == null) {
            //discard np
        }else if (promptGroup.equals(_editingGroup)) {
            //discard np
        }else {
            int ret = JOptionPane.showConfirmDialog(this, "Do you want to Save changed?", "We detected changes", JOptionPane.YES_NO_OPTION);
            if (ret == JOptionPane.YES_OPTION) {
                readGroupFromUI(_editingGroup);
            }
        }

        if (group != null) {
            jTextFieldGroupName.setText(group._title);
            jCheckBoxPort.setSelected(group._isWatchPort);
            jCheckBoxChannel.setSelected(group._isWatchChannel);
            jCheckBoxBank.setSelected(group._isWatchBank);
            jCheckBoxProgram.setSelected(group._isWatchProgram);
            jCheckBoxRotateLayer.setSelected(group._rotateLayer);
            jSpinnerRotatePoly.setValue(group._rotatePoly);
            jComboBoxWatchPort.setSelectedIndex(_watchPort.indexOfValue(group._watchingPort));
            jComboBoxWatchChannel.setSelectedIndex(_watchChannel.indexOfValue(group._watchingChannel));
            jSpinnerWatchProgram.setValue(group._watchingProgram);
            jSpinnerWatchBankMSB.setValue(group._watchingBankMSB);
            jSpinnerWatchBankLSB.setValue(group._watchingBankLSB);
            jPanelGroup.setBorder(javax.swing.BorderFactory.createTitledBorder("Editing Group [" + group._title + "]"));
       }else {
            jPanelGroup.setBorder(javax.swing.BorderFactory.createTitledBorder("New Group ?"));
        }
 
        _editingGroup = group;
        _editingLayer = null;
        listupLayers(group);

        MX40Layer ly;
        if (_layerList != null && _layerList.size() > 0) {
            ly = _layerList.get(0).value;
        }else {
            ly = new MX40Layer(_process, group);
        }
        startEditLayer(ly, group);
        
        enableUIs();

        repaint();

        return true;
    }

    public void listupLayers(MX40Group parent) {
        if (jLabel1TargetGroup != null) {
            if (parent != null) {
                jLabel1TargetGroup.setText(parent._title);
                jButtonNewLayer.setEnabled(true);
            }else {
                jLabel1TargetGroup.setText("none");
                jButtonNewLayer.setEnabled(false);
            }
        }else {
            jButtonNewLayer.setEnabled(false);
        }
        MXWrapList<MX40Layer> listModel = new MXWrapList();
        if (parent != null) {
            for (int i = 0; i < parent._listLayer.size(); ++ i) {
                MX40Layer l = parent._listLayer.get(i);
                listModel.addNameAndValue(l._title, l);
            }
        }
        _layerList = listModel;
        jListLayerList.setModel(listModel);
        enableUIs();
        repaint();
    }

    public boolean startEditLayer(MX40Layer layer, MX40Group parentGroup) {
        if (layer != _editingLayer) {
            MX40Layer promptLayer = new MX40Layer(_process, parentGroup);
            readLayerFromUI(promptLayer);
            if (underConstruction) {
                //ignore np
            }else if (_editingLayer == null) {
                //discard np
            }else if (promptLayer.equals(_editingLayer)) {
                //discard np
            }else {
                int ret = JOptionPane.showConfirmDialog(this, "Do you want to Save changed?", "We detected changes", JOptionPane.YES_NO_OPTION);
                if (ret == JOptionPane.YES_OPTION) {
                    readLayerFromUI(_editingLayer);
                }
            }
        }
        
        if (layer != null) {
            jTextFieldLayerName.setText(layer._title);
            
            _modPort.setComboBox(jComboBoxModPort, layer._modPort);
            _modChannel.setComboBox(jComboBoxModChannel, layer._modChannel);
            _modBank.setComboBox(jComboBoxModBank, layer._modBank);
            _modProgram.setComboBox(jComboBoxModProgram, layer._modProgram);

            _changePort.setComboBox(jComboBoxSendPort, layer._fixedPort);
            _changeChannel.setComboBox(jComboBoxSendChannel, layer._fixedPort);
            jSpinnerSendProgram.setValue(layer._fixedProgram);
            jSpinnerSendBankMSB.setValue(layer._fixedBankMSB);
            jSpinnerSendBankLSB.setValue(layer._fixedBankLSB);

            jSpinnerSendAdjustPan.setValue(layer._adjustPan);
            jSpinnerSendAdjustTranspose.setValue(layer._adjustTranspose);
            jSpinnerSendAdjustVelocity.setValue(layer._adjustVelocity);
            jSpinnerSendAdjustExpression.setValue(layer._adjustExpression);
            jPanelLayer.setBorder(javax.swing.BorderFactory.createTitledBorder("Editing Layer [" + layer._title + "]"));
        }else if (_editingGroup != null) {
            jPanelLayer.setBorder(javax.swing.BorderFactory.createTitledBorder("New Layer ?"));
        }else {
            jPanelLayer.setBorder(javax.swing.BorderFactory.createTitledBorder("Select Group before edit Layer"));
           
        }

        _editingLayer = layer;
        enableUIs();
        repaint();
        return true;
    }

    public void readGroupFromUI(MX40Group group) {
        group._title = jTextFieldGroupName.getText();

        group._isWatchPort = jCheckBoxPort.isSelected();
        group._isWatchChannel = jCheckBoxChannel.isSelected();
        group._isWatchBank = jCheckBoxBank.isSelected();
        group._isWatchProgram = jCheckBoxProgram.isSelected();
        group._rotateLayer = jCheckBoxRotateLayer.isSelected();
        group._rotatePoly = (int)jSpinnerRotatePoly.getValue();
        
        group._watchingPort = (int)((MXWrap)jComboBoxWatchPort.getSelectedItem()).value;
        group._watchingChannel = (int)((MXWrap)jComboBoxWatchChannel.getSelectedItem()).value;
        group._watchingProgram = (int)jSpinnerWatchProgram.getValue();
        group._watchingBankMSB = (int)jSpinnerWatchBankMSB.getValue();
        group._watchingBankLSB = (int)jSpinnerWatchBankLSB.getValue();
    }

    public void readLayerFromUI(MX40Layer layer) {
        layer._title = jTextFieldLayerName.getText();

        layer._modPort = _modPort.readComboBox(jComboBoxSendPort);
        layer._modChannel = _modChannel.readComboBox(jComboBoxModChannel);
        layer._modBank = _modBank.readComboBox(jComboBoxModBank);
        layer._modProgram = _modProgram.readComboBox(jComboBoxModProgram);
        
        layer._fixedPort = _changePort.readComboBox(jComboBoxSendPort);
        layer._fixedChannel = _changeChannel.readComboBox(jComboBoxSendChannel);
        layer._fixedBankMSB = (int)jSpinnerSendBankMSB.getValue();
        layer._fixedBankLSB = (int)jSpinnerSendBankLSB.getValue();
        layer._fixedProgram = (int)jSpinnerSendProgram.getValue();
        layer._adjustPan = (Integer)jSpinnerSendAdjustPan.getValue();
        layer._adjustTranspose = (Integer)jSpinnerSendAdjustTranspose.getValue();
        layer._adjustVelocity = (Integer)jSpinnerSendAdjustVelocity.getValue();
        layer._adjustExpression = (Integer)jSpinnerSendAdjustExpression.getValue();
    }
    
    public int castNull(Integer x) {
        if (x == null) {
            return 0;
        }
        return x;
    }
}
