/*
 * Copyright (C) 2022 user0001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx30controller.ui;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.synthtarou.midimixer.libs.MXUtil;
import jp.synthtarou.midimixer.libs.MXWrap;
import jp.synthtarou.midimixer.libs.MXWrapList;
import jp.synthtarou.midimixer.libs.domino.DTextMessage;
import jp.synthtarou.midimixer.libs.domino.DTextPicker;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMidi;
import jp.synthtarou.midimixer.libs.midi.MXMidiUI;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXUIValueConfig extends javax.swing.JPanel {
    int _channelAfter;
    String _nameAfter;
    String _textAfter;
    int _gateAfter;
    boolean _okOption = false;

    String _textBefore;
    
    MXWrapList<Integer> _channelModel;
    MXWrapList<Integer> _ccGateModel;
    MXWrapList<Integer> _keyGateModel;
    MXWrapList<Integer> _normalGateModel;
    /**
     * Creates new form MXUIValueEditPanel
     */
    public MXUIValueConfig(MXUIValue status) {
        initComponents();
        MXMessage message = status.toMXMessage();
        
        String textBefore;
        try {
            textBefore = MXMessageFactory.toDText(message);
            MXMessage message2 = MXMessageFactory.fromDtext(textBefore);
            message2.setPort(message.getPort());
            message2.setChannel(message.getChannel());
            message2.setGate(message.getGate());
            message2.setValue(message.getValue());
            message = message2;
        }catch(Exception e) {
            textBefore = "";
            e.printStackTrace();
        }
        setPreferredSize(new Dimension(400, 200));
        _textBefore = textBefore;
        jLabelBefore.setText(textBefore);
        jTextFieldAfter.setText(textBefore);

        _channelModel = MXMidiUI.createChannel(false);
        _ccGateModel = MXMidiUI.createControlChange();
        _keyGateModel = MXMidiUI.createNoteNo();
        _normalGateModel = new MXWrapList<Integer>();
        for(int i = 0; i < 128; ++ i) {
            _normalGateModel.addNameAndValue(String.valueOf(i) , i);
        }

        setupCodeName(message.getChannel(), textBefore, message.getGate());
        _nameAfter = status._name;
        jTextFieldControllerName.setText(_nameAfter);
        
        jTextFieldAfter.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                setupCodeName(_channelAfter, jTextFieldAfter.getText(), _gateAfter);
            }
            public void insertUpdate(DocumentEvent e) {} 
            public void removeUpdate(DocumentEvent e) {}
        });
    }
 
    public void setupCodeName(int channel, String text, int gate) {
        _textAfter = text;
        int command = -1;
    
        try {
            MXMessage test = MXMessageFactory.fromDtext(text);
            if (test.isMessageTypeChannel()) {
                test.setPort(0);
                test.setChannel(channel);
                test.setGate(gate);
                test.setValue(0);
                command = test.getCommand();
                jTextFieldAfter.setText(MXMessageFactory.toDText(test));
            }else {
                jTextFieldAfter.setText(text);
            }
        }catch(Exception e) {
            e.printStackTrace();
            jTextFieldAfter.setText(text);
        }

        _channelAfter = channel;
        jComboBoxChannel.setModel(_channelModel);
        _channelModel.setComboBox(jComboBoxChannel, _channelAfter);
        
        _gateAfter = gate;
        
        if (command == MXMidi.COMMAND_CHANNELPRESSURE
          ||command == MXMidi.COMMAND_NOTEON
          ||command == MXMidi.COMMAND_NOTEOFF) {
            jComboBoxGate.setModel(_keyGateModel);
            jComboBoxGate.setSelectedIndex(gate);
        }else if (command == MXMidi.COMMAND_CONTROLCHANGE) {
            jComboBoxGate.setModel(_ccGateModel);
            jComboBoxGate.setSelectedIndex(gate);
        }else {
            jComboBoxGate.setModel(_normalGateModel);
            jComboBoxGate.setSelectedIndex(gate);
        }
         jLabelCodeName.setText("Ch [" + (_channelAfter + 1) + "] Cmd [" + MXMidiUI.nameOfChannelMessage(command) + "]");
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jLabelBefore = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldAfter = new javax.swing.JTextField();
        jButtonFromBefore = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jButtonFromList = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jComboBoxGate = new javax.swing.JComboBox<>();
        jLabelCodeName = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxChannel = new javax.swing.JComboBox<>();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldControllerName = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jTextFieldNote = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Before");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jLabel1, gridBagConstraints);

        jLabelBefore.setText("----");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jLabelBefore, gridBagConstraints);

        jLabel3.setText("Editing(After)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jLabel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jTextFieldAfter, gridBagConstraints);

        jButtonFromBefore.setText("From Before");
        jButtonFromBefore.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFromBeforeActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jButtonFromBefore, gridBagConstraints);

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jButtonOK, gridBagConstraints);

        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jButtonCancel, gridBagConstraints);

        jButtonFromList.setText("From List");
        jButtonFromList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFromListActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        add(jButtonFromList, gridBagConstraints);

        jLabel5.setText("Gate");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel5, gridBagConstraints);

        jLabel6.setText("It is");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel6, gridBagConstraints);

        jComboBoxGate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxGateActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jComboBoxGate, gridBagConstraints);

        jLabelCodeName.setText("???");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jLabelCodeName, gridBagConstraints);

        jLabel4.setText("Channel");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel4, gridBagConstraints);

        jComboBoxChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jComboBoxChannel, gridBagConstraints);

        jLabel2.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel2, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jTextFieldControllerName, gridBagConstraints);

        jLabel7.setText("Note");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel7, gridBagConstraints);

        jTextFieldNote.setText("Note");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jTextFieldNote, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonFromBeforeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFromBeforeActionPerformed
        // TODO add your handling code here:
        jTextFieldAfter.setText(_textBefore);
    }//GEN-LAST:event_jButtonFromBeforeActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        // TODO add your handling code here:[
        if (_ccGateModel == jComboBoxGate.getModel()) {
            _gateAfter = _ccGateModel.readComboBox(jComboBoxGate);
        }else if (_keyGateModel == jComboBoxGate.getModel()) {
            _gateAfter = _keyGateModel.readComboBox(jComboBoxGate);
        }else {
            _gateAfter = this._normalGateModel.readComboBox(jComboBoxGate);
        }
        _nameAfter = jTextFieldControllerName.getText();
        _channelAfter = _channelModel.readComboBox(jComboBoxChannel);
        _textAfter = this.jTextFieldAfter.getText();
        try {
            int port = 0;
            if (_textAfter.length() > 0) {
                MXMessage test = MXMessageFactory.fromDtext(_textAfter);
                MXMessageFactory.toJavaMessage(test);
            }
        }catch(Throwable e){ 
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid Message", JOptionPane.ERROR_MESSAGE);
            return;
        }
        _okOption = true;
        MXUtil.closeDialog(this);
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        // TODO add your handling code here:
        _textAfter = _textBefore;
        _okOption = false;
        MXUtil.closeDialog(this);
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonFromListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFromListActionPerformed
        // TODO add your handling code here:
        DTextPicker picker = new DTextPicker();
        MXUtil.showAsDialog(this, picker, "Picker");
        DTextMessage x = picker.getTextReturn();
        if (x != null) {
            System.out.println("enter " + x.getDataText());
            try {
                MXMessage msg = MXMessageFactory.fromDtext(x.getDataText());
                if (msg.isMessageTypeChannel() && msg.getCommand() == MXMidi.COMMAND_CONTROLCHANGE) {
                    msg.setGate(msg.getData1FromBytes());
                }
                setupCodeName(msg.getChannel(), x.getDataText(), msg.getGate());
                jTextFieldNote.setText(x.getMemoText());
                jTextFieldControllerName.setText(msg.toShortString());
            }catch(Throwable e) {
                e.printStackTrace();
            }
        }else {
            System.out.println("cancel");
        }
    }//GEN-LAST:event_jButtonFromListActionPerformed

    private void jComboBoxGateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxGateActionPerformed
        Object sel = jComboBoxGate.getModel().getSelectedItem();
        MXWrap<Integer> wrap = (MXWrap<Integer>)sel;
        if (_gateAfter != wrap.value) {
            setupCodeName(_channelAfter, _textAfter, wrap.value);
        }
    }//GEN-LAST:event_jComboBoxGateActionPerformed

    private void jComboBoxChannelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxChannelActionPerformed
        Object sel2 = jComboBoxChannel.getModel().getSelectedItem();
        MXWrap<Integer> wrap2 = (MXWrap<Integer>)sel2;
        if (_channelAfter != wrap2.value) {
            setupCodeName(wrap2.value, _textAfter, _gateAfter);
        }
    }//GEN-LAST:event_jComboBoxChannelActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonFromBefore;
    private javax.swing.JButton jButtonFromList;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox<String> jComboBoxChannel;
    private javax.swing.JComboBox<String> jComboBoxGate;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabelBefore;
    private javax.swing.JLabel jLabelCodeName;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextField jTextFieldAfter;
    private javax.swing.JTextField jTextFieldControllerName;
    private javax.swing.JTextField jTextFieldNote;
    // End of variables declaration//GEN-END:variables
}
