/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer.mx30controller;

import jp.synthtarou.midimixer.mx30controller.ui.MGDrum;
import jp.synthtarou.midimixer.mx30controller.ui.MGCircle;
import jp.synthtarou.midimixer.mx30controller.ui.MGSlider;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.MXStatic;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.mx30controller.ui.MXUIValue;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MX30Process extends MXReceiver {
    private MX30View _rootView;
    private MX32PageProcess[] _pageProcess;
    public boolean _editingControl;

    public MX30Process() {
        _rootView = new MX30View(this);
        _pageProcess = new MX32PageProcess[MXStatic.TOTAL_PORT_COUNT];

        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PageProcess proc = new MX32PageProcess(this, port);
            _pageProcess[port] = proc;
            _rootView.addPage(port, proc);
            proc.setNextReceiver(new MXReceiver() {
                public String getReceiverName() {
                    return null;
                }
                public JComponent getReceiverView() {
                    return null;
                }
                public void processMXMessage(MXMessage message) {
                    //setNextReceiver(MX30Process.this.getNextReceiver());
                    //if (usingThis() == false) { sendToNext(message); return; }
                    MX30Process.this.sendToNext(message);
                }
           });
        }
        installDefaultColor();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
                    _pageProcess[port].readSettings();
                }
            }
        });
    }

    public MX32PageProcess getPage(int i) {
        return _pageProcess[i];
    }

    @Override
    public void processMXMessage(MXMessage message) {
        int port = message.getPort();
        _pageProcess[port].processMXMessage(message);
    }

    @Override
    public String getReceiverName() {
        return "Kontrolls";
    }

    @Override
    public JComponent getReceiverView() {
        return _rootView;
    }
    
    int focus_port, focus_type = -1, focus_row, focus_column;
    
    Color colorBack = null;
    Color colorEdit =  null;
    Color colorFocus = null;

/*
    Border labelBack = null;
    Border labelEdit =  null;
    Border labelFocus = null;
*/
    
    public void installDefaultColor() {
        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PageData data = getPage(port)._data;
            for (int row = 0; row < MXStatic.SLIDER_ROW_COUNT; ++ row) {
                for (int column = 0; column < MXStatic.SLIDER_COLUMN_COUNT; ++ column) {
                    MGSlider c = data.getSlider(row, column);
                    c.setDefaultBackground();
                }
            }
        }
        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PageData data = getPage(port)._data;
            for (int row = 0; row < MXStatic.CIRCLE_ROW_COUNT; ++ row) {
                for (int column = 0; column < MXStatic.SLIDER_COLUMN_COUNT; ++ column) {
                    MGCircle c = data.getCircle(row, column);
                    c.setDefaultBackground();
                }
            }
        }
        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PageData data = getPage(port)._data;
            for (int row = 0; row < MXStatic.DRUM_ROW_COUNT; ++ row) {
                for (int column = 0; column < MXStatic.SLIDER_COLUMN_COUNT; ++ column) {
                    MGDrum c = data.getDrum(row, column);
                    c.setDefaultBackground();
                }
            }
        }
        /*
        if (labelBack == null) {
            labelBack = BorderFactory.createLineBorder(new JLabel().getBackground(), 2);
            labelEdit = BorderFactory.createLineBorder(Color.red, 2);
            labelFocus = BorderFactory.createLineBorder(Color.orange, 2);
        }

        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PortData data = getPage(port)._data;
            for (int row = 0; row < MXStatic.SLIDER_ROW_COUNT; ++ row) {
                for (int column = 0; column < MXStatic.SLIDER_COLUMN_COUNT; ++ column) {
                    MGSlider c = data.getSlider(row, column);
                    c.setBorder(labelBack);
                }
            }
        }
        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PortData data = getPage(port)._data;
            for (int row = 0; row < MXStatic.CIRCLE_ROW_COUNT; ++ row) {
                for (int column = 0; column < MXStatic.SLIDER_COLUMN_COUNT; ++ column) {
                    MGCircle c = data.getCircle(row, column);
                    c.setBorder(labelBack);
                }
            }
        }
        for (int port = 0; port < MXStatic.TOTAL_PORT_COUNT; ++ port) {
            MX32PortData data = getPage(port)._data;
            for (int row = 0; row < MXStatic.DRUM_ROW_COUNT; ++ row) {
                for (int column = 0; column < MXStatic.SLIDER_COLUMN_COUNT; ++ column) {
                    MGDrum c = data.getDrum(row, column);
                    c.setBorder(labelBack);
                }
            }
        }*/
    }
    
    public void updateFocusInformation(int type, int port, int row,int column)
    {
        String value = "(NONE)";
        
        try {
            if (colorBack == null) {
                colorBack = new JLabel().getBackground();
                //labelBack = BorderFactory.createLineBorder(colorBack, 2);
                colorEdit = Color.orange;
                //labelEdit = BorderFactory.createLineBorder(colorEdit, 2);
                colorFocus = Color.cyan;
                //labelFocus = BorderFactory.createLineBorder(colorFocus, 2);
            }
       
            if (focus_type > 0) {
                MX32PageData focus_data = getPage(focus_port)._data;
                switch(focus_type) {
                    case MXUIValue.TYPE_SLIDER:
                        MGSlider slider = focus_data.getSlider(focus_row, focus_column);
                        //slider.setBorder(labelBack);
                        slider.setDefaultBackground();
                        break;
                    case MXUIValue.TYPE_CIRCLE:
                        MGCircle circle  = focus_data.getCircle(focus_row, focus_column);
                        //circle.setBorder(labelBack);
                        circle.setDefaultBackground();
                        break;
                    case MXUIValue.TYPE_DRUM:
                        MGDrum drum = focus_data.getDrum(focus_row, focus_column);
                        //drum.setBorder(labelBack);
                        drum.setDefaultBackground();
                        break;
                }
            }
            
            focus_type = type;
            focus_port = port;
            focus_row = row;
            focus_column = column;
            
            MX32PageData focus_data = getPage(port)._data;

            switch(type) {
                case MXUIValue.TYPE_SLIDER:
                    MGSlider slider = focus_data.getSlider(row, column);
                    value = focus_data.getSliderStatus(row, column).toString();
                    if (_editingControl) {
                        slider.setBackground(colorEdit);
                    }else {
                        slider.setBackground(colorFocus);
                    }
                    /*
                    if (_editingControl) {
                        slider.setBorder(labelEdit);
                    }else {
                        slider.setBorder(labelFocus);
                    }
                    */
                    break;
                case MXUIValue.TYPE_CIRCLE:
                    MGCircle circle  = focus_data.getCircle(focus_row, focus_column);
                    value = focus_data.getCircleStatus(row, column).toString();
                    if (_editingControl) {
                        circle.setBackground(colorEdit);
                    }else {
                        circle.setBackground(colorFocus);
                    }
                    /*
                    if (_editingControl) {
                        circle.setBorder(labelEdit);
                    }else {
                        circle.setBorder(labelFocus);
                    }
                    */
                    break;
                case MXUIValue.TYPE_DRUM:
                    MGDrum drum = focus_data.getDrum(focus_row, focus_column);
                    value = focus_data.getDrumStatus(row, column).toString();
                    if (_editingControl) {
                        drum.setBackground(colorEdit);
                    }else {
                        drum.setBackground(colorFocus);
                    }
                    /*
                    if (_editingControl) {
                        drum.setBorder(labelEdit);
                    }else {
                        drum.setBorder(labelFocus);
                    }
                    */
                    break;
                default:
                    value = "Unknown";
                    break;
            }
        }catch(Throwable e) {
            value = "ERR";
            e.printStackTrace();
        }
        
        _pageProcess[port]._view.setFocusString(value);
    }

    public void goNextFocus(final int port, final int keyCode) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            SwingUtilities.invokeLater(new Runnable() { public void run() { goNextFocus(port, keyCode); } });
            return;
        }

        int type = focus_type;
        int row = focus_row;
        int column = focus_column;
        
        if (type < 0) {
            type = 0;
            row = 0;
            column = 0;
        }else {
            switch(keyCode) {
                case 38: //UP
                    if (row > 0) {
                        row --;
                        break;
                    }
                    switch(-- type) {
                        case 0:
                            type = 1;
                            break;
                        case MXUIValue.TYPE_CIRCLE:
                            row = 3;
                            break;
                        case MXUIValue.TYPE_SLIDER:
                            row = 0;
                            break;
                        case MXUIValue.TYPE_DRUM:
                            row = 1;
                            break;
                    }
                    break;

                case 40: //DOWN
                    row ++;
                    switch(type) {
                        case MXUIValue.TYPE_CIRCLE:
                            if (row >= 4) {
                                row = 0;
                                type = MXUIValue.TYPE_SLIDER;
                            }
                            break;
                        case MXUIValue.TYPE_SLIDER:
                            if (row >= 1) {
                                row = 0;
                                type = MXUIValue.TYPE_DRUM;
                            }
                            break;
                        case MXUIValue.TYPE_DRUM:
                            if (row >= 2) {
                                row --;
                            }
                            break;
                    }
                    break;

                case 37: //LEFT
                    column --;
                    if (column < 0) {
                        column = 0;
                    }
                    break;

                case 39: //RIGHT
                    column ++;
                    if (column >= MXStatic.SLIDER_COLUMN_COUNT) {
                        column --;
                    }
                    break;

                case ' ':
                case '\b':
                case '\n':
                    MX32PageData focus_data = getPage(port)._data;

                    switch(type) {
                        case MXUIValue.TYPE_SLIDER:
                            MGSlider slider = focus_data.getSlider(focus_row, focus_column);
                            switch(keyCode) {
                                case ' ': slider.increment(); break;
                                case '\b': slider.decriment(); break;
                                case '\n': slider.editContoller(); break;
                            }
                            break;
                        case MXUIValue.TYPE_CIRCLE:
                            MGCircle circle = focus_data.getCircle(focus_row, focus_column);
                            switch(keyCode) {
                                case ' ': circle.increment(); break;
                                case '\b': circle.decriment(); break;
                                case '\n': circle.editContoller(); break;
                            }
                            break;
                        case MXUIValue.TYPE_DRUM:
                            MGDrum drum = focus_data.getDrum(focus_row, focus_column);
                            switch(keyCode) {
                                case ' ': drum.increment(); break;
                                case '\b': drum.decriment(); break;
                                case '\n': drum.editContoller(); break;
                            }
                            break;
                        default:
                            break;
                    }                
                    break;
            }
        }
        updateFocusInformation(type,  port, row,  column);
    }

    public void enterEditMode(boolean flag) {
        if (flag) {
            _editingControl = true;
            _rootView.lockAnothereTabs(true);
            MXMain.getMain().getMainWindow().setTitle(MXStatic.MX_EDITING);
        }else {
            _editingControl = false;
            _rootView.lockAnothereTabs(false);
            MXMain.getMain().getMainWindow().setTitle(MXStatic.MX_APPNAME_WITH_VERSION);
        }
    }
}
