/*
 * Copyright (C) 2022 SynthTAROU
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; thout even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.synthtarou.midimixer;

import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jp.synthtarou.midimixer.libs.MXDebugConsole;
import jp.synthtarou.midimixer.libs.MXUtil;

/**
 *
 * @author YOSHIDA Shintarou
 */
public class MXMainWindow extends javax.swing.JFrame {
    private static final MXDebugConsole _debug = new MXDebugConsole(MXMainWindow.class);

    MXMain _main;
    MXMidiLogger _logInput;
    MXMidiLogger _logOutput;

    /**
     * Constructor
     */
    public MXMainWindow(MXMain main) {
        if (SwingUtilities.isEventDispatchThread() == false) {
            _debug.println("SwingUtilities.isEventDispatchThread() == false");
        }
        _main = main;
        initComponents();
        jMenuBar1.add(Box.createHorizontalGlue());
        JMenu helpMenu = new JMenu("Help");
        jMenuBar1.add(helpMenu);
        JMenu aboutMenu = new JMenu("About");
        jMenuBar1.add(aboutMenu);
    }

    /**
     * ウィンドウの初期化
     */
    public void initLatebind(Collection<MXReceiver> viewList) {
        setTitle(MXStatic.MX_APPNAME_WITH_VERSION);
        setSize(new Dimension(1200, 700));

        MXUtil.centerWindow(this);
        setVisible(true);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        int count = 0;
        for (MXReceiver re : viewList) {
            jTabbedPane1.add(re.getReceiverName(), re.getReceiverView());
            JMenuItem menu = new JMenuItem(re.getReceiverName());
            menu.addActionListener(new WindowMenuItemListener(count));
            count ++;
            jMenuWindow.add(menu);
        }
        jTabbedPane1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                tabPanelStateChanged(evt);
            }
        });
    }
    
    class WindowMenuItemListener implements ActionListener {
        int _page;
        
        public WindowMenuItemListener(int page) {
            _page = page;
        }
        
        @Override
        public void actionPerformed(ActionEvent e) {
            jTabbedPane1.setSelectedIndex(_page);
        }
        
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuSaveNow = new javax.swing.JMenuItem();
        jMenuWindow = new javax.swing.JMenu();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.LINE_AXIS));
        getContentPane().add(jTabbedPane1);

        jMenuFile.setText("File");

        jMenuSaveNow.setText("Save All Parameters");
        jMenuSaveNow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveNowActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuSaveNow);

        jMenuBar1.add(jMenuFile);

        jMenuWindow.setText("Window");
        jMenuBar1.add(jMenuWindow);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuSaveNowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveNowActionPerformed
        _main.saveEverySettingToFile();
    }//GEN-LAST:event_jMenuSaveNowActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuSaveNow;
    private javax.swing.JMenu jMenuWindow;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

    /**
     * MainFrame内のTABを管理
     * @return MainFrame内のTAB
     */
    public JTabbedPane getTabbedPanel() {
        return jTabbedPane1;
    }

    private void tabPanelStateChanged(javax.swing.event.ChangeEvent evt) {                                          
        int x = jTabbedPane1.getSelectedIndex();
        if (x >= 0) {
            Component  view = jTabbedPane1.getComponentAt(x);
            view.requestFocusInWindow();
        }            
    }
}
