
import java.beans.*; // PropertyVetoException
import java.util.*; // Vector
import java.awt.*;
import java.awt.event.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.sound.midi.*;

/////////////////////////////////////////////////////////////////////
//
// z MIDI foCX
//
//   MidiDevice C^[tF[X͒ʏAMidiSystem 擾邪A
//   ƓC^[tF[X GUI ̃NXɎ΁A
//   z MIDI foCXƂ MIDI M𑗎MłNX
//   邱Ƃ\ɂȂB
//
/////////////////////////////////////////////////////////////////////
interface VirtualMidiDevice extends MidiDevice {
  MidiChannel[] getChannels();
  void sendMidiMessage( MidiMessage msg );
  void setReceiver(Receiver rx);
}
abstract class AbstractVirtualMidiDevice
  implements VirtualMidiDevice
{
  protected boolean is_open = false;
  protected long top_microsecond = -1;
  protected Info info;

  private int max_transmitters = -1;
  protected java.util.List<Transmitter>
    transmitters = new Vector<Transmitter>();
  protected MidiChannelMessageSender[]
    channels = new MidiChannelMessageSender[MIDISpec.MAX_CHANNELS];

  private int max_receivers = 1;
  protected java.util.List<Receiver>
    receivers = new Vector<Receiver>();
  //
  // Constuctor
  //
  protected AbstractVirtualMidiDevice() {
    for( int i=0; i<channels.length; i++ )
      channels[i] = new MidiChannelMessageSender(this,i);
  }
  protected void setMaxReceivers(int max_rx) {
    max_receivers = max_rx;
  }
  protected void setMaxTransmitters(int max_tx) {
    max_transmitters = max_tx;
  }
  //
  // MidiDevice interface
  //
  public void open() {
    is_open = true;
    top_microsecond = System.nanoTime()/1000;
  }
  public void close() {
    transmitters.clear();
    is_open = false;
  }
  public boolean isOpen() { return is_open; }
  public Info getDeviceInfo() { return info; }
  public long getMicrosecondPosition() {
    return (top_microsecond == -1 ? -1: System.nanoTime()/1000 - top_microsecond);
  }
  public int getMaxReceivers() { return max_receivers; }
  public Receiver getReceiver() {
    return receivers.isEmpty() ? null : receivers.get(0);
  }
  public java.util.List<Receiver> getReceivers() {
    return receivers;
  }
  public int getMaxTransmitters() { return max_transmitters; }
  public Transmitter getTransmitter()
    throws MidiUnavailableException
  {
    if( max_transmitters == 0 ) {
      throw new MidiUnavailableException();
    }
    Transmitter new_tx = new Transmitter() {
      private Receiver rx = null;
      public void close() { transmitters.remove(this); }
      public Receiver getReceiver() { return rx; }
      public void setReceiver(Receiver rx) { this.rx = rx; }
    };
    transmitters.add(new_tx);
    return new_tx;
  }
  public java.util.List<Transmitter> getTransmitters() {
    return transmitters;
  }
  //
  // VirtualMidiDevice interface
  //
  public MidiChannel[] getChannels() { return channels; }
  public void sendMidiMessage( MidiMessage msg ) {
    long time_stamp = getMicrosecondPosition();
    for( Transmitter tx : transmitters ) {
      Receiver rx = tx.getReceiver();
      if( rx != null ) rx.send( msg, time_stamp );
    }
  }
  public void setReceiver(Receiver rx) {
    if( max_receivers == 0 ) return;
    if( ! receivers.isEmpty() ) receivers.clear();
    receivers.add(rx);
  }
}
/////////////////////////////////////////////////////////////////////
//
// z MIDI foCX MIDI M
//
/////////////////////////////////////////////////////////////////////
class MidiChannelMessageSender implements MidiChannel
{
  private VirtualMidiDevice vmd;
  private int channel;

  public MidiChannelMessageSender(VirtualMidiDevice vmd, int channel) {
    this.vmd = vmd;
    this.channel = channel;
  }
  public void sendShortMessage(int command, int data1, int data2) {
    ShortMessage short_msg = new ShortMessage();
    try {
      short_msg.setMessage( command, channel, data1, data2 );
    } catch(InvalidMidiDataException e) {
      e.printStackTrace();
      return;
    }
    vmd.sendMidiMessage((MidiMessage)short_msg);
  }
  // MidiChannel interface
  //
  public void noteOff( int note_no ) { noteOff( note_no, 64 ); }
  public void noteOff( int note_no, int velocity ) {
    sendShortMessage( ShortMessage.NOTE_OFF, note_no, velocity );
  }
  public void noteOn( int note_no, int velocity ) {
    sendShortMessage( ShortMessage.NOTE_ON, note_no, velocity );
  }
  public void setPolyPressure(int note_no, int pressure) {
    sendShortMessage( ShortMessage.POLY_PRESSURE, note_no, pressure );
  }
  public int getPolyPressure(int noteNumber) { return 0x40; }
  public void controlChange(int controller, int value) {
    sendShortMessage( ShortMessage.CONTROL_CHANGE, controller, value );
  }
  public int getController(int controller) { return 0x40; } 
  public void programChange( int program ) {
    sendShortMessage( ShortMessage.PROGRAM_CHANGE, program, 0 );
  }
  public void programChange(int bank, int program) {
    controlChange( 0x00, ((bank>>7) & 0x7F) );
    controlChange( 0x20, (bank & 0x7F) );
    programChange( program );
  }
  public int getProgram() { return 0; }
  public void setChannelPressure(int pressure) {
    sendShortMessage( ShortMessage.CHANNEL_PRESSURE, pressure, 0 );
  }
  public int getChannelPressure() { return 0x40; }
  public void setPitchBend(int bend) {
    // NOTE: Pitch Bend data byte order is Little Endian
    sendShortMessage(
      ShortMessage.PITCH_BEND,
      (bend & 0x7F), ((bend>>7) & 0x7F)
    );
  }
  public int getPitchBend() { return MIDISpec.PITCH_BEND_NONE; }
  public void allSoundOff() { controlChange( 0x78, 0 ); }
  public void resetAllControllers() { controlChange( 0x79, 0 ); }
  public boolean localControl(boolean on) {
    controlChange( 0x7A, on ? 0x7F : 0x00 );
    return false;
  }
  public void allNotesOff() { controlChange( 0x7B, 0 ); }
  public void setOmni(boolean on) {
    controlChange( on ? 0x7D : 0x7C, 0 );
  }
  public boolean getOmni() { return false; }
  public void setMono(boolean on) {}
  public boolean getMono() { return false; }
  public void setMute(boolean mute) {}
  public boolean getMute() { return false; }
  public void setSolo(boolean soloState) {}
  public boolean getSolo() { return false; }
}
/////////////////////////////////////////////////////////////////////
//
// z MIDI foCX MIDI Mƃ`lԂ̊Ǘ
//
/////////////////////////////////////////////////////////////////////
abstract class AbstractMidiStatus
  extends Vector<AbstractMidiChannelStatus>
  implements Receiver
{
  private void resetStatus() { resetStatus(false); }
  private void resetStatus(boolean is_GS) {
    for( AbstractMidiChannelStatus mcs : this )
      mcs.resetAllValues(is_GS);
  }
  //
  // Receiver
  //
  public void close() { }
  public void send(MidiMessage message, long timeStamp) {
    if ( message instanceof ShortMessage ) {
      ShortMessage sm = (ShortMessage)message;
      switch ( sm.getCommand() ) {

      case ShortMessage.NOTE_ON:
        get(sm.getChannel()).noteOn( sm.getData1(), sm.getData2() );
        break;

      case ShortMessage.NOTE_OFF:
        get(sm.getChannel()).noteOff( sm.getData1(), sm.getData2() );
        break;

      case ShortMessage.CONTROL_CHANGE:
        get(sm.getChannel()).controlChange( sm.getData1(), sm.getData2() );
        break;
 
      case ShortMessage.PROGRAM_CHANGE:
        get(sm.getChannel()).programChange( sm.getData1() );
        break;

      case ShortMessage.PITCH_BEND:
        get(sm.getChannel()).setPitchBend(
          ( sm.getData1() & 0x7F ) + ( (sm.getData2() & 0x7F) << 7 )
        );
        break;

/* PressurenMꍇA̕Lɂ
      case ShortMessage.POLY_PRESSURE:
        get(sm.getChannel()).setPolyPressure( sm.getData1(), sm.getData2() );
        break;
      case ShortMessage.CHANNEL_PRESSURE:
        get(sm.getChannel()).setChannelPressure( sm.getData1() );
        break;
*/
      }
    }
    else if ( message instanceof SysexMessage ) {
      SysexMessage sxm = (SysexMessage)message;
      switch ( sxm.getStatus() ) {

      case SysexMessage.SYSTEM_EXCLUSIVE:
        byte data[] = sxm.getData();
        switch( data[0] ) {
        case 0x7E: // Non-Realtime Universal System Exclusive Message
          if( data[2] == 0x09 ) { // General MIDI (GM)
            if( data[3] == 0x01 ) { // GM System ON
              resetStatus();
            }
            else if( data[3] == 0x02 ) { // GM System OFF
              resetStatus();
            }
          }
          break;
        case 0x41: // Roland
          if( data[2]==0x42 && data[3]==0x12 ) { // GS DT1
            if( data[4]==0x40 && data[5]==0x00 && data[6]==0x7F &&
                data[7]==0x00 && data[8]==0x41
            ) {
              resetStatus(true);
            }
            else if( data[4]==0x40 && (data[5] & 0xF0)==0x10 && data[6]==0x15 ) {
              // Drum Map 1 or 2, otherwise Normal Part
              boolean is_rhythm_part = ( data[7]==1 || data[7]==2 );
              int ch = (data[5] & 0x0F);
              if( ch == 0 ) ch = 9; else if( ch <= 9 ) ch--;
              get(ch).setRhythmPart(is_rhythm_part);
            }
            else if( data[4]==0x00 && data[5]==0x00 && data[6]==0x7F ) {
              if( data[7]==0x00 && data[8]==0x01 ) {
                // GM System Mode Set (1)
                resetStatus(true);
              }
              if( data[7]==0x01 && data[8]==0x00 ) {
                // GM System Mode Set (2)
                resetStatus(true);
              }
            }
          }
          break;
        case 0x43: // Yamaha
          if( data[2] == 0x4C
            && data[3]==0 && data[4]==0 && data[5]==0x7E
            && data[6]==0
          ) {
            // XG System ON
            resetStatus();
          }
          break;
        }
        break;
      }
    }
  }
}
abstract class AbstractMidiChannelStatus
  implements MidiChannel
{
  protected int channel;
  protected int program = 0;
  protected int pitch_bend = MIDISpec.PITCH_BEND_NONE;
  protected int controller_values[] = new int[0x80];
  protected boolean is_rhythm_part = false;

  protected static final int DATA_NONE = 0;
  protected static final int DATA_FOR_RPN = 1;
  protected final int DATA_FOR_NRPN = 2;
  protected int data_for = DATA_NONE;

  public AbstractMidiChannelStatus(int channel) {
    this.channel = channel;
    resetAllValues(true);
  }
  public int getChannel() { return channel; }
  public boolean isRhythmPart() { return is_rhythm_part; }
  public void setRhythmPart(boolean is_rhythm_part) {
    this.is_rhythm_part = is_rhythm_part;
  }
  public void resetRhythmPart() {
    is_rhythm_part = (channel == 9);
  }
  public void resetAllValues() { resetAllValues(false); }
  public void resetAllValues(boolean is_GS) {
    for( int i=0; i<controller_values.length; i++ )
      controller_values[i] = 0;
    if( is_GS ) resetRhythmPart();
    resetAllControllers();
    controller_values[10] = 0x40; // Set pan to center
  }
  public void fireRpnChanged() {}
  protected void changeRPNData( int data_diff ) {
    int data_msb = controller_values[0x06];
    int data_lsb = controller_values[0x26];
    if( data_diff != 0 ) {
      // Data increment or decrement
      data_lsb += data_diff;
      if( data_lsb >= 100 ) {
        data_lsb = 0;
        controller_values[0x26] = ++data_msb;
      }
      else if( data_lsb < 0 ) {
        data_lsb = 0;
        controller_values[0x26] = --data_msb;
      }
      controller_values[0x06] = data_lsb;
    }
    fireRpnChanged();
  }
  //
  // MidiChannel interface
  //
  public void noteOff( int note_no ) {}
  public void noteOff( int note_no, int velocity ) {}
  public void noteOn( int note_no, int velocity ) {}
  public int getController(int controller) {
    return controller_values[controller];
  } 
  public void programChange( int program ) {
    this.program = program;
  }
  public void programChange(int bank, int program) {
    controlChange( 0x00, ((bank>>7) & 0x7F) );
    controlChange( 0x20, (bank & 0x7F) );
    programChange( program );
  }
  public int getProgram() { return program; }
  public void setPitchBend(int bend) { pitch_bend = bend; }
  public int getPitchBend() { return pitch_bend; }
  public void setPolyPressure(int note_no, int pressure) {}
  public int getPolyPressure(int noteNumber) { return 0x40; }
  public void setChannelPressure(int pressure) {}
  public int getChannelPressure() { return 0x40; }
  public void allSoundOff() {}
  public void allNotesOff() {}
  public void resetAllControllers() {
    //
    // See also:
    //   Recommended Practice (RP-015)
    //   Response to Reset All Controllers
    //   http://www.midi.org/techspecs/rp15.php
    //
    // modulation
    controller_values[0] = 0;
    //
    // pedals
    for(int i=64; i<=67; i++) controller_values[i] = 0;
    //
    // Set pitch bend to center
    pitch_bend = 8192;
    //
    // Set NRPN / RPN to null value
    for(int i=98; i<=101; i++) controller_values[i] = 127;
  }
  public boolean localControl(boolean on) {
    controlChange( 0x7A, on ? 0x7F : 0x00 );
    return false;
  }
  public void setOmni(boolean on) {
    controlChange( on ? 0x7D : 0x7C, 0 );
  }
  public boolean getOmni() { return false; }
  public void setMono(boolean on) {}
  public boolean getMono() { return false; }
  public void setMute(boolean mute) {}
  public boolean getMute() { return false; }
  public void setSolo(boolean soloState) {}
  public boolean getSolo() { return false; }
  public void controlChange(int controller, int value) {
    controller_values[controller] = (value &= 0x7F);
    switch( controller ) {

    case 0x78: // All Sound Off
      allSoundOff();
      break;

    case 0x7B: // All Notes Off
      allNotesOff();
      break;

    case 0x79: // Reset All Controllers
      resetAllControllers();
      break;

    case 0x06: // Data Entry (MSB)
    case 0x26: // Data Entry (LSB)
      changeRPNData(0);
      break;

    case 0x60: // Data Increment
      changeRPNData(1);
      break;

    case 0x61: // Data Decrement
      changeRPNData(-1);
      break;

    // Non-Registered Parameter Number
    case 0x62: // NRPN (LSB)
    case 0x63: // NRPN (MSB)
      data_for = DATA_FOR_NRPN;
      // fireRpnChanged();
      break;

    // Registered Parameter Number
    case 0x64: // RPN (LSB)
    case 0x65: // RPN (MSB)
      data_for = DATA_FOR_RPN;
      fireRpnChanged();
      break;
    }
  }
}

////////////////////////////////////////////////////////////////////////
//
// Transmitter/Receiver ̃Xgiviewj
//
class MidiConnecterList extends JList
  implements Transferable, DragGestureListener, DropTargetListener
{
  DataFlavor tx_flavor = new DataFlavor( Transmitter.class, "Transmitter" );
  public MidiConnecterList(MidiConnecterListModel model) {
    super(model);
    setCellRenderer(new MidiTxRxListCellRenderer());
    setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    if( model.hasTx() ) {
      DragSource drag_source = new DragSource();
      DragGestureRecognizer dgr =
        drag_source.createDefaultDragGestureRecognizer(
          this, DnDConstants.ACTION_COPY_OR_MOVE, this
        );
    }
    if( model.hasRx() ) {
      DropTarget drop_target = new DropTarget(
        this, DnDConstants.ACTION_COPY_OR_MOVE, this
      );
    }
    setLayoutOrientation(JList.HORIZONTAL_WRAP);
    setVisibleRowCount(0);
  }
  // Transferable
  //
  public Object getTransferData(DataFlavor flavor) {
    return getModel().getElementAt(getSelectedIndex());
  }
  public DataFlavor[] getTransferDataFlavors() {
    return new DataFlavor[] {tx_flavor};
  }
  public boolean isDataFlavorSupported(DataFlavor flavor) {
    return flavor.equals(this.tx_flavor);
  }
  // DragGestureListener
  //
  public void dragGestureRecognized(DragGestureEvent dge) {
    if( (dge.getDragAction() | DnDConstants.ACTION_COPY_OR_MOVE) != 0 ) {
      //
      // MIDI Tx/Rx ݂foCXł
      // Tx ̃hbÔ݂󂯕tB
      //
      Object elem = getModel().getElementAt(
        locationToIndex(dge.getDragOrigin())
      );
      if( elem instanceof Transmitter )
        dge.startDrag(DragSource.DefaultMoveDrop, this, null);
    }
  }
  // DropTargetListener
  //
  public void dragEnter(DropTargetDragEvent dtde) {
    Transferable trans = dtde.getTransferable();
    DataFlavor[] flavor = trans.getTransferDataFlavors();
    if( trans.isDataFlavorSupported(flavor[0]) )
      dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
  }
  public void dragExit(DropTargetEvent dte) {}
  public void dragOver(DropTargetDragEvent dtde) {}
  public void dropActionChanged(DropTargetDragEvent dtde) {}
  public void drop(DropTargetDropEvent dtde) {
    dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
    try {
      if( (dtde.getDropAction() & DnDConstants.ACTION_COPY_OR_MOVE) != 0 ) {
        Transferable trans = dtde.getTransferable();
        DataFlavor[] flavor = trans.getTransferDataFlavors();
        Object trans_data = trans.getTransferData(flavor[0]);
        if( trans_data instanceof Transmitter ) {
          getModel().ConnectToReceiver((Transmitter)trans_data);
          dtde.dropComplete(true);
        }
        else dtde.dropComplete(false);
      }
      else dtde.dropComplete(false);
    }
    catch (Exception ex) {
      ex.printStackTrace();
      dtde.dropComplete(false);
    }
  }
  // Methods
  //
  public MidiConnecterListModel getModel() {
    return (MidiConnecterListModel)super.getModel();
  }
  public Transmitter getSelectedTransmitter() {
    Object obj = getSelectedValue();
    if( obj == null || ! (obj instanceof Transmitter) )
      return null;
    return (Transmitter)obj;
  }
}
class MidiTxRxListCellRenderer extends JLabel
  implements ListCellRenderer
{
  final static ButtonIcon midi_connector_icon
    = new ButtonIcon( ButtonIcon.MIDI_CONNECTOR_ICON );

  public Component getListCellRendererComponent(
    JList list, Object value, int index,
    boolean isSelected, boolean cellHasFocus)
  {
    if( value instanceof Transmitter ) setText("Tx");
    else if( value instanceof Receiver ) setText("Rx");
    else if( value != null ) setText(value.toString());
    setIcon(midi_connector_icon);
    if (isSelected) {
      setBackground(list.getSelectionBackground());
      setForeground(list.getSelectionForeground());
    } else {
      setBackground(list.getBackground());
      setForeground(list.getForeground());
    }
    setEnabled(list.isEnabled());
    setFont(list.getFont());
    setOpaque(true);
    return this;
  }
}

//////////////////////////////////////////////////////////////////
//
// P MIDI foCXɑ Transmitter/Receiver ̃Xgimodelj
//
class MidiConnecterListModel extends AbstractListModel {
  MidiDevice device;
  java.util.List<MidiConnecterListModel> device_models;
  UnicodeConverter unicode_conv = new UnicodeConverter();
  public MidiConnecterListModel(
    MidiDevice device,
    java.util.List<MidiConnecterListModel> device_models
  ) {
    this.device = device;
    this.device_models = device_models;
  }
  public String toString() {
    return unicode_conv.convertToUnicode(
      device.getDeviceInfo().toString()
    );    
  }
  public Object getElementAt(int index) {
    int i = 0;
    java.util.List<Receiver>
      receivers = device.getReceivers();
    for( Receiver rx : receivers )
      if( i++ == index ) return rx;
    java.util.List<Transmitter>
      transmitters = device.getTransmitters();
    for( Transmitter tx : transmitters )
      if( i++ == index ) return tx;
    return null;
  }
  public int getSize() {
    return
      device.getReceivers().size() +
      device.getTransmitters().size();
  }
  public int indexOf(Object obj) {
    int i = 0;
    java.util.List<Receiver>
      receivers = device.getReceivers();
    for( Receiver rx : receivers ) {
      if( rx == obj ) return i;
      i++;
    }
    java.util.List<Transmitter>
      transmitters = device.getTransmitters();
    for( Transmitter tx : transmitters ) {
      if( tx == obj ) return i;
      i++;
    }
    return -1;
  }
  public boolean hasTx() {
    return device.getMaxTransmitters() != 0;
  }
  public boolean hasRx() {
    return device.getMaxReceivers() != 0;
  }
  public void ConnectToReceiver( Transmitter tx ) {
    java.util.List<Receiver>
      receivers = device.getReceivers();
    if( receivers.size() == 0 ) return;
    tx.setReceiver(receivers.get(0));
    fireContentsChanged(this,0,getSize());
  }
  public Transmitter getUnconnectedTransmitter() {
    if( ! hasTx() ) return null;
    java.util.List<Transmitter>
      transmitters = device.getTransmitters();
    for( Transmitter tx : transmitters ) {
      if( tx.getReceiver() == null )
        return tx;
    }
    Transmitter tx;
    try {
      tx = device.getTransmitter();
    } catch( MidiUnavailableException e ) {
      e.printStackTrace();
      return null;
    }
    fireIntervalAdded(this,0,getSize());
    return tx;
  }
  public void closeTransmitter( Transmitter tx_to_close ) {
    java.util.List<Transmitter> txes = device.getTransmitters();
    boolean is_found = false;
    for( Transmitter tx : txes )
      if( tx == tx_to_close ) {
        is_found = true;
        break;
      }
    if( ! is_found ) return;
    tx_to_close.close();
    fireIntervalRemoved(this,0,getSize());
  }
  public void connectToReceiverOf(MidiConnecterListModel another_model) {
    if( ! hasTx() || another_model == null || ! another_model.hasRx() )
      return;
    java.util.List<Receiver> rxes = another_model.device.getReceivers();
    if( rxes.isEmpty() ) return;
    getUnconnectedTransmitter().setReceiver( rxes.get(0) );
  }
  public void openDevice()
    throws MidiUnavailableException
  {
    try {
      device.open();
    } catch( MidiUnavailableException e ) {
      throw e;
    }
    if( hasRx() && device.getReceivers().size() == 0 ) {
      try {
        device.getReceiver();
      } catch( MidiUnavailableException e ) { }
    }
  }
  public void closeDevice() {
    //
    // foCXOɁA̎Ă Receiver ݒ肳ꂽ
    // ׂĂ Transmitter B
    // ̎ Transmitter ́AfoCX
    // Iɕ̂ŉKvȂB
    //
    if( hasRx() ) {
      Receiver rx = device.getReceivers().get(0);
      for( MidiConnecterListModel m : device_models ) {
        if( m == this || ! m.hasTx() ) continue;
        for( int i=0; i<m.getSize(); i++ ) {
          Object obj = m.getElementAt(i);
          if( ! (obj instanceof Transmitter) ) continue;
          Transmitter tx = ((Transmitter)obj);
          if( tx.getReceiver() == rx ) m.closeTransmitter(tx);
        }
      }
    }
    device.close();
  }
  public void resetMicrosecondPosition() {
    if( ! hasTx() || device instanceof Sequencer )
      return;
    //
    // foCXOɐڑ̏ۑ
    //
    java.util.List<Transmitter> transmitters = device.getTransmitters();
    java.util.List<Receiver> peer_receivers = new Vector<Receiver>();
    for( Transmitter tx : transmitters ) {
      Receiver rx = tx.getReceiver();
      if( rx == null ) continue;
      peer_receivers.add(rx);
    }
    java.util.List<Transmitter> peer_transmitters = null;
    Receiver rx = null;
    if( hasRx() ) {
      rx = device.getReceivers().get(0);
      peer_transmitters = new Vector<Transmitter>();
      for( MidiConnecterListModel m : device_models ) {
        if( m == this || ! m.hasTx() ) continue;
        for( int i=0; i<m.getSize(); i++ ) {
          Object obj = m.getElementAt(i);
          if( ! (obj instanceof Transmitter) ) continue;
          Transmitter tx = ((Transmitter)obj);
          if( tx.getReceiver() == rx )
            peer_transmitters.add(tx);
        }
      }
    }
    // foCXUĂ܂JƂɂ
    // ^CX^vZbg
    device.close();
    try {
      device.open();
    } catch( MidiUnavailableException e ) {
      e.printStackTrace();
    }
    // ʂɐڑ
    for( Receiver peer_rx : peer_receivers ) {
      Transmitter tx = getUnconnectedTransmitter();
      if( tx == null ) continue;
      tx.setReceiver(peer_rx);
    }
    if( peer_transmitters != null ) {
      rx = device.getReceivers().get(0);
      for( Transmitter peer_tx : peer_transmitters ) {
        peer_tx.setReceiver(rx);
      }
    }
  }
}

class MidiDeviceFrame extends JInternalFrame {
  MidiConnecterList list;
  public MidiDeviceFrame( MidiConnecterListModel model ) {
    super( null, true, true, false, false );
    //
    // ^Cg̐ݒ
    if( model.hasTx() ) {
      if( model.hasRx() ) setTitle(""+model);
      else setTitle("[IN] "+model);
    }
    else {
      if( model.hasRx() ) setTitle("[OUT] "+model);
      else setTitle("[No IN/OUT] "+model);
    }
    list = new MidiConnecterList(model);
    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    addInternalFrameListener(
      new InternalFrameAdapter() {
        public void internalFrameOpened(InternalFrameEvent e) {
          MidiConnecterListModel m = list.getModel();
          if( m.device.isOpen() ) return;
          setVisible(false);
        }
        public void internalFrameClosing(InternalFrameEvent e) {
          MidiConnecterListModel m = list.getModel();
          m.closeDevice();
          if( m.device.isOpen() ) return;
          setVisible(false);
        }
      }
    );
    setLayout(
      new BoxLayout( getContentPane(), BoxLayout.Y_AXIS )
    );
    add( new JScrollPane(list) );
    if( model.hasTx() ) {
      Insets zero_insets = new Insets(0,0,0,0);
      JButton new_tx_button = new JButton("New Tx");
      new_tx_button.setMargin(zero_insets);
      new_tx_button.addActionListener(
        new ActionListener() {
          public void actionPerformed(ActionEvent event) {
            list.getModel().getUnconnectedTransmitter();
          }
        }
      );
      JButton close_tx_button = new JButton("Close Tx");
      close_tx_button.setMargin(zero_insets);
      close_tx_button.addActionListener(
        new ActionListener() {
          public void actionPerformed(ActionEvent event) {
            list.getModel().closeTransmitter(
              list.getSelectedTransmitter()
            );
          }
        }
      );
      JPanel button_panel = new JPanel();
      button_panel.add(new_tx_button);
      button_panel.add(close_tx_button);
      add(button_panel);
    }
  }
  public Rectangle getListCellBounds(int i) {
    Rectangle rect = list.getCellBounds(i,i);
    if( rect == null ) return null;
    rect.translate(
      getRootPane().getX() + getContentPane().getX(),
      getRootPane().getY() + getContentPane().getY()
    );
    return rect;
  }
}

/////////////////////////////////////////
//
// MIDI foCẌꗗ
//
class MidiDeviceGroup {
  private String name, description;
  public MidiDeviceGroup(String name, String description) {
    this.name = name;
    this.description = description;
  }
  public String toString() { return name; }
  public String getName() { return name; }
  public String getDescription() { return description; }
}
class MidiDeviceTreeModel implements TreeModel {
  java.util.List<MidiConnecterListModel> device_models;
  private static final MidiDeviceGroup
    root_node = new MidiDeviceGroup("MIDI devices",""),
    midi_in_node = new MidiDeviceGroup("IN","MIDI input devices (MIDI keyboard etc.)"),
    midi_out_node = new MidiDeviceGroup("OUT","MIDI output devices (MIDI synthesizer etc.)"),
    midi_in_out_node = new MidiDeviceGroup("IN/OUT","MIDI input/output devices (MIDI sequencer etc.)");
  private static final MidiDeviceGroup[] midi_in_path = {root_node,midi_in_node};
  private static final MidiDeviceGroup[] midi_out_path = {root_node,midi_out_node};
  private static final MidiDeviceGroup[] midi_in_out_path = {root_node,midi_in_out_node};
  private EventListenerList listenerList = new EventListenerList();
  public MidiDeviceTreeModel(
    java.util.List<MidiConnecterListModel> device_models
  ) {
    this.device_models = device_models;
  }
  // TreeModel
  //
  public Object getRoot() { return root_node; }
  public Object getChild(Object parent, int index) {
    if( parent == root_node ) {
      return
        index == 0 ? midi_out_node :
        index == 1 ? midi_in_node :
        index == 2 ? midi_in_out_node : null;
    }
    else if( parent == midi_in_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasTx() && !(m.hasRx()) && i++ == index )
          return m;
      return null;
    }
    else if( parent == midi_out_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasRx() && !(m.hasTx()) && i++ == index )
          return m;
      return null;
    }
    else if( parent == midi_in_out_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasRx() && m.hasTx() && i++ == index )
          return m;
      return null;
    }
    else return null;
  }
  public int getChildCount(Object parent) {
    if( parent == root_node ) {
      return 3;
    }
    else if( parent == midi_in_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasTx() && !(m.hasRx()) ) i++;
      return i;
    }
    else if( parent == midi_out_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasRx() && !(m.hasTx()) ) i++;
      return i;
    }
    else if( parent == midi_in_out_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasRx() && m.hasTx() ) i++;
      return i;
    }
    else return 0;
  }
  public int getIndexOfChild(Object parent, Object child) {
    if( parent == root_node ) {
      return
        child == midi_out_node ? 0 :
        child == midi_in_node ? 1 :
        child == midi_in_out_node ? 2 : -1;
    }
    else if( parent == midi_in_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasTx() && !(m.hasRx()) ) {
          if( m == child ) return i;
          i++;
        }
      return -1;
    }
    else if( parent == midi_out_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasRx() && !(m.hasTx()) ) {
          if( m == child ) return i;
          i++;
        }
      return -1;
    }
    else if( parent == midi_in_out_node ) {
      int i = 0;
      for( MidiConnecterListModel m : device_models )
        if( m.hasRx() && m.hasTx() ) {
          if( m == child ) return i;
          i++;
        }
      return -1;
    }
    else return -1;
  }
  public boolean isLeaf(Object node) {
    return ( node instanceof MidiConnecterListModel );
  }
  public void valueForPathChanged(TreePath path, Object newValue) {}
  public void addTreeModelListener(TreeModelListener listener) {
    listenerList.add(TreeModelListener.class, listener);
  }
  public void removeTreeModelListener(TreeModelListener listener) {
    listenerList.remove(TreeModelListener.class, listener);
  }
  // Methods
  //
  public void fireTreeNodesChanged(
    Object source, Object[] path, int[] child_indices, Object[] children
  ) {
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i]==TreeModelListener.class) {
        ((TreeModelListener)listeners[i+1]).treeNodesChanged(
          new TreeModelEvent(source,path,child_indices,children)
        );
      }
    }
  }
  public void fireDeviceStatusChanged(MidiConnecterListModel m) {
    fireTreeNodesChanged(
      this,
      (Object[])( m.hasRx() ? midi_out_path : midi_in_path ),
      new int[]{
        getIndexOfChild( m.hasRx() ? midi_out_node : midi_in_node, m )
      },
      new Object[]{m}
    );
  }
}

class MidiDeviceTree extends JTree
  implements Transferable, DragGestureListener
{
  DataFlavor flavor = new DataFlavor( TreeModel.class, "TreeModel" );
  public MidiDeviceTree( MidiDeviceTreeModel model ) {
    super(model);
    DragSource drag_source = new DragSource();
    DragGestureRecognizer dgr =
      drag_source.createDefaultDragGestureRecognizer(
        this, DnDConstants.ACTION_COPY_OR_MOVE, this
      );
  }
  // Transferable
  //
  public Object getTransferData(DataFlavor flavor) {
    return getLastSelectedPathComponent();
  }
  public DataFlavor[] getTransferDataFlavors() {
    return new DataFlavor[] {flavor};
  }
  public boolean isDataFlavorSupported(DataFlavor flavor) {
    return flavor.equals(this.flavor);
  }
  // DragGestureListener
  //
  public void dragGestureRecognized(DragGestureEvent e) {
    if( (e.getDragAction() | DnDConstants.ACTION_COPY_OR_MOVE) != 0 ) {
      e.startDrag(DragSource.DefaultMoveDrop, this, null);
    }
  }
  // Methods
  //
  public MidiDeviceTreeModel getModel() {
    return (MidiDeviceTreeModel)super.getModel();
  }
}

////////////////////////////////
//
// MIDI foCXǗ
//
class MidiDeviceManager extends Vector<MidiConnecterListModel> {
  private Sequencer sequencer = null;
  SpeedSliderModel speed_slider_model = null;
  SequencerTimeRangeModel time_range_model = null;
  MidiEditor editor_dialog = null;
  MidiConnecterListModel first_midi_out_model = null;
  public MidiDeviceManager( Vector<VirtualMidiDevice> vmds ) {
    MidiDevice.Info[] dev_infos = MidiSystem.getMidiDeviceInfo();
    MidiConnecterListModel
      gui_models[] = new MidiConnecterListModel[vmds.size()],
      sequencer_model = null,
      first_midi_in_model = null;
    for( int i=0; i<vmds.size(); i++ )
      gui_models[i] = addMidiDevice(vmds.get(i));

    try {
      sequencer = MidiSystem.getSequencer(false);
      sequencer_model = addMidiDevice(sequencer);
      speed_slider_model = new SpeedSliderModel(sequencer);
      time_range_model = new SequencerTimeRangeModel(this);
    } catch( MidiUnavailableException e ) {
      System.out.println(
        ChordHelperApplet.VersionInfo.NAME +
        " : MIDI sequencer unavailable"
      );
      e.printStackTrace();
    }
    for( MidiDevice.Info info : dev_infos ) {
      MidiDevice device;
      try {
        device = MidiSystem.getMidiDevice(info);
      } catch( MidiUnavailableException e ) {
        e.printStackTrace(); continue;
      }
      if( device instanceof Sequencer )  continue;
      if( device instanceof Synthesizer ) {
        try {
          addMidiDevice(MidiSystem.getSynthesizer());
        } catch( MidiUnavailableException e ) {
          System.out.println(
            ChordHelperApplet.VersionInfo.NAME +
            " : Java internal MIDI synthesizer unavailable"
          );
          e.printStackTrace();
        }
        continue;
      }
      MidiConnecterListModel m = addMidiDevice(device);
      if( m.hasRx() && first_midi_out_model == null )
        first_midi_out_model = m; 
      if( m.hasTx() && first_midi_in_model == null )
        first_midi_in_model = m; 
    }
    // foCXJ
    try {
      for( MidiConnecterListModel m : gui_models )
        m.openDevice();
      if( first_midi_in_model != null )
        first_midi_in_model.openDevice();
      if( sequencer_model != null )
        sequencer_model.openDevice();
      if( first_midi_out_model != null )
        first_midi_out_model.openDevice();
    } catch( MidiUnavailableException ex ) {
      ex.printStackTrace();
    }
    //
    // ڑ
    //
    for( MidiConnecterListModel mtx : gui_models ) {
      for( MidiConnecterListModel mrx : gui_models )
        mtx.connectToReceiverOf(mrx);
      mtx.connectToReceiverOf(sequencer_model);
      mtx.connectToReceiverOf(first_midi_out_model);
    }
    if( first_midi_in_model != null ) {
      for( MidiConnecterListModel m : gui_models )
        first_midi_in_model.connectToReceiverOf(m);
      first_midi_in_model.connectToReceiverOf(sequencer_model);
      first_midi_in_model.connectToReceiverOf(first_midi_out_model);
    }
    if( sequencer_model != null ) {
      for( MidiConnecterListModel m : gui_models )
        sequencer_model.connectToReceiverOf(m);
      sequencer_model.connectToReceiverOf(first_midi_out_model);
    }
  }
  private MidiConnecterListModel addMidiDevice( MidiDevice device ) {
    MidiConnecterListModel m = new MidiConnecterListModel(device,this);
    addElement(m);
    return m;
  }
  public void setMidiEditor( MidiEditor editor_dialog ) {
    editor_dialog.device_manager = this;
    MidiConnecterListModel mclm = addMidiDevice(
      (this.editor_dialog = editor_dialog).midi_device
    );
    try {
      mclm.openDevice();
    } catch( MidiUnavailableException ex ) {
      ex.printStackTrace();
    }
    mclm.connectToReceiverOf(first_midi_out_model);
  }
  public Sequencer getSequencer() { return sequencer; }
  public boolean isRecordable() {
    return editor_dialog != null && editor_dialog.isRecordable();
  }
  public void resetMicrosecondPosition() {
    for( MidiConnecterListModel model : this )
      model.resetMicrosecondPosition();
  }
}

///////////////////////////////////////
//
// MIDI Device Dialog
//
///////////////////////////////////////
class MidiDeviceDialog extends JDialog
{
  MidiDeviceTree device_tree;
  JEditorPane device_info_pane = new JEditorPane(
    "text/html","<html></html>"
  );
  MidiDesktopPane desktop_pane;
  public MidiDeviceDialog(
    java.util.List<MidiConnecterListModel> device_models
  ) {
    setTitle("MIDI device connection");
    setBounds( 300, 300, 800, 500 );

    device_info_pane.setEditable(false);

    desktop_pane = new MidiDesktopPane(device_models);

    device_tree = new MidiDeviceTree(
      new MidiDeviceTreeModel(device_models)
    );
    device_tree.addTreeSelectionListener(
      new TreeSelectionListener() {
        public void valueChanged(TreeSelectionEvent e) {
          String html = "<html><head></head><body>";
          Object obj = device_tree.getLastSelectedPathComponent();
          if( obj instanceof MidiConnecterListModel ) {
            MidiConnecterListModel device_model = (MidiConnecterListModel)obj;
            MidiDevice device = device_model.device;
            MidiDevice.Info info = device.getDeviceInfo();
            html += "<b>"+device_model+"</b><br/>";
            html += "<table border=\"1\"><tbody>";
            html += "<tr><th>Version</th><td>"+info.getVersion()+"</td></tr>";
            html += "<tr><th>Description</th><td>"+info.getDescription()+"</td></tr>";
            html += "<tr><th>Vendor</th><td>"+info.getVendor()+"</td></tr>";
            html += "</tbody></table>";
            MidiDeviceFrame frame = desktop_pane.getFrame(device_model);
            if( frame != null ) {
              try {
                frame.setSelected(true);
              } catch( PropertyVetoException ex ) {
                ex.printStackTrace();
              }
            }
          }
          else if( obj instanceof MidiDeviceGroup ) {
            MidiDeviceGroup group = (MidiDeviceGroup)obj;
            html += "<b>"+group+"</b><br/>";
            html += group.getDescription()+"<br/>";
          }
          else if( obj != null ) {
            html += obj.toString();
          }
          html += "</body></html>";
          device_info_pane.setText(html);
        }
      }
    );

    JSplitPane side_split_pane = new JSplitPane(
      JSplitPane.VERTICAL_SPLIT,
      new JScrollPane(device_tree),
      new JScrollPane(device_info_pane)
    );
    side_split_pane.setDividerLocation(300);

    JSplitPane device_split_pane = new JSplitPane(
      JSplitPane.HORIZONTAL_SPLIT,
      side_split_pane, desktop_pane
    );
    device_split_pane.setOneTouchExpandable(true);
    device_split_pane.setDividerLocation(250);
    add( device_split_pane );
  }
}

///////////////////////////////////////////////////////
//
// JĂ MIDI foCXu߂̃fXNgbv
//
class MidiDesktopPane extends JDesktopPane
  implements DropTargetListener
{
  MidiCablePane cable_pane;
  public MidiDesktopPane(
    java.util.List<MidiConnecterListModel> device_models
  ) {
    add( cable_pane = new MidiCablePane(), JLayeredPane.PALETTE_LAYER );
    int i=0;
    for( MidiConnecterListModel m : device_models ) {
      MidiDeviceFrame frame = new MidiDeviceFrame(m);
      frame.setBounds( 0, 0, 250, 90 );
      frame.addInternalFrameListener(cable_pane);
      frame.addComponentListener(cable_pane);
      m.addListDataListener(cable_pane);
      add(frame);
      if( m.device.isOpen() ) {
        frame.setBounds( 10+(i%2)*260, 10+i*50, 250, 90 );
        frame.setVisible(true);
        i++;
      }
    }
    addComponentListener(
      new ComponentAdapter() {
        public void componentResized(ComponentEvent e) {
          cable_pane.setSize(getSize());
        }
      }
    );
    DropTarget drop_target = new DropTarget(
      this, DnDConstants.ACTION_COPY_OR_MOVE, this
    );
  }
  // DropTargetListener
  //
  public void dragEnter(DropTargetDragEvent dtde) {
    Transferable trans = dtde.getTransferable();
    DataFlavor[] flavor = trans.getTransferDataFlavors();
    if( trans.isDataFlavorSupported(flavor[0]) )
      dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
  }
  public void dragExit(DropTargetEvent dte) {}
  public void dragOver(DropTargetDragEvent dtde) {}
  public void dropActionChanged(DropTargetDragEvent dtde) {}
  public void drop(DropTargetDropEvent dtde) {
    dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
    try {
      if( (dtde.getDropAction() & DnDConstants.ACTION_COPY_OR_MOVE) != 0 ) {
        Transferable trans = dtde.getTransferable();
        DataFlavor[] flavor = trans.getTransferDataFlavors();
        Object trans_data = trans.getTransferData(flavor[0]);
        if( trans_data instanceof MidiConnecterListModel ) {
          MidiConnecterListModel device_model
            = (MidiConnecterListModel)trans_data;
          try {
            device_model.openDevice();
          } catch( MidiUnavailableException e ) {
            //
            // foCXĴɎsꍇ
            //
            //   Ⴆ΁AuMicrosort MIDI }bp[v
            //   uMicrosoft GS Wavetable SW Synthv
            //   ɊJƂƂɗB
            //
            dtde.dropComplete(false);
            JOptionPane.showMessageDialog(
              null,
              device_model.unicode_conv.convertToUnicode(e.getMessage()),
              "Cannot open MIDI device",
              JOptionPane.ERROR_MESSAGE
            );
          }
          if( device_model.device.isOpen() ) {
            dtde.dropComplete(true);
            //
            // foCXɊJꂽƂmFł
            // hbvꏊփt[zuĉB
            //
            JInternalFrame frame = getFrame(device_model);
            if( frame != null ) {
              Point loc = dtde.getLocation();
              loc.translate( -frame.getWidth()/2, 0 );
              frame.setLocation(loc);
              frame.setVisible(true);
            }
          }
          else dtde.dropComplete(false);
        }
        else dtde.dropComplete(false);
      }
      else dtde.dropComplete(false);
    }
    catch (Exception ex) {
      ex.printStackTrace();
      dtde.dropComplete(false);
    }
  }
  // Methods
  //
  public MidiDeviceFrame getFrame(
    MidiConnecterListModel device_model
  ) {
    JInternalFrame[] frames =
      getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);

    for( JInternalFrame frame : frames ) {
      if( ! (frame instanceof MidiDeviceFrame) )
        continue;
      MidiDeviceFrame device_frame = (MidiDeviceFrame)frame;
      if( device_frame.list.getModel() == device_model )
        return device_frame;
    }
    return null;
  }
}

///////////////////////////////////////////////////////
//
// MIDI P[u`
//
class MidiCablePane extends JComponent
  implements
    ListDataListener, ComponentListener,
    InternalFrameListener
{
  protected Stroke cable_stroke = new BasicStroke(
    3, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND
  );
  protected Color[] cable_colors = {
    new Color(255,0,0,191),
    new Color(0,255,0,191),
    new Color(0,0,255,191),
    new Color(191,191,0,191),
    new Color(0,191,191,191),
    new Color(191,0,191,191),
  };
  protected int next_color_index = 0;
  protected Hashtable<Receiver,Color> color_map = new Hashtable<Receiver,Color>();
  protected void removeReceiverOf(MidiDeviceFrame frame) {
    MidiConnecterListModel dev_model = frame.list.getModel();
    if( ! dev_model.hasRx() ) return;
    color_map.remove(dev_model.device.getReceivers().get(0));
  }
  public MidiCablePane() {
    setOpaque(false);
    setVisible(true);
  }
  // InternalFrameListener (MidiDeviceFrame)
  //   JĂfoCX̃EBhEJƂ
  //
  public void internalFrameActivated(InternalFrameEvent e) {}
  public void internalFrameClosed(InternalFrameEvent e) { repaint(); }
  public void internalFrameClosing(InternalFrameEvent e) {
    JInternalFrame frame = e.getInternalFrame();
    if( ! (frame instanceof MidiDeviceFrame) ) return;
    removeReceiverOf((MidiDeviceFrame)frame);
    repaint();
  }
  public void internalFrameDeactivated(InternalFrameEvent e) { repaint(); }
  public void internalFrameDeiconified(InternalFrameEvent e) {}
  public void internalFrameIconified(InternalFrameEvent e) {}
  public void internalFrameOpened(InternalFrameEvent e) {}
  //
  // ComponentListener (MidiDeviceFrame)
  //   JĂfoCX̃EBhEړƂ
  //
  public void componentHidden(ComponentEvent e) {}
  public void componentMoved(ComponentEvent e) { repaint(); }
  public void componentResized(ComponentEvent e) { repaint(); }
  public void componentShown(ComponentEvent e) {}
  //
  // ListDataListener (MidiConnecterListModel)
  //   foCX Transmitter ɒǉ폜Ƃ
  //
  public void contentsChanged(ListDataEvent e) { repaint(); }
  public void intervalAdded(ListDataEvent e) { repaint(); }
  public void intervalRemoved(ListDataEvent e) { repaint(); }
  //
  // P[u̕`@֋Lq
  //
  public void paint(Graphics g) {
    super.paint(g);
    Graphics2D g2 = (Graphics2D)g;
    g2.setStroke(cable_stroke);
    JInternalFrame[] frames = getFrames();
    for( JInternalFrame frame : frames ) {
      if( ! (frame instanceof MidiDeviceFrame) ) continue;
      MidiDeviceFrame tx_device_frame = (MidiDeviceFrame)frame;
      MidiConnecterListModel tx_model = tx_device_frame.list.getModel();
      java.util.List<Transmitter>
        transmitters = tx_model.device.getTransmitters();
      for( Transmitter tx : transmitters ) {
        Receiver rx = tx.getReceiver();
        if( rx == null ) continue;
        Rectangle tx_rect = tx_device_frame.getListCellBounds(
          tx_model.indexOf((Object)tx)
        );
        if( tx_rect == null ) continue;
        tx_rect.translate( tx_device_frame.getX(), tx_device_frame.getY() );
        Rectangle rx_rect = null;
        for( JInternalFrame another_frame : frames ) {
          if( ! (another_frame instanceof MidiDeviceFrame) )
            continue;
          MidiDeviceFrame rx_device_frame = (MidiDeviceFrame)another_frame;
          MidiConnecterListModel rx_model = rx_device_frame.list.getModel();
          rx_rect = rx_device_frame.getListCellBounds(
            rx_model.indexOf((Object)rx)
          );
          if( rx_rect != null ) {
            rx_rect.translate( rx_device_frame.getX(), rx_device_frame.getY() );
            break;
          }
        }
        if( rx_rect == null ) continue;
        Color color = color_map.get(rx);
        if( color == null ) {
          color = cable_colors[next_color_index];
          color_map.put( rx, color );
          if( ++next_color_index >= cable_colors.length )
            next_color_index = 0;
        }
        g2.setColor(color);
        //
        // n_
        g2.fillOval( tx_rect.x, tx_rect.y, tx_rect.height-1, tx_rect.height-1 );
        int start_x = tx_rect.x + tx_rect.height/2;
        int start_y = tx_rect.y + tx_rect.height/2;
        int end_x = rx_rect.x + rx_rect.height/2;
        int end_y = rx_rect.y + rx_rect.height/2;
        // 
        g2.drawLine( start_x, start_y, end_x, end_y );
        // 
        int arrow_size = 15;
        double arrow_angle = Math.PI / 6.0;
        double t = Math.atan2(
          (double)(end_y - start_y), (double)(end_x - start_x)
        );
        g2.drawLine( end_x, end_y,
          end_x - (int)(arrow_size * Math.cos(t-arrow_angle)),
          end_y - (int)(arrow_size * Math.sin(t-arrow_angle))
        );
        g2.drawLine( end_x, end_y,
          end_x - (int)(arrow_size * Math.cos(t+arrow_angle)),
          end_y - (int)(arrow_size * Math.sin(t+arrow_angle))
        );
      }
    }
  }
  protected JInternalFrame[] getFrames() {
    Container parent = getParent();
    if( ! (parent instanceof MidiDesktopPane) )
      return new JInternalFrame[0];
    return (
      (MidiDesktopPane)parent
    ).getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
  }
}

