/*
 * Decompiled with CFR 0.152.
 */
import java.beans.PropertyVetoException;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

class MidiDeviceDialog
extends JDialog {
    MidiDeviceTree device_tree;
    JEditorPane device_info_pane = new JEditorPane("text/html", "<html></html>");
    MidiDesktopPane desktop_pane;

    public MidiDeviceDialog(List<MidiConnecterListModel> list) {
        this.setTitle("MIDI device connection");
        this.setBounds(300, 300, 800, 500);
        this.device_info_pane.setEditable(false);
        this.desktop_pane = new MidiDesktopPane(list);
        this.device_tree = new MidiDeviceTree(new MidiDeviceTreeModel(list));
        this.device_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                String string = "<html><head></head><body>";
                Object object = MidiDeviceDialog.this.device_tree.getLastSelectedPathComponent();
                if (object instanceof MidiConnecterListModel) {
                    MidiConnecterListModel midiConnecterListModel = (MidiConnecterListModel)object;
                    MidiDevice midiDevice = midiConnecterListModel.device;
                    MidiDevice.Info info = midiDevice.getDeviceInfo();
                    string = string + "<b>" + midiConnecterListModel + "</b><br/>";
                    string = string + "<table border=\"1\"><tbody>";
                    string = string + "<tr><th>Version</th><td>" + info.getVersion() + "</td></tr>";
                    string = string + "<tr><th>Description</th><td>" + info.getDescription() + "</td></tr>";
                    string = string + "<tr><th>Vendor</th><td>" + info.getVendor() + "</td></tr>";
                    string = string + "</tbody></table>";
                    MidiDeviceFrame midiDeviceFrame = MidiDeviceDialog.this.desktop_pane.getFrame(midiConnecterListModel);
                    if (midiDeviceFrame != null) {
                        try {
                            midiDeviceFrame.setSelected(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            propertyVetoException.printStackTrace();
                        }
                    }
                } else if (object instanceof MidiDeviceGroup) {
                    MidiDeviceGroup midiDeviceGroup = (MidiDeviceGroup)object;
                    string = string + "<b>" + midiDeviceGroup + "</b><br/>";
                    string = string + midiDeviceGroup.getDescription() + "<br/>";
                } else if (object != null) {
                    string = string + object.toString();
                }
                string = string + "</body></html>";
                MidiDeviceDialog.this.device_info_pane.setText(string);
            }
        });
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.device_tree), new JScrollPane(this.device_info_pane));
        jSplitPane.setDividerLocation(300);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, this.desktop_pane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerLocation(250);
        this.add(jSplitPane2);
    }
}

