/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;

class MidiDesktopPane
extends JDesktopPane
implements DropTargetListener {
    MidiCablePane cable_pane = new MidiCablePane();

    public MidiDesktopPane(List<MidiConnecterListModel> list) {
        this.add((Component)this.cable_pane, JLayeredPane.PALETTE_LAYER);
        int n = 0;
        for (MidiConnecterListModel midiConnecterListModel : list) {
            MidiDeviceFrame midiDeviceFrame = new MidiDeviceFrame(midiConnecterListModel);
            midiDeviceFrame.setBounds(0, 0, 250, 90);
            midiDeviceFrame.addInternalFrameListener(this.cable_pane);
            midiDeviceFrame.addComponentListener(this.cable_pane);
            midiConnecterListModel.addListDataListener(this.cable_pane);
            this.add(midiDeviceFrame);
            if (!midiConnecterListModel.device.isOpen()) continue;
            midiDeviceFrame.setBounds(10 + n % 2 * 260, 10 + n * 50, 250, 90);
            midiDeviceFrame.setVisible(true);
            ++n;
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MidiDesktopPane.this.cable_pane.setSize(MidiDesktopPane.this.getSize());
            }
        });
        DropTarget dropTarget = new DropTarget(this, 3, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray;
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported((dataFlavorArray = transferable.getTransferDataFlavors())[0])) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block9: {
            dropTargetDropEvent.acceptDrop(3);
            try {
                if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                    DataFlavor[] dataFlavorArray;
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    Object object = transferable.getTransferData((dataFlavorArray = transferable.getTransferDataFlavors())[0]);
                    if (object instanceof MidiConnecterListModel) {
                        MidiConnecterListModel midiConnecterListModel = (MidiConnecterListModel)object;
                        try {
                            midiConnecterListModel.openDevice();
                        }
                        catch (MidiUnavailableException midiUnavailableException) {
                            dropTargetDropEvent.dropComplete(false);
                            JOptionPane.showMessageDialog(null, midiConnecterListModel.unicode_conv.convertToUnicode(midiUnavailableException.getMessage()), "Cannot open MIDI device", 0);
                        }
                        if (midiConnecterListModel.device.isOpen()) {
                            dropTargetDropEvent.dropComplete(true);
                            MidiDeviceFrame midiDeviceFrame = this.getFrame(midiConnecterListModel);
                            if (midiDeviceFrame != null) {
                                Point point = dropTargetDropEvent.getLocation();
                                point.translate(-midiDeviceFrame.getWidth() / 2, 0);
                                midiDeviceFrame.setLocation(point);
                                midiDeviceFrame.setVisible(true);
                            }
                        } else {
                            dropTargetDropEvent.dropComplete(false);
                        }
                        break block9;
                    }
                    dropTargetDropEvent.dropComplete(false);
                    break block9;
                }
                dropTargetDropEvent.dropComplete(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
        }
    }

    public MidiDeviceFrame getFrame(MidiConnecterListModel midiConnecterListModel) {
        JInternalFrame[] jInternalFrameArray;
        for (JInternalFrame jInternalFrame : jInternalFrameArray = this.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER)) {
            if (!(jInternalFrame instanceof MidiDeviceFrame)) continue;
            MidiDeviceFrame midiDeviceFrame = (MidiDeviceFrame)jInternalFrame;
            if (midiDeviceFrame.list.getModel() != midiConnecterListModel) continue;
            return midiDeviceFrame;
        }
        return null;
    }
}

