/*
 * Decompiled with CFR 0.152.
 */
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import javax.sound.midi.Transmitter;
import javax.swing.JList;

class MidiConnecterList
extends JList
implements Transferable,
DragGestureListener,
DropTargetListener {
    DataFlavor tx_flavor = new DataFlavor(Transmitter.class, "Transmitter");

    public MidiConnecterList(MidiConnecterListModel midiConnecterListModel) {
        super(midiConnecterListModel);
        Serializable serializable;
        this.setCellRenderer(new MidiTxRxListCellRenderer());
        this.setSelectionMode(0);
        if (midiConnecterListModel.hasTx()) {
            serializable = new DragSource();
            DragGestureRecognizer dragGestureRecognizer = serializable.createDefaultDragGestureRecognizer(this, 3, this);
        }
        if (midiConnecterListModel.hasRx()) {
            serializable = new DropTarget(this, 3, this);
        }
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(0);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) {
        return this.getModel().getElementAt(this.getSelectedIndex());
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.tx_flavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(this.tx_flavor);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object object;
        if ((dragGestureEvent.getDragAction() | 3) != 0 && (object = this.getModel().getElementAt(this.locationToIndex(dragGestureEvent.getDragOrigin()))) instanceof Transmitter) {
            dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, this, null);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray;
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported((dataFlavorArray = transferable.getTransferDataFlavors())[0])) {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(3);
        try {
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                DataFlavor[] dataFlavorArray;
                Transferable transferable = dropTargetDropEvent.getTransferable();
                Object object = transferable.getTransferData((dataFlavorArray = transferable.getTransferDataFlavors())[0]);
                if (object instanceof Transmitter) {
                    this.getModel().ConnectToReceiver((Transmitter)object);
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public MidiConnecterListModel getModel() {
        return (MidiConnecterListModel)super.getModel();
    }

    public Transmitter getSelectedTransmitter() {
        Object e = this.getSelectedValue();
        if (e == null || !(e instanceof Transmitter)) {
            return null;
        }
        return (Transmitter)e;
    }
}

