/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.Sequencer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MeasureIndicator
extends JPanel {
    SequencerTimeRangeModel model;
    MeasureLabel measure_position_label = new MeasureLabel();
    MeasureLabel measure_length_label;

    public MeasureIndicator() {
        this.measure_position_label.setToolTipText("Measure:beat position - \u4f55\u5c0f\u7bc0\u76ee\uff1a\u4f55\u62cd\u76ee");
        this.measure_length_label = new MeasureLabel(1);
        this.measure_length_label.setToolTipText("Measure length - \u5c0f\u7bc0\u306e\u6570");
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.measure_position_label);
        this.add(this.measure_length_label);
    }

    public MeasureIndicator(SequencerTimeRangeModel sequencerTimeRangeModel) {
        this();
        this.model = sequencerTimeRangeModel;
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SequenceIndex sequenceIndex;
                SequencerTimeRangeModel sequencerTimeRangeModel = MeasureIndicator.this.model;
                Sequencer sequencer = sequencerTimeRangeModel.device_manager.getSequencer();
                MidiSequenceModel midiSequenceModel = sequencerTimeRangeModel.device_manager.time_range_model.getSequenceModel();
                SequenceIndex sequenceIndex2 = sequenceIndex = midiSequenceModel == null ? null : midiSequenceModel.getSequenceIndex();
                if (!sequencer.isRunning() || sequencer.isRecording()) {
                    MeasureIndicator.this.measure_length_label.setMeasure(sequenceIndex == null ? 0 : sequenceIndex.tickToMeasure(sequencer.getTickLength()));
                }
                if (sequenceIndex == null) {
                    MeasureIndicator.this.measure_position_label.setMeasure(0, 0);
                } else {
                    int n = sequenceIndex.tickToMeasure(sequencer.getTickPosition());
                    MeasureIndicator.this.measure_position_label.setMeasure(n, sequenceIndex.last_beat);
                }
            }
        });
    }
}

