/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class KeySignatureSelecter
extends JPanel
implements ActionListener {
    JComboBox keysig_combobox;
    JCheckBox minor_checkbox = null;

    public KeySignatureSelecter() {
        this(true);
    }

    public KeySignatureSelecter(boolean bl) {
        this.add(new JLabel("Key:"));
        this.keysig_combobox = new JComboBox();
        this.add(this.keysig_combobox);
        if (bl) {
            this.minor_checkbox = new JCheckBox("minor");
            this.add(this.minor_checkbox);
            this.minor_checkbox.addActionListener(this);
        }
        for (int i = -7; i <= 7; ++i) {
            Music.Key key = new Music.Key(i);
            String string = key.toString();
            if (i != 0) {
                string = key.signature() + " : " + string;
            }
            this.keysig_combobox.addItem(string);
        }
        this.keysig_combobox.setMaximumRowCount(15);
        this.keysig_combobox.addActionListener(this);
        this.clear();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateToolTipText();
    }

    private void updateToolTipText() {
        Music.Key key = this.getKey();
        this.keysig_combobox.setToolTipText("Key: " + key.toStringIn(1) + " " + key.toStringIn(2) + " (" + key.signatureDescription() + ")");
    }

    public void clear() {
        this.setKey(new Music.Key("C"));
    }

    public void setKey(Music.Key key) {
        if (key == null) {
            this.clear();
            return;
        }
        this.keysig_combobox.setSelectedIndex(key.toCo5() + 7);
        if (this.minor_checkbox == null) {
            return;
        }
        switch (key.majorMinor()) {
            case -1: {
                this.minor_checkbox.setSelected(true);
                break;
            }
            case 1: {
                this.minor_checkbox.setSelected(false);
            }
        }
    }

    public Music.Key getKey() {
        int n = this.minor_checkbox == null ? 0 : (this.isMinor() ? -1 : 1);
        return new Music.Key(this.getKeyCo5(), n);
    }

    public int getKeyCo5() {
        return this.keysig_combobox.getSelectedIndex() - 7;
    }

    public boolean isMinor() {
        return this.minor_checkbox != null && this.minor_checkbox.isSelected();
    }
}

