/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class ChordMatrix
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener,
MouseWheelListener {
    public static final int N_COLUMNS = 25;
    public static final int ROW_SUS4 = 0;
    public static final int ROW_MAJOR = 1;
    public static final int ROW_MINOR = 2;
    public static final int CHORD_BUTTON_ROWS = 3;
    public Co5Label[] keysig_labels = new Co5Label[25];
    public ChordLabel[] chord_labels = new ChordLabel[75];
    public ChordGuide chord_guide;
    ChordDisplay chord_display = new ChordDisplay("Chord Pad", this, null);
    CapoComboBoxModel capo_value_model = new CapoComboBoxModel();
    CapoSelecter capo_selecter = new CapoSelecter(this.capo_value_model);
    private Music.Key key = null;
    private Music.Key capo_key = null;
    private boolean is_dark = false;
    private EventListenerList listenerList = new EventListenerList();
    private Music.Chord selected_chord = null;
    private Music.Chord selected_chord_capo = null;
    private ChordLabel selected_chord_label = null;
    private ChordLabel destination_chord_label = null;
    private int selected_note_index = -1;
    private byte timesig_upper = (byte)4;
    private byte current_beat = 0;
    private boolean is_playing = false;
    private int pc_key_next_shift7 = 0;
    ColorSet normal_mode_colorset;
    ColorSet dark_mode_colorset;
    ColorSet current_colorset;
    ChordLabelSelections[] chord_label_selections = new ChordLabelSelections[12];
    private int capo = 0;

    public ChordMatrix() {
        Serializable serializable;
        this.normal_mode_colorset = new ColorSet();
        this.normal_mode_colorset.foregrounds[0] = null;
        this.normal_mode_colorset.foregrounds[1] = new Color(255, 63, 63);
        this.normal_mode_colorset.backgrounds[0] = new Color(207, 255, 207);
        this.normal_mode_colorset.backgrounds[1] = new Color(159, 255, 255);
        this.normal_mode_colorset.backgrounds[2] = new Color(255, 207, 207);
        this.normal_mode_colorset.backgrounds[3] = new Color(255, 255, 159);
        this.normal_mode_colorset.indicators[0] = new Color(255, 63, 63);
        this.normal_mode_colorset.indicators[1] = new Color(207, 111, 0);
        this.normal_mode_colorset.indicators[2] = new Color(63, 63, 255);
        this.normal_mode_colorset.focus[0] = null;
        this.normal_mode_colorset.focus[1] = this.getBackground().darker();
        this.dark_mode_colorset = new ColorSet(true);
        this.dark_mode_colorset.foregrounds[0] = Color.gray.darker();
        this.dark_mode_colorset.foregrounds[1] = Color.pink.brighter();
        this.dark_mode_colorset.backgrounds[0] = Color.black;
        this.dark_mode_colorset.backgrounds[1] = new Color(0, 24, 24);
        this.dark_mode_colorset.backgrounds[2] = new Color(32, 0, 0);
        this.dark_mode_colorset.backgrounds[3] = new Color(24, 24, 0);
        this.dark_mode_colorset.indicators[0] = Color.pink;
        this.dark_mode_colorset.indicators[1] = Color.yellow;
        this.dark_mode_colorset.indicators[2] = Color.cyan;
        this.dark_mode_colorset.focus[0] = Color.black;
        this.dark_mode_colorset.focus[1] = this.getForeground().brighter();
        this.current_colorset = this.normal_mode_colorset;
        this.chord_guide = new ChordGuide(this);
        Dimension dimension = new Dimension(28, 26);
        int n = 0;
        int n2 = -12;
        while (n < 25) {
            Co5Label co5Label = new Co5Label(n2);
            co5Label.addMouseListener(this);
            co5Label.addMouseMotionListener(this);
            this.keysig_labels[n] = co5Label;
            this.add(this.keysig_labels[n]);
            co5Label.setPreferredSize(dimension);
            ++n;
            ++n2;
        }
        for (n = 0; n < 75; ++n) {
            int n3 = n / 25;
            n2 = n - 25 * n3 - 12;
            Music.Chord chord = new Music.Chord(n3 == 2 ? n2 + 3 : n2);
            if (n3 == 0) {
                chord.setSus4();
            } else if (n3 == 2) {
                chord.setMinorThird();
            }
            serializable = new ChordLabel(chord);
            ((Component)serializable).addMouseListener(this);
            ((Component)serializable).addMouseMotionListener(this);
            ((Component)serializable).addMouseWheelListener(this);
            this.chord_labels[n] = serializable;
            this.add(this.chord_labels[n]);
            ((JComponent)serializable).setPreferredSize(dimension);
        }
        this.setFocusable(true);
        this.setOpaque(true);
        this.addKeyListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ChordMatrix.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ChordMatrix.this.selected_chord = (ChordMatrix.this.selected_chord_capo = null);
                ChordMatrix.this.fireChordChanged();
                ChordMatrix.this.repaint();
            }
        });
        this.setLayout(new GridLayout(4, 25, 2, 2));
        this.setKeySignature(new Music.Key());
        for (int i = 0; i < this.chord_label_selections.length; ++i) {
            Music.Chord chord;
            serializable = new ArrayList();
            for (ChordLabel chordLabel : this.chord_labels) {
                if (chordLabel.is_sus4 || chordLabel.chord.indexOf(i) != 0) continue;
                ((ArrayList)serializable).add(new ChordLabelSelection(chordLabel, 0));
            }
            for (ChordLabel chordLabel : this.chord_labels) {
                if (!chordLabel.is_sus4 || chordLabel.chord.indexOf(i) != 0) continue;
                ((ArrayList)serializable).add(new ChordLabelSelection(chordLabel, 0));
            }
            for (ChordLabel chordLabel : this.chord_labels) {
                int n4 = chordLabel.chord.indexOf(i);
                if (n4 != 1 && n4 != 2) continue;
                ((ArrayList)serializable).add(new ChordLabelSelection(chordLabel, n4));
            }
            for (ChordLabel chordLabel : this.chord_labels) {
                if (chordLabel.is_sus4) continue;
                chord = chordLabel.chord.clone();
                chord.setFlattedFifth();
                if (chord.indexOf(i) != 2) continue;
                ((ArrayList)serializable).add(new ChordLabelSelection(chordLabel, 3));
            }
            for (ChordLabel chordLabel : this.chord_labels) {
                if (chordLabel.is_sus4 || chordLabel.is_minor) continue;
                chord = chordLabel.chord.clone();
                chord.setSharpedFifth();
                if (chord.indexOf(i) != 2) continue;
                ((ArrayList)serializable).add(new ChordLabelSelection(chordLabel, 4));
            }
            this.chord_label_selections[i] = new ChordLabelSelections(i, (ArrayList<ChordLabelSelection>)serializable);
        }
        this.capo_selecter.checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChordMatrix.this.capoChanged();
            }
        });
        this.capo_selecter.value_selecter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordMatrix.this.capoChanged();
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof ChordLabel) {
            ChordLabel chordLabel = (ChordLabel)component;
            Music.Chord chord = chordLabel.chord.clone();
            if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                if (mouseEvent.isShiftDown()) {
                    chord.setMajorSeventh();
                } else {
                    chord.setSeventh();
                }
            } else if (mouseEvent.isShiftDown()) {
                chord.setSixth();
            }
            if (mouseEvent.isControlDown()) {
                chord.setNinth();
            } else {
                chord.clearNinth();
            }
            if (mouseEvent.isAltDown()) {
                if (chordLabel.is_sus4) {
                    chord.setMajorThird();
                    chord.setSharpedFifth();
                } else {
                    chord.setFlattedFifth();
                }
            }
            if (this.selected_chord_label != null) {
                this.selected_chord_label.setSelection(false);
            }
            this.selected_chord_label = chordLabel;
            this.selected_chord_label.setSelection(true);
            this.setSelectedChord(chord);
        } else if (component instanceof Co5Label) {
            int n = ((Co5Label)component).co5_value;
            if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                this.setKeySignature(new Music.Key(Music.oppositeCo5(n)));
            } else if (n == this.key.toCo5()) {
                this.setSelectedChord((Music.Chord)null);
            } else {
                this.setKeySignature(new Music.Key(n));
            }
        }
        this.requestFocusInWindow();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.destination_chord_label = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof ChordLabel) {
            ChordLabel chordLabel;
            ChordLabel chordLabel2 = (ChordLabel)component;
            Component component2 = this.getComponentAt(chordLabel2.getX() + mouseEvent.getX(), chordLabel2.getY() + mouseEvent.getY());
            if (component2 == this) {
                return;
            }
            ChordLabel chordLabel3 = component2 == null ? null : (chordLabel = component2 instanceof ChordLabel ? (ChordLabel)component2 : null);
            if (chordLabel == chordLabel2) {
                this.destination_chord_label = null;
                return;
            }
            if (this.destination_chord_label != null) {
                return;
            }
            Music.Chord chord = chordLabel2.chord.clone();
            if (chordLabel2.is_minor) {
                if (chordLabel == null) {
                    chord.setMajorSeventh();
                } else if (chordLabel2.co5_value < chordLabel.co5_value) {
                    chord.setSixth();
                } else {
                    chord.setSeventh();
                }
            } else if (chordLabel2.is_sus4) {
                if (chordLabel == null) {
                    return;
                }
                if (!chordLabel.is_sus4) {
                    chord.setMajorThird();
                } else if (chordLabel2.co5_value < chordLabel.co5_value) {
                    chord.setNinth();
                } else {
                    chord.setSeventh();
                }
            } else {
                if (chordLabel == null) {
                    return;
                }
                if (chordLabel.is_sus4) {
                    chord.setNinth();
                } else if (chordLabel2.co5_value < chordLabel.co5_value) {
                    chord.setMajorSeventh();
                } else if (chordLabel.is_minor) {
                    chord.setSixth();
                } else {
                    chord.setSeventh();
                }
            }
            if (chord.hasNinth() || chordLabel2.is_sus4 && (chordLabel == null || !chordLabel.is_sus4)) {
                if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                    if (mouseEvent.isShiftDown()) {
                        chord.setMajorSeventh();
                    } else {
                        chord.setSeventh();
                    }
                } else if (mouseEvent.isShiftDown()) {
                    chord.setSixth();
                }
            } else if (mouseEvent.isControlDown()) {
                chord.setNinth();
            } else {
                chord.clearNinth();
            }
            if (mouseEvent.isAltDown()) {
                if (chordLabel2.is_sus4) {
                    chord.setMajorThird();
                    chord.setSharpedFifth();
                } else {
                    chord.setFlattedFifth();
                }
            }
            this.setSelectedChord(chord);
            this.destination_chord_label = chordLabel == null ? chordLabel2 : chordLabel;
        } else if (component instanceof Co5Label) {
            Co5Label co5Label = (Co5Label)component;
            Component component3 = this.getComponentAt(co5Label.getX() + mouseEvent.getX(), co5Label.getY() + mouseEvent.getY());
            if (component3 == null || !(component3 instanceof Co5Label)) {
                return;
            }
            Co5Label co5Label2 = (Co5Label)component3;
            int n = co5Label2.co5_value;
            if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                this.setKeySignature(new Music.Key(Music.oppositeCo5(n)));
            } else {
                this.setKeySignature(new Music.Key(n));
            }
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.selected_chord != null) {
            if (mouseWheelEvent.getWheelRotation() > 0) {
                if (--this.selected_note_index < 0) {
                    this.selected_note_index = this.selected_chord.numberOfNotes() - 1;
                }
            } else if (++this.selected_note_index >= this.selected_chord.numberOfNotes()) {
                this.selected_note_index = 0;
            }
            this.fireChordChanged();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Music.Chord chord;
        ChordLabel chordLabel;
        boolean bl;
        int n;
        int n2;
        int n3;
        block27: {
            int n4;
            block39: {
                int n5;
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        char c;
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block26: {
                                                                n3 = -1;
                                                                n2 = -1;
                                                                n = 1;
                                                                bl = false;
                                                                c = keyEvent.getKeyChar();
                                                                n5 = keyEvent.getKeyCode();
                                                                chordLabel = null;
                                                                chord = null;
                                                                n4 = this.key.toCo5();
                                                                n3 = "6 ".indexOf(c);
                                                                if (n3 >= 0) {
                                                                    this.selected_chord_capo = null;
                                                                    this.selected_chord = null;
                                                                    this.fireChordChanged();
                                                                    this.pc_key_next_shift7 = 0;
                                                                    return;
                                                                }
                                                                n3 = "asdfghjkl;:]".indexOf(c);
                                                                if (n3 < 0) break block26;
                                                                n2 = n3 + n4 + 7;
                                                                break block27;
                                                            }
                                                            n3 = "ASDFGHJKL+*}".indexOf(c);
                                                            if (n3 < 0) break block28;
                                                            n2 = n3 + n4 + 7;
                                                            bl = true;
                                                            break block27;
                                                        }
                                                        n3 = "zxcvbnm,./\\".indexOf(c);
                                                        if (n3 < 0) break block29;
                                                        n2 = n3 + n4 + 7;
                                                        n = 2;
                                                        break block27;
                                                    }
                                                    n3 = "ZXCVBNM<>?_".indexOf(c);
                                                    if (n3 < 0) break block30;
                                                    n2 = n3 + n4 + 7;
                                                    n = 2;
                                                    bl = true;
                                                    break block27;
                                                }
                                                n3 = "qwertyuiop@[".indexOf(c);
                                                if (n3 < 0) break block31;
                                                n2 = n3 + n4 + 7;
                                                n = 0;
                                                break block27;
                                            }
                                            n3 = "QWERTYUIOP`{".indexOf(c);
                                            if (n3 < 0) break block32;
                                            n2 = n3 + n4 + 7;
                                            n = 0;
                                            bl = true;
                                            break block27;
                                        }
                                        if (c == '5') {
                                            this.pc_key_next_shift7 = 11;
                                            return;
                                        }
                                        if (c == '7') {
                                            this.pc_key_next_shift7 = 10;
                                            return;
                                        }
                                        if (n5 == 37) break block33;
                                        if (n5 != 226) break block34;
                                    }
                                    this.setKeySignature(new Music.Key(n4 - 1));
                                    return;
                                }
                                if (n5 == 39) break block35;
                                if (n5 != 227) break block36;
                            }
                            this.setKeySignature(new Music.Key(n4 + 1));
                            return;
                        }
                        if (n5 == 40) break block37;
                        if (n5 != 225) break block38;
                    }
                    Music.Key key = new Music.Key(n4);
                    key.transpose(-1);
                    this.setKeySignature(key);
                    return;
                }
                if (n5 == 38) break block39;
                if (n5 != 224) break block27;
            }
            Music.Key key = new Music.Key(n4);
            key.transpose(1);
            this.setKeySignature(key);
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n2 < 0) {
            n2 += 12;
        } else if (n2 > 25) {
            n2 -= 12;
        }
        chordLabel = this.chord_labels[n2 + 25 * n];
        chord = chordLabel.chord.clone();
        if (bl) {
            chord.setSeventh();
        } else {
            chord.offsets[2] = this.pc_key_next_shift7;
        }
        if (keyEvent.isAltDown()) {
            if (chordLabel.is_sus4) {
                chord.setMajorThird();
                chord.setSharpedFifth();
            } else {
                chord.setFlattedFifth();
            }
        }
        if (keyEvent.isControlDown()) {
            chord.setNinth();
        }
        if (this.selected_chord_label != null) {
            this.clear();
        }
        this.selected_chord_label = chordLabel;
        this.selected_chord_label.setSelection(true);
        this.setSelectedChord(chord);
        this.pc_key_next_shift7 = 0;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void fireChordChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChordMatrixListener.class) continue;
            ((ChordMatrixListener)objectArray[i + 1]).chordChanged();
        }
        if (this.selected_chord == null) {
            this.clearIndicators();
        }
    }

    protected void fireKeySignatureChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChordMatrixListener.class) continue;
            ((ChordMatrixListener)objectArray[i + 1]).keySignatureChanged();
        }
    }

    protected void capoChanged() {
        int n = this.capo_selecter.getCapo();
        if (this.capo == n) {
            return;
        }
        this.capo_key = this.key.clone();
        this.capo = n;
        this.capo_key.transpose(this.capo);
        this.selected_chord_capo = this.selected_chord == null ? null : this.selected_chord.clone().transpose(n);
        for (ChordLabel chordLabel : this.chord_labels) {
            chordLabel.keyChanged();
        }
        this.fireKeySignatureChanged();
    }

    public boolean isDragged() {
        return this.destination_chord_label != null;
    }

    public void setDarkMode(boolean bl) {
        int n;
        this.is_dark = bl;
        this.current_colorset = bl ? this.dark_mode_colorset : this.normal_mode_colorset;
        this.setBackground(this.current_colorset.focus[0]);
        Music.Key key = this.key;
        this.key = null;
        this.setKeySignature(key);
        for (n = 0; n < this.keysig_labels.length; ++n) {
            this.keysig_labels[n].setSelection();
        }
        for (n = 0; n < this.chord_labels.length; ++n) {
            this.chord_labels[n].setSelection();
        }
        this.chord_guide.setDarkMode(bl);
        this.chord_display.setDarkMode(bl);
        Color color = bl ? Color.black : null;
        this.capo_selecter.setBackground(color);
        this.capo_selecter.value_selecter.setBackground(color);
    }

    public void setPlaying(boolean bl) {
        this.is_playing = bl;
        this.repaint();
    }

    public boolean isPlaying() {
        return this.is_playing;
    }

    public void setBeat(byte by, byte by2) {
        if (this.current_beat == by && this.timesig_upper == by2) {
            return;
        }
        this.timesig_upper = by2;
        this.current_beat = by;
        this.keysig_labels[this.key.toCo5() + 12].repaint();
    }

    public void note(int n, boolean bl, int n2) {
        int n3 = bl ? 1 : -1;
        ChordLabelSelections chordLabelSelections = this.chord_label_selections[Music.mod12(n2)];
        if (n2 < 49) {
            chordLabelSelections.addBassWeight(n3);
        } else {
            chordLabelSelections.addWeight(n3);
        }
    }

    public void clearIndicators() {
        for (int i = 0; i < this.chord_label_selections.length; ++i) {
            this.chord_label_selections[i].clearWeight();
        }
        this.repaint();
    }

    public void addChordMatrixListener(ChordMatrixListener chordMatrixListener) {
        this.listenerList.add(ChordMatrixListener.class, chordMatrixListener);
    }

    public void removeChordMatrixListener(ChordMatrixListener chordMatrixListener) {
        this.listenerList.remove(ChordMatrixListener.class, chordMatrixListener);
    }

    public Music.Key getKeySignature() {
        return this.key;
    }

    public Music.Key getKeySignatureCapo() {
        return this.capo_key;
    }

    public void setKeySignature(Music.Key key) {
        int n;
        if (key == null || this.key != null && key.equals(this.key)) {
            return;
        }
        if (this.key == null) {
            for (n = 0; n < this.keysig_labels.length; ++n) {
                this.keysig_labels[n].setBackground(false);
            }
        } else {
            this.keysig_labels[this.key.toCo5() + 12].setSelection(false);
            for (n = Music.mod12(this.key.toCo5()); n < 25; n += 12) {
                this.keysig_labels[n].setBackground(false);
            }
        }
        n = key.toCo5() + 12;
        this.keysig_labels[n].setSelection(true);
        for (n = Music.mod12(key.toCo5()); n < 25; n += 12) {
            this.keysig_labels[n].setBackground(true);
        }
        for (ChordLabel chordLabel : this.chord_labels) {
            int n2 = (chordLabel.co5_value - key.toCo5() + 31) / 3 & 3;
            if (this.key != null) {
                int n3 = (chordLabel.co5_value - this.key.toCo5() + 31) / 3 & 3;
                if (n2 != n3) {
                    chordLabel.setBackground(n2);
                }
            } else {
                chordLabel.setBackground(n2);
            }
            if (chordLabel.is_sus4) continue;
            if (this.key != null && Music.mod12(chordLabel.co5_value - this.key.toCo5()) == 0) {
                chordLabel.setBold(false);
            }
            if (Music.mod12(chordLabel.co5_value - key.toCo5()) != 0) continue;
            chordLabel.setBold(true);
        }
        this.key = key;
        this.capo_key = this.key.clone().transpose(this.capo_selecter.getCapo());
        for (ChordLabel chordLabel : this.chord_labels) {
            chordLabel.keyChanged();
        }
        this.fireKeySignatureChanged();
    }

    public JComponent getSelectedButton() {
        return this.selected_chord_label;
    }

    public Music.Chord getSelectedChord() {
        return this.selected_chord;
    }

    public Music.Chord getSelectedChordCapo() {
        return this.selected_chord_capo;
    }

    public void setSelectedChordCapo(Music.Chord chord) {
        this.setNoteIndex(-1);
        this.selected_chord = chord == null ? null : chord.clone().transpose(-this.capo, this.capo_key);
        this.selected_chord_capo = chord;
        this.fireChordChanged();
    }

    public void setSelectedChord(Music.Chord chord) {
        this.setNoteIndex(-1);
        this.selected_chord = chord;
        this.selected_chord_capo = chord == null ? null : chord.clone().transpose(this.capo, this.key);
        this.fireChordChanged();
    }

    public void setSelectedChord(String string) {
        Music.Chord chord = null;
        if (string != null && !string.isEmpty()) {
            try {
                chord = new Music.Chord(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setSelectedChord(chord);
    }

    public int getNoteIndex() {
        return this.selected_chord == null || this.selected_note_index < 0 ? -1 : this.selected_note_index;
    }

    public void setNoteIndex(int n) {
        this.selected_note_index = n;
    }

    public void clear() {
        if (this.selected_chord_label != null) {
            this.selected_chord_label.setSelection(false);
            this.selected_chord_label = null;
        }
        this.selected_chord = null;
        this.selected_note_index = -1;
    }

    class ChordLabel
    extends JLabel {
        public byte check_bits = 0;
        public int co5_value;
        public boolean is_minor;
        public boolean is_sus4;
        public boolean is_selected = false;
        public Music.Chord chord;
        private boolean in_active_zone = true;
        private Font bold_font;
        private Font plain_font;
        private int[] indicator_color_indices = new int[5];
        private byte indicator_bits = 0;

        public ChordLabel(Music.Chord chord) {
            String string;
            this.chord = chord;
            this.is_minor = chord.isMinor();
            this.is_sus4 = chord.isSus4();
            this.co5_value = chord.rootNoteSymbol().toCo5();
            if (this.is_minor) {
                this.co5_value -= 3;
            }
            String string2 = string = this.is_sus4 ? chord.symbolSuffix() : chord.toString();
            if (this.is_minor && string.length() > 3) {
                float f = this.getFont().getSize2D() - 2.0f;
                this.bold_font = this.getFont().deriveFont(1, f);
                this.plain_font = this.getFont().deriveFont(0, f);
            } else {
                this.bold_font = this.getFont().deriveFont(1);
                this.plain_font = this.getFont().deriveFont(0);
            }
            this.setOpaque(true);
            this.setBackground(0);
            this.setForeground(ChordMatrix.this.current_colorset.foregrounds[0]);
            this.setBold(false);
            this.setHorizontalAlignment(0);
            this.setText(string);
            this.setToolTipText("Chord: " + chord.toName());
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Dimension dimension = this.getSize();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = null;
            if (!this.in_active_zone) {
                graphics2D.setColor(Color.gray);
            }
            if ((this.indicator_bits & 0x20) != 0) {
                if (this.in_active_zone) {
                    color = ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[1]];
                    graphics2D.setColor(color);
                }
                graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics2D.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
            }
            if ((this.indicator_bits & 1) != 0) {
                if (this.in_active_zone) {
                    color = ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[0]];
                    graphics2D.setColor(color);
                }
                graphics2D.drawLine(0, 0, 0, dimension.height - 1);
                graphics2D.drawLine(2, 2, 2, dimension.height - 3);
            }
            if ((this.indicator_bits & 0x40) != 0) {
                if (this.in_active_zone) {
                    color = ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[0]];
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(6, dimension.height - 7, dimension.width - 12, 2);
            }
            if ((this.indicator_bits & 4) != 0) {
                if (this.in_active_zone) {
                    color = ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[2]];
                    graphics2D.setColor(color);
                }
                graphics2D.drawLine(dimension.width - 1, dimension.height * 3 / 4, dimension.width - 1, dimension.height - 1);
                graphics2D.drawLine(dimension.width - 3, dimension.height * 3 / 4, dimension.width - 3, dimension.height - 3);
            }
            if ((this.indicator_bits & 2) != 0) {
                if (this.in_active_zone) {
                    color = ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[1]];
                    graphics2D.setColor(color);
                }
                graphics2D.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics2D.drawLine(2, dimension.height - 3, dimension.width - 3, dimension.height - 3);
            }
            if ((this.indicator_bits & 8) != 0) {
                if (this.in_active_zone) {
                    graphics2D.setColor(ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[3]]);
                }
                graphics2D.drawOval(1, 1, dimension.width - 2, dimension.height - 2);
            }
            if ((this.indicator_bits & 0x10) != 0) {
                if (this.in_active_zone) {
                    graphics2D.setColor(ChordMatrix.this.current_colorset.indicators[this.indicator_color_indices[4]]);
                }
                graphics2D.drawLine(1, 3, dimension.width - 3, 3);
                graphics2D.drawLine(1, 4, dimension.width - 3, 4);
                graphics2D.drawLine(dimension.width / 2 - 1, 0, dimension.width / 2 - 1, 7);
                graphics2D.drawLine(dimension.width / 2, 0, dimension.width / 2, 7);
            }
        }

        public void clearCheckBit() {
            this.indicator_bits = 0;
            this.check_bits = 0;
        }

        public void setCheckBit(boolean bl, int n) {
            byte by = (byte)(1 << n);
            byte by2 = this.check_bits;
            this.check_bits = bl ? (byte)(this.check_bits | by) : (byte)(this.check_bits & ~by);
            if (by2 == this.check_bits) {
                return;
            }
            byte by3 = 0;
            if ((this.check_bits & 1) != 0) {
                if ((this.check_bits & 7) == 7) {
                    by3 = (byte)(by3 | 0x20);
                    if (this.indicator_color_indices[0] != this.indicator_color_indices[1]) {
                        by3 = (byte)(by3 | 1);
                    }
                    if (this.indicator_color_indices[2] != this.indicator_color_indices[1]) {
                        by3 = (byte)(by3 | 4);
                    }
                } else if (!this.is_sus4) {
                    by3 = (byte)(by3 | 5);
                    if (!((this.check_bits & 2) == 0 || this.is_minor && (this.check_bits & 0x18) == 0)) {
                        by3 = (byte)(by3 | 2);
                    }
                }
                if (!this.is_sus4) {
                    if (this.is_minor || (this.check_bits & 2) != 0) {
                        by3 = (byte)(by3 | (byte)(this.check_bits & 0x18));
                    }
                    if ((this.check_bits & 0x40) != 0) {
                        by3 = (byte)(by3 | 0x40);
                    }
                }
            }
            if (this.indicator_bits == by3) {
                return;
            }
            this.indicator_bits = by3;
            this.repaint();
        }

        public void setBackground(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    super.setBackground(ChordMatrix.this.current_colorset.backgrounds[n]);
                    this.setOpaque(true);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void setSelection(boolean bl) {
            this.is_selected = bl;
            this.setSelection();
        }

        public void setSelection() {
            this.setForeground(ChordMatrix.this.current_colorset.foregrounds[this.is_selected ? 1 : 0]);
        }

        public void setBold(boolean bl) {
            this.setFont(bl ? this.bold_font : this.plain_font);
        }

        public void keyChanged() {
            int n = ChordMatrix.this.capo_key.toCo5();
            int n2 = this.co5_value - n;
            this.in_active_zone = n2 <= 6 && n2 >= -6;
            int n3 = this.chord.rootNote();
            int n4 = Music.isOnScale(n3, n) ? 0 : (this.indicator_color_indices[0] = n2 > 0 ? 1 : 2);
            int n5 = Music.isOnScale(n3 + (this.is_minor ? 3 : (this.is_sus4 ? 5 : 4)), n) ? 0 : (this.indicator_color_indices[1] = n2 > 0 ? 1 : 2);
            int n6 = Music.isOnScale(n3 + 7, n) ? 0 : (this.indicator_color_indices[2] = n2 > 0 ? 1 : 2);
            int n7 = Music.isOnScale(n3 + 6, n) ? 0 : (this.indicator_color_indices[3] = n2 > 4 ? 1 : 2);
            this.indicator_color_indices[4] = Music.isOnScale(n3 + 8, n) ? 0 : (n2 > -3 ? 1 : 2);
        }
    }

    class Co5Label
    extends JLabel {
        public boolean is_selected = false;
        public int co5_value = 0;
        private Color indicator_color;

        public Co5Label(int n) {
            this.co5_value = n;
            Music.Key key = new Music.Key(this.co5_value);
            this.setOpaque(true);
            this.setBackground(false);
            this.setForeground(ChordMatrix.this.current_colorset.foregrounds[0]);
            this.setHorizontalAlignment(0);
            String string = "Key signature: ";
            if (n != key.toCo5()) {
                string = string + "out of range";
            } else {
                string = string + key.signatureDescription() + " " + key.toStringIn(2);
                if (n == 0) {
                    this.setIcon(new ButtonIcon(13));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(key.signature());
                }
            }
            this.setToolTipText(string);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Dimension dimension = this.getSize();
            if (ChordMatrix.this.isFocusOwner() && this.is_selected) {
                graphics.setColor(ChordMatrix.this.current_colorset.focus[1]);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            if (!this.is_selected || !ChordMatrix.this.is_playing || ChordMatrix.this.current_beat + 1 == ChordMatrix.this.timesig_upper) {
                return;
            }
            if (ChordMatrix.this.current_beat == 0) {
                graphics.setColor(this.indicator_color);
                graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
                graphics.setColor(ChordMatrix.this.is_dark ? this.indicator_color.darker() : this.indicator_color.brighter());
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                return;
            }
            Color color = ChordMatrix.this.current_colorset.indicators[0];
            graphics.setColor(color);
            if (ChordMatrix.this.current_beat == 1) {
                graphics.drawLine(2, dimension.height - 3, dimension.width - 3, dimension.height - 3);
                graphics.drawLine(dimension.width - 3, dimension.height * 3 / 4, dimension.width - 3, dimension.height - 3);
                graphics.drawLine(2, 2, 2, dimension.height - 3);
                graphics.setColor(ChordMatrix.this.is_dark ? color.darker() : color.brighter());
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, dimension.height * 3 / 4, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(0, 0, 0, dimension.height - 1);
            } else {
                int n = (dimension.height - 1) * (ChordMatrix.this.current_beat - 1) / (ChordMatrix.this.timesig_upper - 2);
                graphics.drawLine(2, n == 0 ? 2 : n, 2, dimension.height - 3);
                graphics.setColor(ChordMatrix.this.is_dark ? color.darker() : color.brighter());
                graphics.drawLine(0, n, 0, dimension.height - 1);
            }
        }

        public void setBackground(boolean bl) {
            super.setBackground(ChordMatrix.this.current_colorset.backgrounds[bl ? 2 : 0]);
            this.setIndicatorColor();
            this.setOpaque(true);
        }

        public void setSelection(boolean bl) {
            this.is_selected = bl;
            this.setSelection();
        }

        public void setSelection() {
            this.setForeground(ChordMatrix.this.current_colorset.foregrounds[this.is_selected ? 1 : 0]);
        }

        public void setIndicatorColor() {
            this.indicator_color = this.co5_value < 0 ? ChordMatrix.this.current_colorset.indicators[2] : (this.co5_value > 0 ? ChordMatrix.this.current_colorset.indicators[1] : ChordMatrix.this.current_colorset.foregrounds[1]);
        }
    }

    class ChordLabelSelections {
        int note_no;
        int weight = 0;
        int bass_weight = 0;
        boolean is_active = false;
        boolean is_bass_active = false;
        private ChordLabelSelection[] acls;

        public ChordLabelSelections(int n, ArrayList<ChordLabelSelection> arrayList) {
            this.note_no = n;
            this.acls = arrayList.toArray(new ChordLabelSelection[arrayList.size()]);
        }

        void addWeight(int n) {
            if ((this.weight += n) < 0) {
                this.weight = 0;
            }
            if (this.weight > 0 != this.is_active) {
                this.is_active = !this.is_active;
                for (ChordLabelSelection chordLabelSelection : this.acls) {
                    chordLabelSelection.setCheckBit(this.is_active);
                }
            }
        }

        void addBassWeight(int n) {
            if ((this.bass_weight += n) < 0) {
                this.bass_weight = 0;
            }
            if (this.bass_weight > 0 != this.is_bass_active) {
                this.is_bass_active = !this.is_bass_active;
                for (ChordLabelSelection chordLabelSelection : this.acls) {
                    if (!chordLabelSelection.setBassCheckBit(this.is_bass_active)) break;
                }
            }
            this.addWeight(n);
        }

        void clearWeight() {
            this.bass_weight = 0;
            this.weight = 0;
            this.is_bass_active = false;
            this.is_active = false;
            for (ChordLabelSelection chordLabelSelection : this.acls) {
                chordLabelSelection.setCheckBit(false);
                chordLabelSelection.setBassCheckBit(false);
            }
        }
    }

    class ChordLabelSelection {
        ChordLabel chord_label;
        int bit_index;
        boolean is_sus4;

        public ChordLabelSelection(ChordLabel chordLabel, int n) {
            this.chord_label = chordLabel;
            this.bit_index = n;
            this.is_sus4 = chordLabel.is_sus4;
        }

        public void setCheckBit(boolean bl) {
            this.chord_label.setCheckBit(bl, this.bit_index);
        }

        public boolean setBassCheckBit(boolean bl) {
            if (this.bit_index == 0 && !this.is_sus4) {
                this.chord_label.setCheckBit(bl, 6);
                return true;
            }
            return false;
        }
    }

    class ColorSet {
        boolean is_dark = false;
        Color[] focus = new Color[2];
        Color[] foregrounds = new Color[2];
        Color[] backgrounds = new Color[4];
        Color[] indicators = new Color[3];

        public ColorSet() {
            this(false);
        }

        public ColorSet(boolean bl) {
            this.is_dark = bl;
        }
    }
}

