/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;

public class ChordDiagram
extends JPanel {
    public CapoSelecter capo_selecter;
    public JToggleButton record_text_button;
    private static final String DEFAULT_TITLE = "Chord Diagram";
    private Insets zero_insets = new Insets(0, 0, 0, 0);
    private int[] UKULELE_OPEN_NOTES = new int[]{9, 4, 0, 7};
    private int[] GUITAR_OPEN_NOTES = new int[]{4, 11, 7, 2, 9, 4};
    private ChordDiagramDisplay diagram_display;
    private JRadioButton ukulele_button;
    private JRadioButton guitar_button;
    private ButtonGroup ukulele_guitar_group = new ButtonGroup();
    public ChordDisplay title_label;
    private JScrollBar fret_range_scrollbar;
    private JScrollBar variation_scrollbar;
    private JPanel inner_panel = new JPanel();
    private JPanel main_panel = new JPanel();

    public ChordDiagram(ChordHelperApplet chordHelperApplet) {
        boolean bl = false;
        this.title_label = new ChordDisplay(DEFAULT_TITLE, null, null);
        this.title_label.setHorizontalAlignment(0);
        this.title_label.setVerticalAlignment(3);
        JPanel jPanel = new JPanel();
        jPanel.add(this.title_label);
        jPanel.setOpaque(false);
        this.ukulele_button = new JRadioButton("Ukulele", !bl);
        this.ukulele_guitar_group.add(this.ukulele_button);
        this.guitar_button = new JRadioButton("Guitar", bl);
        this.ukulele_guitar_group.add(this.guitar_button);
        this.ukulele_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordDiagram.this.diagram_display.tune(ChordDiagram.this.UKULELE_OPEN_NOTES);
                ChordDiagram.this.title_label.setText(null);
                ChordDiagram.this.title_label.setChord(ChordDiagram.this.diagram_display.getChord());
            }
        });
        this.ukulele_button.setOpaque(false);
        this.guitar_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChordDiagram.this.diagram_display.tune(ChordDiagram.this.GUITAR_OPEN_NOTES);
                ChordDiagram.this.title_label.setText(null);
                ChordDiagram.this.title_label.setChord(ChordDiagram.this.diagram_display.getChord());
            }
        });
        this.guitar_button.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.add(this.ukulele_button);
        jPanel2.add(this.guitar_button);
        this.diagram_display = new ChordDiagramDisplay(this.UKULELE_OPEN_NOTES);
        this.diagram_display.setOpaque(false);
        this.diagram_display.setPreferredSize(new Dimension(120, 120));
        this.variation_scrollbar = new JScrollBar(1);
        this.variation_scrollbar.setModel(this.diagram_display.chord_variations.model);
        this.variation_scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                ChordDiagram.this.showVariationStatus();
            }
        });
        this.fret_range_scrollbar = new JScrollBar(0);
        this.fret_range_scrollbar.setModel(this.diagram_display.fret_range_model);
        this.fret_range_scrollbar.setBlockIncrement(this.diagram_display.fret_range_model.getExtent());
        this.record_text_button = new JToggleButton("REC", new ButtonIcon(1));
        this.record_text_button.setMargin(this.zero_insets);
        this.record_text_button.setToolTipText("Record to text ON/OFF");
        this.capo_selecter = new CapoSelecter(chordHelperApplet.chord_matrix.capo_value_model);
        this.capo_selecter.checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ChordDiagram.this.clear();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setOpaque(false);
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel3.add(this.record_text_button);
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel3.add(this.capo_selecter);
        this.inner_panel.setLayout(new BoxLayout(this.inner_panel, 1));
        this.inner_panel.setOpaque(false);
        jPanel.setAlignmentY(0.0f);
        this.inner_panel.add(jPanel);
        this.inner_panel.add(this.diagram_display);
        this.fret_range_scrollbar.setAlignmentY(1.0f);
        this.inner_panel.add(this.fret_range_scrollbar);
        jPanel2.setAlignmentY(1.0f);
        this.inner_panel.add(jPanel2);
        this.main_panel.setLayout(new BoxLayout(this.main_panel, 0));
        this.main_panel.setOpaque(false);
        this.main_panel.add(this.inner_panel);
        this.main_panel.add(this.variation_scrollbar);
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel3);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.main_panel);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.diagram_display == null) {
            return;
        }
        this.diagram_display.setBackground(color);
        this.capo_selecter.setBackground(color);
        this.capo_selecter.value_selecter.setBackground(color);
        this.variation_scrollbar.setBackground(color);
        this.fret_range_scrollbar.setBackground(color);
    }

    public void showVariationStatus() {
        String string = null;
        if (this.diagram_display.getChord() != null) {
            DefaultBoundedRangeModel defaultBoundedRangeModel = this.diagram_display.chord_variations.model;
            int n = defaultBoundedRangeModel.getValue();
            int n2 = defaultBoundedRangeModel.getMaximum();
            if (n < 0) {
                switch (n2) {
                    case 0: {
                        string = "No variation found";
                        break;
                    }
                    case 1: {
                        string = "1 variation found";
                        break;
                    }
                    default: {
                        string = n2 + " variations found";
                        break;
                    }
                }
            } else {
                string = "Variation: " + (n + 1) + " / " + n2;
            }
        }
        this.variation_scrollbar.setToolTipText(string);
    }

    public Music.Chord getChord() {
        return this.diagram_display.getChord();
    }

    public void setChord(Music.Chord chord) {
        if (!this.isVisible()) {
            this.clear();
            return;
        }
        this.diagram_display.setChord(chord);
        this.title_label.setChord(chord);
    }

    public void clear() {
        this.diagram_display.setChord(null);
        this.title_label.setChord(null);
        this.variation_scrollbar.setToolTipText(null);
    }

    public void setGuitar(boolean bl) {
        if (bl) {
            this.guitar_button.doClick();
        } else {
            this.ukulele_button.doClick();
        }
    }

    public int getCapo() {
        return this.capo_selecter.getCapo();
    }
}

