/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

abstract class AbstractMidiStatus
extends Vector<AbstractMidiChannelStatus>
implements Receiver {
    AbstractMidiStatus() {
    }

    private void resetStatus() {
        this.resetStatus(false);
    }

    private void resetStatus(boolean bl) {
        for (AbstractMidiChannelStatus abstractMidiChannelStatus : this) {
            abstractMidiChannelStatus.resetAllValues(bl);
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(MidiMessage midiMessage, long l) {
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            switch (shortMessage.getCommand()) {
                case 144: {
                    ((AbstractMidiChannelStatus)this.get(shortMessage.getChannel())).noteOn(shortMessage.getData1(), shortMessage.getData2());
                    return;
                }
                case 128: {
                    ((AbstractMidiChannelStatus)this.get(shortMessage.getChannel())).noteOff(shortMessage.getData1(), shortMessage.getData2());
                    return;
                }
                case 176: {
                    ((AbstractMidiChannelStatus)this.get(shortMessage.getChannel())).controlChange(shortMessage.getData1(), shortMessage.getData2());
                    return;
                }
                case 192: {
                    ((AbstractMidiChannelStatus)this.get(shortMessage.getChannel())).programChange(shortMessage.getData1());
                    return;
                }
                case 224: {
                    ((AbstractMidiChannelStatus)this.get(shortMessage.getChannel())).setPitchBend((shortMessage.getData1() & 0x7F) + ((shortMessage.getData2() & 0x7F) << 7));
                }
            }
            return;
        }
        if (!(midiMessage instanceof SysexMessage)) return;
        SysexMessage sysexMessage = (SysexMessage)midiMessage;
        block7 : switch (sysexMessage.getStatus()) {
            case 240: {
                byte[] byArray = sysexMessage.getData();
                switch (byArray[0]) {
                    case 126: {
                        if (byArray[2] != 9) return;
                        if (byArray[3] == 1) {
                            this.resetStatus();
                            break block7;
                        }
                        if (byArray[3] != 2) return;
                        this.resetStatus();
                        break block7;
                    }
                    case 65: {
                        if (byArray[2] != 66 || byArray[3] != 18) return;
                        if (byArray[4] == 64 && byArray[5] == 0 && byArray[6] == 127 && byArray[7] == 0 && byArray[8] == 65) {
                            this.resetStatus(true);
                            break block7;
                        }
                        if (byArray[4] == 64 && (byArray[5] & 0xF0) == 16 && byArray[6] == 21) {
                            boolean bl = byArray[7] == 1 || byArray[7] == 2;
                            int n = byArray[5] & 0xF;
                            if (n == 0) {
                                n = 9;
                            } else if (n <= 9) {
                                --n;
                            }
                            ((AbstractMidiChannelStatus)this.get(n)).setRhythmPart(bl);
                            break block7;
                        }
                        if (byArray[4] != 0 || byArray[5] != 0 || byArray[6] != 127) return;
                        if (byArray[7] == 0 && byArray[8] == 1) {
                            this.resetStatus(true);
                        }
                        if (byArray[7] != 1 || byArray[8] != 0) return;
                        this.resetStatus(true);
                        break block7;
                    }
                    case 67: {
                        if (byArray[2] != 76 || byArray[3] != 0 || byArray[4] != 0 || byArray[5] != 126 || byArray[6] != 0) return;
                        this.resetStatus();
                    }
                }
            }
        }
    }
}

