/*
 * Main window for MIDI Chord Helper
 */

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.event.*;

public class MidiChordHelper {
  static int count = 0;
  static AppletFrame frame = null;

  public static void main(String[] args) throws Exception {
    ChordHelperApplet applet;
    if( count++ > 0 && frame != null) {
      applet = frame.applet;
      int window_state = frame.getExtendedState();
      if( ( window_state & Frame.ICONIFIED ) == 0 ) {
        frame.toFront();
      } else {
        window_state &= ~(Frame.ICONIFIED) ;
        frame.setExtendedState( window_state );
      }
    } else {
      frame = new AppletFrame(applet = new ChordHelperApplet());
    }
    if( args.length > 0 ) {
      applet.editor_dialog.loadAndPlay(args);
    }
  }
}

class AppletFrame extends JFrame
  implements AppletStub, AppletContext
{
  JLabel status_;
  ChordHelperApplet applet = null;
  public AppletFrame(ChordHelperApplet applet) {
    setTitle(ChordHelperApplet.VersionInfo.NAME);
    (status_ = new JLabel()).setFont(
      status_.getFont().deriveFont(Font.PLAIN)
    );
    add( this.applet = applet, BorderLayout.CENTER );
    add( status_, BorderLayout.SOUTH );
    applet.setStub(this);
    applet.init();
    setIconImage(applet.image_icon.getImage());
    setDefaultCloseOperation( WindowConstants.DO_NOTHING_ON_CLOSE );
    addWindowListener( new WindowAdapter() {
      public void windowClosing(WindowEvent evt) {
        if( AppletFrame.this.applet.isConfirmedToExit() )
          System.exit(0);
      }
    });
    applet.editor_dialog.seq_list_model.addTableModelListener(
      new TableModelListener() {
        public void tableChanged(TableModelEvent e) {
          if( e.getColumn() == SequenceListModel.COLUMN_FILENAME )
            setFilenameToTitle();
        }
      }
    );
    applet.device_manager.time_range_model.addChangeListener(
      new ChangeListener() {
        public void stateChanged(ChangeEvent e) {
          setFilenameToTitle();
        }
      }
    );
    pack();
    setLocationRelativeTo(null);
    setVisible(true);
    applet.start();
  }
  private void setFilenameToTitle() {
    MidiSequenceModel seq_model
      = applet.device_manager.time_range_model.getSequenceModel();
    String filename = (
      seq_model == null ? null : seq_model.getFilename()
    );
    String title = ChordHelperApplet.VersionInfo.NAME;
    if( filename != null && ! filename.isEmpty() ) {
      title = filename + " - " + title;
    }
    setTitle(title);
  }
  //
  // AppletStub Interface
  //
  public boolean isActive() { return true; }
  public URL getDocumentBase() { return null; }
  public URL getCodeBase() { return null; }
  public String getParameter(String name) { return null; }
  public AppletContext getAppletContext() { return this; }
  public void appletResize(int width, int height) {}
  //
  // AppletContext Interface
  //
  public AudioClip getAudioClip(URL url) { return null; }
  public Image getImage(URL url) {
    return Toolkit.getDefaultToolkit().getImage(url);
  }
  public Applet getApplet(String name) { return null; }
  public Enumeration<Applet> getApplets() { return (null); }
  public void showDocument(URL url) {}
  public void showDocument(URL url, String target) {}
  public void showStatus(String status) { status_.setText(status); }
  public InputStream getStream(String key) { return null; }
  public Iterator<String> getStreamKeys() { return null; }
  public void setStream(String key, InputStream stream) throws IOException {}
}
