/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

class MidiProgramFamilySelecter
extends JComboBox
implements ActionListener {
    private MidiProgramSelecter program_selecter = null;

    public MidiProgramFamilySelecter() {
        this((MidiProgramSelecter)null);
    }

    public MidiProgramFamilySelecter(MidiProgramSelecter midiProgramSelecter) {
        this.program_selecter = midiProgramSelecter;
        this.setMaximumRowCount(17);
        this.addItem("Program:");
        for (int i = 0; i < MIDISpec.instrument_family_names.length; ++i) {
            this.addItem(i * 8 + "-" + (i * 8 + 7) + ": " + MIDISpec.instrument_family_names[i]);
        }
        this.setSelectedIndex(0);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.program_selecter == null) {
            return;
        }
        int n = this.getSelectedIndex();
        this.program_selecter.setFamily(n < 0 ? n : n - 1);
    }

    public int getProgram() {
        int n = this.getSelectedIndex();
        if (n <= 0) {
            return -1;
        }
        return (n - 1) * 8;
    }

    public String getProgramFamilyName() {
        return (String)this.getSelectedItem();
    }

    public void setProgram(int n) {
        n = n < 0 ? 0 : n / 8 + 1;
        this.setSelectedIndex(n);
    }
}

