/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class MidiChannelButtonSelecter
extends JList {
    private PianoKeyboard keyboard = null;

    public MidiChannelButtonSelecter(MidiChannelComboBoxModel midiChannelComboBoxModel) {
        super(midiChannelComboBoxModel);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(1);
        this.setCellRenderer(new MyCellRenderer());
        this.setSelectedIndex(midiChannelComboBoxModel.getSelectedChannel());
        midiChannelComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                MidiChannelButtonSelecter.this.setSelectedIndex(MidiChannelButtonSelecter.this.getModel().getSelectedChannel());
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MidiChannelButtonSelecter.this.getModel().setSelectedChannel(MidiChannelButtonSelecter.this.getSelectedIndex());
            }
        });
    }

    public MidiChannelButtonSelecter(PianoKeyboard pianoKeyboard) {
        this(pianoKeyboard.midi_ch_combobox_model);
        this.setPianoKeyboard(pianoKeyboard);
    }

    public MidiChannelComboBoxModel getModel() {
        return (MidiChannelComboBoxModel)super.getModel();
    }

    public void setPianoKeyboard(PianoKeyboard pianoKeyboard) {
        this.keyboard = pianoKeyboard;
        pianoKeyboard.midi_ch_button_selecter = this;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean cellHasFocus = false;

        public MyCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            MidiChannelButtonSelecter.this.setSelectionBackground(Color.yellow);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.cellHasFocus = bl2;
            this.setText(object.toString());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(MidiChannelButtonSelecter.this.keyboard != null && MidiChannelButtonSelecter.this.keyboard.countKeyOn(n) > 0 ? Color.pink : jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.cellHasFocus) {
                graphics.setColor(Color.gray);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

