library ieee;
use ieee.std_logic_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity hoge is
end hoge;

use work.counter;

architecture behavior of hoge is

  component counter
    port (
      pClk   : in std_logic;
      pReset : in std_logic;
      pOutput : out std_logic_vector(10 downto 0)
      );
  end component;

  signal clk    : std_logic := '0';
  signal reset  : std_logic := '1';
  signal output : std_logic_vector(10 downto 0);

begin

  u0 : counter port map (
    pClk   => clk,
    pReset => reset,
    pOutput => output
    );

  clk <= not clk after 20 ns;
  reset <= '0' after 40 ns;

end behavior;
