library ieee;
library work;
use ieee.std_logic_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity counter is
  port (
    pClk   : in std_logic;
    pReset : in std_logic;
    pOutput : out std_logic_vector(10 downto 0)
    );
end counter;

architecture rtl of counter is

  signal counter : std_logic_vector(20 downto 0);

begin  -- rtl

  pOutput <= counter(20 downto 10);
  
  process (pClk, pReset)
  begin  -- process
    if pReset = '1' then                -- asynchronous reset (active low)
      counter <= (others => '0');
    elsif pClk'event and pClk = '1' then  -- rising clock edge
      counter <= counter + 1;
    end if;
  end process;
  
end rtl;
