package net.wasamon.wallet.preprocessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;



public class PreProcessor {

	private Hashtable<String, String> defineTable;
	private ArrayList includeList = new ArrayList();
	private File baseDir;

	private IfStack ifStack = new IfStack();

	public PreProcessor() {
		defineTable = new Hashtable();
	}
	
	private PrintStream out;

	private Pattern patternDefineWithArg = Pattern.compile("^.+\\((.+)\\)");
	
    public void go(File src, InputStream in, OutputStream out) throws PreProcessorException {
		this.out = new PrintStream(out, true);
		if(src != null){
			baseDir = src.getParentFile();
		}else{
			baseDir = new File(".");
		}
		try{
		BufferedReader reader = new BufferedReader(new InputStreamReader(in, "EUC-JP"));

		String line = "";
		String s;
		while ((s = reader.readLine()) != null) {
			line += s + "\n";
		}

		PreProcessorParser.LexicalAnalyzer a = new PreProcessorParser.Default.LexicalAnalyzer(
				"test", line, 8);
		PARSE_LOOP: while (true) {
			PreProcessorParser.Token token = a.next();
			boolean flag = false;
			String str = "";
			TOKEN_SWITCH: switch (token.getSymbolID()) {
			case PreProcessorParser.TOKEN_IDENTIFIER:
				if (defineTable.containsKey(token.getImage())) {
					String value = defineTable.get(token.getImage());
					Matcher m = patternDefineWithArg.matcher(value);
					if(m.matches()){
					  //System.err.println("with arguments: " + m.group(1));
					}
					str = value;
				} else {
					str = token.getImage();
				}
				break TOKEN_SWITCH;
			case PreProcessorParser.EOF_TOKEN:
				break PARSE_LOOP;
			case PreProcessorParser.TOKEN_COMMENT:
				str = "";
				break TOKEN_SWITCH;
			case PreProcessorParser.TOKEN_CXXCOMMENT:
				str = "\n";
				break TOKEN_SWITCH;
			case PreProcessorParser.TOKEN_DIRECTIVE:
				doDirectiveOperation(token.getImage(), a);
				str = "\n";
				break TOKEN_SWITCH;
			default:
				str = token.getImage();
			}
			if (ifStack.status) {
				this.out.print(str);
			} else if (str.equals("\n")) {
				this.out.println(str);
			}
		}
		}catch(IOException e){
			throw new PreProcessorException(e);
		}catch(PreProcessorParser.ParseException e){
			throw new PreProcessorException(e);
		}
	}

	private void doDirectiveOperation(String key,
			PreProcessorParser.LexicalAnalyzer a) throws PreProcessorException {
		try {
			ArrayList<String> args = new ArrayList<String>();
			PARSE_ARGS: for (;;) {
				PreProcessorParser.Token token = a.next();
				TOKEN_SWITCH: switch (token.getSymbolID()) {
				case PreProcessorParser.EOF_TOKEN:
				case PreProcessorParser.TOKEN_NEW_LINE:
				case PreProcessorParser.TOKEN_CXXCOMMENT:
					break PARSE_ARGS;
				case PreProcessorParser.TOKEN_SPACE:
				default:
					args.add(token.getImage());
				}
			}
			key = key.substring(1).trim();
			if (key.equals("define")) {
				doDefineOperation(args.toArray(new String[args.size()]));
			} else if (key.equals("ifdef")) {
				doIfDefOperation(args.toArray(new String[args.size()]), true);
			} else if (key.equals("ifndef")) {
				doIfDefOperation(args.toArray(new String[args.size()]), false);
			} else if (key.equals("endif")) {
				ifStack.pop();
			} else if (key.equals("include")) {
				doIncludeOperation(args.toArray(new String[args.size()]));
			} else {
				System.err.println("unsupported directive: " + key);
			}
		} catch (PreProcessorParser.ParseException e) {
			throw new PreProcessorException(e);
		}
	}

	public void doIncludeOperation(String[] args) throws PreProcessorException {
		String filename = args[0].substring(1, args[0].length() - 1);
		if (args[0].charAt(0) == '"') {

		} else if (args[0].charAt(0) == '<') {

		} else {
			throw new PreProcessorException("syntax error: #include " + args[0]);
		}
		File includeFile = new File(baseDir, filename);
		if (includeFile.exists() == false) {
			System.err.println("file not found: " + includeFile.getName());
			throw new PreProcessorException("syntax error: #include " + args[0]);
		}
		File originalBaseDir = this.baseDir;
		try{
			go(includeFile, new FileInputStream(includeFile), this.out);
		}catch(FileNotFoundException e){
			throw new PreProcessorException(e);
		}
		this.baseDir = originalBaseDir;
		includeList.add(args[0]);
	}

	private void doDefineOperation(String[] args) {
		String value = "";
		/*
		for(String s: args){
			System.err.print(" `" + s + "'");
		}
		System.err.println();
		*/
		for (int i = 1; i < args.length; i++) {
			value += args[i];
		}
		defineTable.put(args[0], value);
	}

	private void doIfDefOperation(String[] args, boolean flag) {
		String key = args[0];
		ifStack.push((defineTable.containsKey(key) == flag));
	}

	class IfStack {

		ArrayList<Boolean> stack = new ArrayList<Boolean>();
		boolean status = true;

		public IfStack() {

		}

		public void push(boolean flag) {
			stack.add(new Boolean(flag));
			if (flag == false) {
				status = false;
			}
		}

		public boolean pop() {
			boolean f = stack.get(stack.size() - 1).booleanValue();
			stack.remove(stack.size() - 1);
			status = true;
			for (Boolean b : stack) {
				if (b.booleanValue() == false) {
					status = false;
					break;
				}
			}
			return f;
		}

	}

	public static void main(String[] args) throws Exception {
		if (args.length > 0) {
			File f = new File(args[0]);
			new PreProcessor().go(f, new FileInputStream(f), System.out);
		} else {
			new PreProcessor().go(null, System.in, System.out);
		}
	}
}