/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet.binutils.simpleprocessor;

import java.util.Hashtable;

import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.InstructionTable;
import net.wasamon.wallet.binutils.UnknownInstructionException;

public class SimpleProcessor32InstructionTable implements InstructionTable{

	private static String[] defautlBootStrap = {
		".section \".text\"",
		"nop", // 割り込み領域
		"nop",
		"nop",
		"nop",
		"nop",
		"nop",
		"nop",
		"nop",
		// ここから、プログラム開始
		"movi	r29," + DataUtil.parseInt("0x7000"), // スタックポインタ
		"mov	r30,r29",
		"calli	_main",
		"halt",
	};
	
	private static SimpleProcessor32InstructionTable instance = new SimpleProcessor32InstructionTable();
	public static SimpleProcessor32InstructionTable getInstance() {
		return instance;
	}

	private Hashtable instTable;

	private SimpleProcessor32InstructionTable() {
		initInstTable();
	}

	private void instTablePut(String label, int code){
		instTable.put(label, new Integer(code));
	}
	
	private void initInstTable() {
		instTable = new Hashtable();
		instTablePut("HALT", 0x00);
		instTablePut("NOP", 0x01);
		instTablePut("ADD", 0x10);
		instTablePut("SUB", 0x11);
		instTablePut("MULT", 0x12);
		instTablePut("DIV", 0x13);
		instTablePut("ADDI", 0x14);
		instTablePut("SUBI", 0x15);
		instTablePut("MOD", 0x16);
		instTablePut("LSHS", 0x17);
		instTablePut("RSHS", 0x18);
		instTablePut("NEG", 0x19);
		instTablePut("OR", 0x20);
		instTablePut("AND", 0x21);
		instTablePut("JMP", 0x30);
		instTablePut("JMPI", 0x31);
		instTablePut("JCC", 0x32);
		instTablePut("JCCI", 0x33);
		instTablePut("EQ", 0x40);
		instTablePut("NEQ", 0x41);
		instTablePut("LT", 0x42);
		instTablePut("GT", 0x43);
		instTablePut("LEQ", 0x44);
		instTablePut("GEQ", 0x45);
		instTablePut("MOV", 0x50);
		instTablePut("MOVI", 0x51);
		instTablePut("MOVIL", 0x52);
		instTablePut("MOVIH", 0x53);
		instTablePut("POP", 0x60);
		instTablePut("PUSH", 0x61);
		instTablePut("CALL", 0x64);
		instTablePut("CALLI", 0x65);
		instTablePut("RET", 0x66);
		instTablePut("LDA", 0x67);
		instTablePut("STA", 0x68);
		instTablePut("LDR", 0x80);
		instTablePut("STR", 0x81);
		instTablePut("LDR8", 0x82);
		instTablePut("STR8", 0x83);
		instTablePut("LDR32", 0x84);
		instTablePut("STR32", 0x85);
		instTablePut("LDRF", 0x86);
		instTablePut("SIN", 0x90);
		instTablePut("COS", 0x91);
		instTablePut("SINF", 0x92);
		instTablePut("COSF", 0x93);
		instTablePut("SQRT", 0x94);
		instTablePut("SQRTF", 0x95);
	}

	public int toInstructionCode(String str) throws UnknownInstructionException {
		if(instTable.containsKey(str)){
			return ((Integer)(instTable.get(str))).intValue();
		}else{
			throw new UnknownInstructionException("unknown instruction " + str);
		}
	}
	
	public String[] getDefaultBootStrap(){
		return defautlBootStrap;
	}

}
