package net.wasamon.wallet.binutils.data;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;


public class Section implements LinkerElement{
	
	String _name;
	
	int offset;
	
	LocalSymbolTable symtab;
	
	String _type;
	
	/**
	 * ProgramCode��i�[����R���N�V����
	 */
	ArrayList codes; 
	
	public Section(){
		symtab = new LocalSymbolTable();
		codes = new ArrayList();
	}
	
	public void addProgramCode(ProgramCode code){
		codes.add(code);
	}
	
	public ProgramCode getProgramCode(int index){
		return (ProgramCode)(codes.get(index));
	}
	
	public int size(){
		return codes.size();
	}

	public void setOffset(int offset){
		this.offset = offset;
	}
	
	public int getOffset(){
		return offset;
	}
	
	public void output(OutputStream out) throws IOException{
		Iterator i = codes.iterator();
		while(i.hasNext()){
			ProgramCode code = (ProgramCode)(i.next());
			code.output(out);
		}
	}

}
