/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */
package net.wasamon.wallet.binutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;

import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

public class SimpleLinker implements Linker{

	//ArrayList<ObjectData> data;
	ArrayList data;
	
	public SimpleLinker(){
		data = new ArrayList();
	}
	
	public void doLink(InstructionTable inst, File[] sources, OutputStream out) throws IOException{
		try{
			readObjectData(sources);
			allocate(data);
			outputDataStream(inst, out, data);
		}catch(AssemblerException e){
			throw new IOException(e.getMessage());
		}catch(XMLParserException e){
			throw new IOException(e.getMessage());
		}
	}
	
	public void setBootStrap(Reader reader) throws IOException, AssemblerException{
		AssemblerDriver asm = new AssemblerDriver(new SimpleAssembler());
		asm.doParse(reader);
		data.add(asm.data);
	}
	
	private void readObjectData(File[] sources) throws XMLParserException{
		for(int i = 0; i < sources.length; i++){
			File source = sources[i];
			Node top = XMLParser.getTopNode(source);
			data.add(ObjectData.readFromXML(top));
		}
	}
	
	private void allocate(ArrayList data){
		int offset = 0;
		int length = data.size();
		for(int i = 0; i < length; i++){
			offset = ((ObjectData)(data.get(i))).setTextRegionOffset(offset);
		}
		for(int i = 0; i < length; i++){
			offset = ((ObjectData)(data.get(i))).setDataRegionOffset(offset);
		}
	}

	private void outputDataStream(InstructionTable inst, OutputStream out, ArrayList data) throws AssemblerException, IOException {
		int length = data.size();
		for(int i = 0; i < length; i++){
			((ObjectData)(data.get(i))).text.genByteStream(this, inst).writeTo(out);
		}
		for(int i = 0; i < length; i++){
			((ObjectData)(data.get(i))).data.genByteStream(this).writeTo(out);
		}
	}
	
	private int getValue(String key){
		int v = -1;
		int length = data.size();
		for(int i = 0; i < length; i++){
			ObjectData d = (ObjectData)(data.get(i));
			v = d.getLabelValue(key);
			if(v >= 0) break;
		}
		return v;
	}

	/** 数字の文字列を識別するパタン */
	static Pattern digitPattern = Pattern.compile("\\-?\\d+");
	/** 数字の文字列を識別するパタン */
	static Pattern hexDigitPattern = Pattern.compile("0x[0-9a-fA-F]+");
	public int toValue(String s) throws AssemblerException {
		int val = 0;
		try {
			if (s == null || s.equals("")){
				throw new AssemblerException("argument error: " + s);
			}else if (digitPattern.matcher(s).matches()) {
				val = DataUtil.parseInt(s);
			}else if (hexDigitPattern.matcher(s).matches()) {
				val = DataUtil.parseInt(s);
			}else if(s.charAt(0) == 'r'){
				val = DataUtil.parseInt(s.substring(1));
			}else if(s.charAt(0) == '_'){
				val = getValue(s);
				if(val < 0){
					throw new AssemblerException("argument error: " + s);
				}
			}else if(s.startsWith("c_") || s.startsWith("f_")){
				val = getValue(s);
				if(val < 0){
					throw new AssemblerException("argument error: " + s);
				}
			}else{
				throw new AssemblerException("argument error: " + s);
			}
		} catch (NumberFormatException e) {
			throw new AssemblerException("argument error: " + s);
		}
//		System.out.println(val);
		return val;
	}

	public static void go(File[] sources, File out, InstructionTable inst) throws IOException{
		try{
			FileOutputStream ostream = new FileOutputStream(out);
			Linker linker = new SimpleLinker();
			linker.setBootStrap(toStringReader(inst.getDefaultBootStrap()));
			linker.doLink(inst, sources, ostream);
			ostream.flush();
			ostream.close();
		}catch(AssemblerException e){
			throw new IOException(e.getMessage());
		}
	}
	
	public static StringReader toStringReader(String[] str){
		String tmp = "";
		for(int i = 0; i < str.length; i++){
			tmp += str[i] + "\n";
		}
		return new StringReader(tmp);
	}
	
}
