/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */
package net.wasamon.wallet.binutils;

import java.io.IOException;
import java.io.PrintWriter;

import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

public class ObjectData {

	public TextRegion text = new TextRegion();
	public DataRegion data = new DataRegion();
	
	public ObjectData(TextRegion text, DataRegion data){
		this.text = text;
		this.data = data;
	}
	
	public Section getSection(String key) throws AssemblerException{
		if(key.equals(".text")){
			return text;
		}else if(key.equals(".data")){
			return data;
		}else{
			throw new AssemblerException("unknown section: " + key);
		}
	}
	

	public int setTextRegionOffset(int offset){
		text.setOffset(offset);
		return offset + text.size();
	}

	public int setDataRegionOffset(int offset){
		data.setOffset(offset);
		return offset + data.size();
	}

	public static ObjectData readFromXML(Node node) throws XMLParserException{
		TextRegion text = new TextRegion();
		DataRegion data = new DataRegion();
		Node[] sections = XMLParser.getNamedNodeArray(node, "section");
		for(int i = 0; i < sections.length; i++){
			String type = XMLParser.getAttribute(sections[i], "type").getNodeValue();
			if(type.equals(".text")){
				text.inputFromXML(sections[i]);
			}else if(type.equals(".data")){
				data.inputFromXML(sections[i]);
			}
		}
		return new ObjectData(text, data);
	}
	
	public void writeAsXML(PrintWriter writer) throws IOException{
		writer.println("<section type=\".text\">");
		text.outputAsXML(writer);
		writer.println("</section>");
		writer.println("<section type=\".data\">");
		data.outputAsXML(writer);
		writer.println("</section>");
	}
	
	public int getLabelValue(String key){
		int v = -1;
		v = text.getLabelValue(key);
		if(v < 0){
			v = data.getLabelValue(key);
		}
		return v;
	}
	
}
