/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet.binutils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

public class DataRegion implements Section {
	
	private int align;
	private int count;
	private int offset;
	
	Hashtable labels = new Hashtable();

	DataElement currentElement;
	
	public DataRegion(){
	}

	public void addData(Parser parser, String value) throws AssemblerException {
		System.out.println("[??] " + value);
	}

	public void execCommand(Parser parser, String value) throws AssemblerException{
		if(value.startsWith(".align")){
			align = DataUtil.parseInt(parser.getLineArgument(value));
			currentElement = null;
		}else if(value.startsWith(".comm")){
			String[] args = parser.getArgumentItems(parser.getLineArgument(value));
			addLabel(args[0]);
			try{
				currentElement.data.write(DataUtil.toByteArray(0));
			}catch(IOException e){
				throw new AssemblerException(e.getMessage());
			}
			count += DataUtil.parseInt(args[1]);
			currentElement.length = DataUtil.parseInt(args[1]); 
		}else if(value.startsWith(".byte")){
			currentElement.data.write((byte)DataUtil.parseInt(parser.getLineArgument(value)));
			count += 1;
			currentElement.length += 1;
		}else if(value.startsWith(".long")){
			try{
				currentElement.data.write(DataUtil.toByteArray(DataUtil.parseInt(parser.getLineArgument(value))));
			}catch(IOException e){
				throw new AssemblerException(e.getMessage());
			}
			count += 4;
			currentElement.length += 4;
		}
	}

	public void addLabel(String label) {
		currentElement = new DataElement(count);
		labels.put(label, currentElement);
	}

	public ByteArrayOutputStream genByteStream(Linker linker) throws IOException {
		ArrayList dataList = new ArrayList(labels.values());
		Collections.sort(dataList, new DataElementComparator());
		ByteArrayOutputStream ostream = new ByteArrayOutputStream();
		Iterator it = dataList.iterator();
		while(it.hasNext()){
			DataElement data = (DataElement)(it.next());
			ostream.write(data.data.toByteArray());
		}
		ostream.flush();
		return ostream;
	}

	public int getLabelValue(String label) {
		int val = -1;
		if(labels.containsKey(label.substring(1))){
			val = ((DataElement)labels.get(label.substring(1))).offset + offset;
		}
		return val;
	}
	
	public void setOffset(int offset){
		this.offset = offset;
	}
	public int size(){
		return count;
	}

	public void outputAsXML(PrintWriter writer) throws IOException {
		Iterator it = labels.entrySet().iterator();
		while(it.hasNext()){
			Map.Entry data = (Map.Entry)(it.next());
			String label = (String)(data.getKey());
			((DataElement)data.getValue()).outputAsXML(writer, label);
		}
	}
	
	public void inputFromXML(Node node) throws XMLParserException{
		Node[] n = XMLParser.getNamedNodeArray(node, "data");
		for(int i = 0; i < n.length; i++){
			String label = XMLParser.getAttribute(n[i], "label").getNodeValue();
			labels.put(label, DataElement.inputFromXML(n[i]));
		}
	}
	
}
